/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.airflow;

import io.hops.hopsworks.common.airflow.AirflowOperatorDTO;
import io.hops.hopsworks.common.util.templates.airflow.AirflowDAG;
import io.hops.hopsworks.common.util.templates.airflow.AirflowJobLaunchOperator;
import io.hops.hopsworks.common.util.templates.airflow.AirflowJobSuccessSensor;
import io.hops.hopsworks.common.util.templates.airflow.AirflowOperator;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class AirflowDagDTO {
    private String name;
    private String scheduleInterval;
    private String apiKey;
    private List<AirflowOperatorDTO> operators;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getScheduleInterval() {
        return this.scheduleInterval;
    }

    public void setScheduleInterval(String scheduleInterval) {
        this.scheduleInterval = scheduleInterval;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public List<AirflowOperatorDTO> getOperators() {
        return this.operators;
    }

    public void setOperators(List<AirflowOperatorDTO> operators) {
        this.operators = operators;
    }

    public static AirflowDAG toAirflowDagTemplate(AirflowDagDTO dagDefinition, Users owner, Project project) {
        AirflowDAG dag = new AirflowDAG(dagDefinition.getName(), owner.getUsername(), project.getName());
        dag.setScheduleInterval(dagDefinition.getScheduleInterval());
        if (dagDefinition.getApiKey() != null) {
            dag.setApiKey(dagDefinition.getApiKey());
        }
        ArrayList<AirflowOperator> operators = new ArrayList<AirflowOperator>(dagDefinition.getOperators().size());
        for (AirflowOperatorDTO op : dagDefinition.getOperators()) {
            AirflowOperator operator = null;
            switch (op.getName()) {
                case "HopsworksLaunchOperator": {
                    operator = new AirflowJobLaunchOperator(project.getName(), op.getId(), op.getJobName(), op.getJobArgs());
                    ((AirflowJobLaunchOperator)operator).setWait(op.isWait());
                    break;
                }
                case "HopsworksJobSuccessSensor": {
                    operator = new AirflowJobSuccessSensor(project.getName(), op.getId(), op.getJobName());
                    break;
                }
            }
            if (operator == null) continue;
            if (op.getDependsOn() != null && !op.getDependsOn().isEmpty()) {
                StringBuilder sb = new StringBuilder();
                if (op.getDependsOn().size() == 1) {
                    sb.append(AirflowOperator.sanitizeId(op.getDependsOn().get(0)));
                } else {
                    sb.append("[");
                    for (String dependency : op.getDependsOn()) {
                        sb.append(AirflowOperator.sanitizeId(dependency)).append(",");
                    }
                    sb.append("]");
                }
                operator.setUpstream(sb.toString());
            }
            operators.add(operator);
        }
        dag.setOperators(operators);
        return dag;
    }
}

