/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.commands.featurestore.search;

import io.hops.hopsworks.common.commands.CommandException;
import io.hops.hopsworks.common.commands.featurestore.search.SearchFSCommandLogger;
import io.hops.hopsworks.common.commands.featurestore.search.SearchFSCommandStatus;
import io.hops.hopsworks.common.featurestore.FeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupFacade;
import io.hops.hopsworks.common.featurestore.featureview.FeatureViewFacade;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetFacade;
import io.hops.hopsworks.common.opensearch.OpenSearchClientController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.OpenSearchException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Startup
@Singleton
@DependsOn(value={"Settings"})
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class SearchFSReindexer {
    private static final Logger LOGGER = Logger.getLogger(SearchFSReindexer.class.getName());
    @EJB
    private OpenSearchClientController searchClient;
    @EJB
    private FeaturestoreFacade featurestoreFacade;
    @EJB
    private FeaturegroupFacade featureGroupFacade;
    @EJB
    private FeatureViewFacade featureViewFacade;
    @EJB
    private TrainingDatasetFacade trainingDatasetFacade;
    @EJB
    private SearchFSCommandLogger searchFSCommandLogger;

    public SearchFSCommandStatus status() {
        return new SearchFSCommandStatus(this.searchFSCommandLogger.count());
    }

    public void reindex() throws OpenSearchException, FeaturestoreException, CommandException {
        block4: {
            if (this.searchFSCommandLogger.count() != 0L) {
                String msg = "make sure command_search_fs is empty before trigerring a reindex";
                throw new CommandException(RESTCodes.CommandErrorCode.INVALID_SQL_QUERY, Level.INFO, msg);
            }
            LOGGER.info("reindexing featurestore search");
            try {
                this.searchClient.mngIndexDelete("featurestore");
            }
            catch (OpenSearchException e) {
                if (!e.getErrorCode().equals(RESTCodes.OpenSearchErrorCode.OPENSEARCH_INDEX_NOT_FOUND)) break block4;
                return;
            }
        }
        for (Featurestore featureStore : this.featurestoreFacade.findAll()) {
            this.reindex(featureStore);
        }
    }

    private void reindex(Featurestore featureStore) throws FeaturestoreException {
        for (Featuregroup featuregroup : this.featureGroupFacade.getByFeatureStore(featureStore, null)) {
            this.reindex(featuregroup);
        }
        for (FeatureView featureView : this.featureViewFacade.getByFeatureStore(featureStore, null)) {
            this.reindex(featureView);
        }
        for (TrainingDataset trainingDataset : this.trainingDatasetFacade.findByFeaturestore(featureStore)) {
            this.reindex(trainingDataset);
        }
    }

    private void reindex(Featuregroup featuregroup) throws FeaturestoreException {
        this.searchFSCommandLogger.create(featuregroup);
        this.searchFSCommandLogger.updateMetadata(featuregroup);
        this.searchFSCommandLogger.updateTags(featuregroup);
        this.searchFSCommandLogger.updateKeywords(featuregroup);
    }

    private void reindex(FeatureView featureView) throws FeaturestoreException {
        this.searchFSCommandLogger.create(featureView);
        this.searchFSCommandLogger.updateMetadata(featureView);
        this.searchFSCommandLogger.updateTags(featureView);
        this.searchFSCommandLogger.updateKeywords(featureView);
    }

    private void reindex(TrainingDataset trainingDataset) throws FeaturestoreException {
        this.searchFSCommandLogger.create(trainingDataset);
        this.searchFSCommandLogger.updateMetadata(trainingDataset);
        this.searchFSCommandLogger.updateTags(trainingDataset);
        this.searchFSCommandLogger.updateKeywords(trainingDataset);
    }
}

