/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.dataset;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetSharedWith;
import io.hops.hopsworks.persistence.entity.dataset.DatasetType;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import java.util.List;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class DatasetSharedWithFacade
extends AbstractFacade<DatasetSharedWith> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public DatasetSharedWithFacade() {
        super(DatasetSharedWith.class);
    }

    public List<DatasetSharedWith> findByDataset(Dataset dataset) {
        return this.em.createNamedQuery("DatasetSharedWith.findByDataset", DatasetSharedWith.class).setParameter("dataset", (Object)dataset).getResultList();
    }

    public List<DatasetSharedWith> findByProject(Project project) {
        return this.em.createNamedQuery("DatasetSharedWith.findByProject", DatasetSharedWith.class).setParameter("project", (Object)project).getResultList();
    }

    public DatasetSharedWith findByProjectAndDataset(Project project, Dataset dataset) {
        try {
            return (DatasetSharedWith)this.em.createNamedQuery("DatasetSharedWith.findByProjectAndDataset", DatasetSharedWith.class).setParameter("project", (Object)project).setParameter("dataset", (Object)dataset).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public AbstractFacade.CollectionInfo findAllDatasetByProject(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Set<? extends AbstractFacade.SortBy> sort, Project project) {
        String queryStr = this.buildQuery("SELECT d FROM DatasetSharedWith d ", filter, sort, "d.project = :project ");
        String queryCountStr = this.buildQuery("SELECT COUNT(DISTINCT d.id) FROM DatasetSharedWith d ", filter, null, "d.project = :project ");
        TypedQuery query = this.em.createQuery(queryStr, DatasetSharedWith.class).setParameter("project", (Object)project);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, DatasetSharedWith.class).setParameter("project", (Object)project);
        this.setFilter(filter, (Query)query);
        this.setFilter(filter, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case NAME: 
            case NAME_NEQ: 
            case NAME_LIKE: {
                q.setParameter(filterBy.getField(), (Object)filterBy.getParam());
                break;
            }
            case ACCEPTED: 
            case PUBLIC: 
            case SHARED: 
            case SEARCHABLE: {
                q.setParameter(filterBy.getField(), (Object)this.getBooleanValue(filterBy.getParam()));
                break;
            }
            case TYPE: {
                q.setParameter(filterBy.getField(), (Object)this.getEnumValue(filterBy.getField(), filterBy.getValue(), DatasetType.class));
                break;
            }
        }
    }

    public static enum Filters {
        NAME("NAME", "LOWER(d.dataset.name) LIKE LOWER(CONCAT(:name, '%')) ", "name", " "),
        NAME_NEQ("NAME_NEQ", "LOWER(d.dataset.name) NOT LIKE LOWER(CONCAT(:name_not_eq, '%')) ", "name_not_eq", " "),
        NAME_LIKE("NAME_LIKE", "LOWER(d.dataset.name) LIKE LOWER(CONCAT('%', :name_like, '%')) ", "name_like", " "),
        ACCEPTED("ACCEPTED", "d.accepted =:accepted ", "accepted", "true"),
        SHARED("SHARED", "true =:shared ", "shared", "true"),
        SEARCHABLE("SEARCHABLE", "d.dataset.searchable =:searchable ", "searchable", "0"),
        TYPE("TYPE", "d.dataset.dsType =:dsType ", "dsType", "DATASET"),
        PUBLIC("PUBLIC", "d.dataset.public =:public ", "public", "0");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        ID("ID", "d.dataset.id ", "ASC"),
        NAME("NAME", "LOWER(d.dataset.name) ", "ASC"),
        SEARCHABLE("SEARCHABLE", "d.dataset.searchable ", "ASC"),
        PUBLIC("PUBLIC", "d.dataset.public ", "ASC"),
        TYPE("TYPE", "d.dataset.dsType ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getJoin() {
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

