/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.kagent;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.InvalidQueryException;
import io.hops.hopsworks.persistence.entity.host.ServiceStatus;
import io.hops.hopsworks.persistence.entity.kagent.HostServices;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class HostServicesFacade
extends AbstractFacade<HostServices> {
    private static final Logger LOGGER = Logger.getLogger(HostServicesFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public HostServicesFacade() {
        super(HostServices.class);
    }

    public Optional<HostServices> findByHostnameServiceNameGroup(String hostname, String group, String name) {
        try {
            return Optional.of(this.em.createNamedQuery("HostServices.findByHostnameServiceNameGroup", HostServices.class).setParameter("hostname", (Object)hostname).setParameter("group", (Object)group).setParameter("name", (Object)name).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public List<HostServices> findGroupServices(String group) {
        return this.em.createNamedQuery("HostServices.findByGroup", HostServices.class).setParameter("group", (Object)group).getResultList();
    }

    public List<String> findGroups() {
        return this.em.createNamedQuery("HostServices.findGroups", String.class).getResultList();
    }

    public List<HostServices> findByHostname(String hostname) {
        return this.em.createNamedQuery("HostServices.findByHostname", HostServices.class).setParameter("hostname", (Object)hostname).getResultList();
    }

    public List<HostServices> findServices(String name) {
        return this.em.createNamedQuery("HostServices.findByServiceName", HostServices.class).setParameter("name", (Object)name).getResultList();
    }

    public Long countServices(String group) {
        return (Long)this.em.createNamedQuery("HostServices.CountServices", Long.class).setParameter("group", (Object)group).getSingleResult();
    }

    public Optional<HostServices> findByServiceName(String serviceName, String hostname) {
        try {
            return Optional.of(this.em.createNamedQuery("HostServices.findByServiceNameAndHostname", HostServices.class).setParameter("name", (Object)serviceName).setParameter("hostname", (Object)hostname).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public AbstractFacade.CollectionInfo findAll(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Set<? extends AbstractFacade.SortBy> sort) {
        String queryStr = this.buildQuery("SELECT DISTINCT h FROM HostServices h ", filter, sort, "");
        String queryCountStr = this.buildQuery("SELECT COUNT(DISTINCT h.id) FROM HostServices h ", filter, sort, "");
        TypedQuery query = this.em.createQuery(queryStr, HostServices.class);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, HostServices.class);
        this.setFilter(filter, (Query)query);
        this.setFilter(filter, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    public AbstractFacade.CollectionInfo findByHostname(String hostname, Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filter, Set<? extends AbstractFacade.SortBy> sort) {
        String queryStr = this.buildQuery("SELECT DISTINCT h FROM HostServices h ", filter, sort, "h.host.hostname = :hostname");
        String queryCountStr = this.buildQuery("SELECT COUNT(DISTINCT h.id) FROM HostServices h ", filter, sort, "h.host.hostname = :hostname");
        TypedQuery query = this.em.createQuery(queryStr, HostServices.class).setParameter("hostname", (Object)hostname);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, HostServices.class).setParameter("hostname", (Object)hostname);
        this.setFilter(filter, (Query)query);
        this.setFilter(filter, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case ID: {
                q.setParameter(filterBy.getField(), (Object)this.getLongValue(filterBy.getField(), filterBy.getParam()));
                break;
            }
            case HOST_ID: 
            case PID: {
                q.setParameter(filterBy.getField(), (Object)this.getIntValue(filterBy));
                break;
            }
            case NAME: 
            case GROUP_NAME: {
                q.setParameter(filterBy.getField(), (Object)filterBy.getParam());
                break;
            }
            case STATUS: {
                q.setParameter(filterBy.getField(), (Object)this.getStatusValue(filterBy.getField(), filterBy.getParam()));
                break;
            }
        }
    }

    private ServiceStatus getStatusValue(String field, String value) {
        ServiceStatus val;
        if (value == null || value.isEmpty()) {
            throw new InvalidQueryException("Filter value for " + field + " needs to set an Integer or a valid " + field + ", but found: " + value);
        }
        try {
            val = ServiceStatus.valueOf((String)value);
        }
        catch (IllegalArgumentException e) {
            try {
                val = ServiceStatus.valueOf((String)value);
            }
            catch (IllegalArgumentException ie) {
                throw new InvalidQueryException("Filter value for " + field + " needs to set an Integer or a valid " + field + ", but found: " + value);
            }
        }
        return val;
    }

    public static enum Filters {
        ID("ID", "h.id = :id", "id", "0"),
        HOST_ID("HOST_ID", "h.host_id = :hostId", "host_id", "0"),
        PID("PID", "h.pid = :pid", "pid", "0"),
        NAME("NAME", "h.name = :name", "name", ""),
        GROUP_NAME("GROUP_NAME", "h.group = :group_name", "group_name", ""),
        STATUS("STATUS", "h.status = :status", "status", "0");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        ID("ID", "h.id", "ASC"),
        HOST_ID("HOST_ID", "h.host.id", "ASC"),
        PID("PID", "h.pid", "ASC"),
        NAME("NAME", "LOWER(h.name)", "ASC"),
        GROUP_NAME("GROUP_NAME", "LOWER(h.group)", "ASC"),
        STATUS("STATUS", "h.status", "ASC"),
        UPTIME("UPTIME", "h.uptime", "ASC"),
        START_TIME("START_TIME", "h.startTime", "ASC"),
        STOP_TIME("STOP_TIME", "h.stopTime", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getJoin() {
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

