/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.embedding;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.featurestore.embedding.EmbeddingController;
import io.hops.hopsworks.common.featurestore.embedding.OpensearchVectorDatabaseConstrainedRetry;
import io.hops.hopsworks.common.opensearch.OpenSearchClient;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.OpenSearchException;
import io.hops.hopsworks.restutils.RESTCodes;
import io.hops.hopsworks.vectordb.VectorDatabase;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@DependsOn(value={"OpenSearchClient"})
public class VectorDatabaseClient {
    @EJB
    private OpenSearchClient openSearchClient;
    @EJB
    private OpensearchVectorDatabaseConstrainedRetry vectorDatabase;
    private static final Logger LOG = Logger.getLogger(EmbeddingController.class.getName());

    @PostConstruct
    public void init() {
        try {
            this.vectorDatabase.init(this.openSearchClient.getClient());
        }
        catch (ServiceDiscoveryException | OpenSearchException e) {
            this.vectorDatabase = null;
            LOG.log(Level.SEVERE, "Cannot create opensearch vectordb client");
        }
    }

    public synchronized VectorDatabase getClient() throws FeaturestoreException {
        if (this.vectorDatabase != null) {
            return this.vectorDatabase;
        }
        throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_FEATUREGROUP, Level.FINE, "Cannot create opensearch vectordb client.");
    }

    @PreDestroy
    private void close() {
        try {
            if (this.vectorDatabase != null) {
                this.vectorDatabase.close();
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }
}

