/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import io.hops.hopsworks.common.featurestore.FeaturestoreConstants;
import io.hops.hopsworks.common.featurestore.embedding.EmbeddingController;
import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.EmbeddingFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.online.OnlineFeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.stream.StreamFeatureGroupDTO;
import io.hops.hopsworks.common.featurestore.utils.FeaturestoreInputValidation;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.TimeTravelFormat;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.restutils.RESTCodes;
import io.hops.hopsworks.vectordb.Index;
import io.hops.hopsworks.vectordb.OpensearchVectorDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.lang.StringUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeatureGroupInputValidation {
    @EJB
    protected FeaturestoreInputValidation featureStoreInputValidation;
    @EJB
    protected OnlineFeaturegroupController onlineFeaturegroupController;
    @EJB
    protected EmbeddingController embeddingController;

    public FeatureGroupInputValidation() {
    }

    public FeatureGroupInputValidation(FeaturestoreInputValidation featureStoreInputValidation, OnlineFeaturegroupController onlineFeaturegroupController, EmbeddingController embeddingController) {
        this.featureStoreInputValidation = featureStoreInputValidation;
        this.onlineFeaturegroupController = onlineFeaturegroupController;
        this.embeddingController = embeddingController;
    }

    public void verifyUserInput(FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        this.featureStoreInputValidation.verifyUserInput(featuregroupDTO);
        this.verifyFeatureGroupFeatureList(featuregroupDTO.getFeatures());
    }

    public void verifyFeatureGroupFeatureList(List<FeatureGroupFeatureDTO> featureGroupFeatureDTOS) throws FeaturestoreException {
        if (featureGroupFeatureDTOS != null && !featureGroupFeatureDTOS.isEmpty()) {
            for (FeatureGroupFeatureDTO featureGroupFeatureDTO : featureGroupFeatureDTOS) {
                this.featureStoreInputValidation.nameValidation(featureGroupFeatureDTO.getName());
                this.featureStoreInputValidation.descriptionValidation(featureGroupFeatureDTO.getName(), featureGroupFeatureDTO.getDescription());
                this.verifyOfflineFeatureType(featureGroupFeatureDTO);
            }
        }
    }

    public void verifyOfflineFeatureType(FeatureGroupFeatureDTO feature) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)feature.getType())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_OFFLINE_TYPE_NOT_PROVIDED, Level.FINE, "There was no offline type provided for feature `" + feature.getName() + "`. Offline types are mandatory.");
        }
    }

    public void verifyEventTimeFeature(String name, List<FeatureGroupFeatureDTO> features) throws FeaturestoreException {
        if (name == null) {
            return;
        }
        Optional<FeatureGroupFeatureDTO> eventTimeFeature = features.stream().filter(feature -> feature.getName().equalsIgnoreCase(name)).findAny();
        if (eventTimeFeature.isPresent()) {
            if (!FeaturestoreConstants.EVENT_TIME_FEATURE_TYPES.contains(eventTimeFeature.get().getType().toUpperCase())) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_EVENT_TIME_FEATURE_TYPE, Level.FINE, ", the provided event time feature `" + name + "` is of type `" + eventTimeFeature.get().getType() + "` but can only be one of the following types: " + FeaturestoreConstants.EVENT_TIME_FEATURE_TYPES + ".");
            }
        } else {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.EVENT_TIME_FEATURE_NOT_FOUND, Level.FINE, ", the provided event time feature `" + name + "` was not found among the available features: " + features.stream().map(FeatureGroupFeatureDTO::getName).collect(Collectors.joining(", ")) + ".");
        }
    }

    public void verifySchemaProvided(FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        if (featuregroupDTO instanceof CachedFeaturegroupDTO && ((CachedFeaturegroupDTO)featuregroupDTO).getOnlineEnabled().booleanValue() && featuregroupDTO.getFeatures().isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_ONLINE_FEATUREGROUP, Level.SEVERE, "Cannot create an online feature group without a feature schema.");
        }
    }

    public void verifyNoDuplicatedFeatures(FeaturegroupDTO featureGroupDTO) throws FeaturestoreException {
        List duplicates = featureGroupDTO.getFeatures().stream().collect(Collectors.groupingBy(FeatureGroupFeatureDTO::getName, Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!duplicates.isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_GROUP_DUPLICATE_FEATURE, Level.SEVERE, String.format("Cannot create feature group as there are duplicated feature names: %s", StringUtils.join(duplicates, (String)", ")));
        }
    }

    public void verifyOnlineOfflineTypeMatch(FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        if (featuregroupDTO.getOnlineEnabled().booleanValue()) {
            if (featuregroupDTO.getEmbeddingIndex() != null) {
                return;
            }
            for (FeatureGroupFeatureDTO feature : featuregroupDTO.getFeatures()) {
                String onlineType;
                String offlineType = feature.getType().toLowerCase().replace(" ", "");
                if (offlineType.equals(onlineType = this.onlineFeaturegroupController.getOnlineType(feature).toLowerCase().replace(" ", "")) || offlineType.equals("int") && (onlineType.equals("tinyint") || onlineType.equals("smallint")) || offlineType.equals("boolean") && onlineType.equals("tinyint") || offlineType.equals("string") && (onlineType.startsWith("varchar") || onlineType.equals("text") || onlineType.equals("mediumtext") || onlineType.equals("longtext")) || (offlineType.startsWith("array") || offlineType.startsWith("struct") || offlineType.startsWith("binary") || offlineType.startsWith("map")) && (onlineType.startsWith("varbinary") || onlineType.equals("blob") || onlineType.equals("mediumblob") || onlineType.equals("longblob"))) continue;
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_ONLINE_FEATUREGROUP, Level.SEVERE, "Cannot create an online feature group because offline and online types are not compatible. Feature: " + feature.getName() + " (offline type '" + offlineType + "', online type '" + onlineType + "')");
            }
        }
    }

    public void verifyOnlineSchemaValid(FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        if (featuregroupDTO.getOnlineEnabled().booleanValue() && featuregroupDTO.getEmbeddingIndex() == null) {
            if (featuregroupDTO.getFeatures().size() > FeaturestoreConstants.MAX_MYSQL_COLUMNS) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_ONLINE_FEATUREGROUP, Level.SEVERE, "Cannot create an online feature group because it contains > " + FeaturestoreConstants.MAX_MYSQL_COLUMNS + " columns (provided: " + featuregroupDTO.getFeatures().size() + " columns).");
            }
            Integer totalBytes = 0;
            for (FeatureGroupFeatureDTO feature : featuregroupDTO.getFeatures()) {
                String onlineType = this.onlineFeaturegroupController.getOnlineType(feature).toLowerCase().replace(" ", "");
                totalBytes = totalBytes + this.estimateOnlineSize(onlineType);
            }
            if (totalBytes > FeaturestoreConstants.MAX_MYSQL_COLUMN_SIZE) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_ONLINE_FEATUREGROUP, Level.SEVERE, "Cannot create an online feature group because row size > " + FeaturestoreConstants.MAX_MYSQL_COLUMN_SIZE + " bytes (estimated size: " + totalBytes + " bytes).");
            }
        }
    }

    public void verifyPrimaryKeySupported(FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        if (featuregroupDTO.getOnlineEnabled().booleanValue() && featuregroupDTO.getEmbeddingIndex() == null) {
            Integer totalBytes = 0;
            for (FeatureGroupFeatureDTO feature : featuregroupDTO.getFeatures()) {
                if (!feature.getPrimary().booleanValue()) continue;
                String pkType = this.onlineFeaturegroupController.getOnlineType(feature).toLowerCase().replace(" ", "");
                Boolean found = false;
                for (String supportedName : FeaturestoreConstants.SUPPORTED_MYSQL_PRIMARY_KEYS) {
                    if (!pkType.startsWith(supportedName.toLowerCase())) continue;
                    found = true;
                    break;
                }
                totalBytes = totalBytes + this.estimateOnlineSize(pkType);
                if (found.booleanValue()) continue;
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_ONLINE_FEATUREGROUP, Level.SEVERE, "Cannot create an online feature group because primary key type is not supported. Feature: " + feature.getName() + " (offline type '" + feature.getType() + "', online type '" + this.onlineFeaturegroupController.getOnlineType(feature) + "')");
            }
            if (totalBytes > FeaturestoreConstants.MAX_MYSQL_PRIMARY_KEY_SIZE) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_ONLINE_FEATUREGROUP, Level.SEVERE, "Cannot create an online feature group because primary key is > " + FeaturestoreConstants.MAX_MYSQL_PRIMARY_KEY_SIZE + " bytes (estimated size: " + totalBytes + " bytes).");
            }
        }
    }

    private Integer estimateOnlineSize(String onlineFeatureType) {
        if (onlineFeatureType.equals("tinyint")) {
            return 1;
        }
        if (onlineFeatureType.equals("smallint")) {
            return 2;
        }
        if (onlineFeatureType.equals("int")) {
            return 4;
        }
        if (onlineFeatureType.equals("float")) {
            return 4;
        }
        if (onlineFeatureType.equals("bigint")) {
            return 8;
        }
        if (onlineFeatureType.equals("double")) {
            return 8;
        }
        if (onlineFeatureType.startsWith("decimal")) {
            return 16;
        }
        if (onlineFeatureType.equals("blob") || onlineFeatureType.equals("text")) {
            return 256;
        }
        if (onlineFeatureType.startsWith("varchar") && onlineFeatureType.contains("latin1")) {
            return Integer.parseInt(StringUtils.substringBetween((String)onlineFeatureType, (String)"(", (String)")"));
        }
        if (onlineFeatureType.startsWith("varchar")) {
            return Integer.parseInt(StringUtils.substringBetween((String)onlineFeatureType, (String)"(", (String)")")) * 4;
        }
        if (onlineFeatureType.startsWith("varbinary")) {
            return Math.round((float)Integer.parseInt(onlineFeatureType.replace("varbinary(", "").replace(")", "")) * 1.4f);
        }
        return 8;
    }

    public void verifyPartitionKeySupported(FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        if (featuregroupDTO instanceof CachedFeaturegroupDTO && ((CachedFeaturegroupDTO)featuregroupDTO).getTimeTravelFormat() == TimeTravelFormat.HUDI || featuregroupDTO instanceof StreamFeatureGroupDTO) {
            for (FeatureGroupFeatureDTO feature : featuregroupDTO.getFeatures()) {
                if (!feature.getPartition().booleanValue()) continue;
                String pkType = feature.getType().toLowerCase().replace(" ", "");
                Boolean found = false;
                for (String supportedName : FeaturestoreConstants.SUPPORTED_HUDI_PARTITION_KEYS) {
                    if (!pkType.startsWith(supportedName.toLowerCase())) continue;
                    found = true;
                    break;
                }
                if (found.booleanValue()) continue;
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_ONLINE_FEATUREGROUP, Level.SEVERE, "Cannot create an online feature group because partition key type is not supported. Feature: " + feature.getName() + " (offline type '" + feature.getType() + "')");
            }
        }
    }

    public List<FeatureGroupFeatureDTO> verifyAndGetNewFeatures(List<FeatureGroupFeatureDTO> previousSchema, List<FeatureGroupFeatureDTO> newSchema) throws FeaturestoreException {
        ArrayList<FeatureGroupFeatureDTO> newFeatures = new ArrayList<FeatureGroupFeatureDTO>();
        for (FeatureGroupFeatureDTO newFeature : newSchema) {
            boolean isNew = !previousSchema.stream().anyMatch(previousFeature -> previousFeature.getName().equals(newFeature.getName()));
            if (!isNew) continue;
            newFeatures.add(newFeature);
            if (newFeature.getPrimary().booleanValue() || newFeature.getPartition().booleanValue()) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_UPDATE, Level.FINE, "Appended feature `" + newFeature.getName() + "` is specified as primary or partition key. Primary key and partition key cannot be changed when appending features.");
            }
            if (newFeature.getType() != null) continue;
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_UPDATE, Level.FINE, "Appended feature `" + newFeature.getName() + "` is missing type information. Type information is mandatory when appending features to a feature group.");
        }
        return newFeatures;
    }

    public void verifyEmbeddingFeatureExist(FeaturegroupDTO featureGroupDTO) throws FeaturestoreException {
        Set features = featureGroupDTO.getFeatures().stream().map(FeatureGroupFeatureDTO::getName).collect(Collectors.toSet());
        if (featureGroupDTO.getEmbeddingIndex() != null) {
            for (EmbeddingFeatureDTO embeddingFeatureDTO : featureGroupDTO.getEmbeddingIndex().getFeatures()) {
                if (features.contains(embeddingFeatureDTO.getName())) continue;
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.EMBEDDING_FEATURE_NOT_FOUND, Level.FINE, String.format("Provided embedding index `%s` does not exist in the feature group.", embeddingFeatureDTO.getName()));
            }
        }
    }

    public void verifyEmbeddingIndexNotExist(Project project, FeaturegroupDTO featureGroupDTO) throws FeaturestoreException {
        if (featureGroupDTO.getEmbeddingIndex() != null) {
            this.embeddingController.verifyIndexName(project, featureGroupDTO.getEmbeddingIndex().getIndexName());
        }
    }

    public void verifyEmbeddingIndexName(FeaturegroupDTO featureGroupDTO) throws FeaturestoreException {
        if (featureGroupDTO.getEmbeddingIndex() != null && featureGroupDTO.getEmbeddingIndex().getIndexName() != null) {
            String[] forbiddenChars;
            String indexName = featureGroupDTO.getEmbeddingIndex().getIndexName();
            String errorMessage = String.format("Provided embedding index name `%s` is not valid. It should be 1. All letters must be lowercase.2. Index names cannot begin with _ or -.3. Index names can't contain specified special characters.", indexName);
            if (!indexName.equals(indexName.toLowerCase())) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INVALID_EMBEDDING_INDEX_NAME, Level.FINE, errorMessage);
            }
            if (indexName.startsWith("_") || indexName.startsWith("-")) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INVALID_EMBEDDING_INDEX_NAME, Level.FINE, errorMessage);
            }
            for (String forbiddenChar : forbiddenChars = new String[]{" ", ",", ":", "\"", "*", "+", "/", "\\", "|", "?", "#", ">", "<"}) {
                if (!indexName.contains(forbiddenChar)) continue;
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INVALID_EMBEDDING_INDEX_NAME, Level.FINE, errorMessage);
            }
        }
    }

    public void verifyVectorDatabaseIndexMappingLimit(Project project, FeaturegroupDTO featureGroupDTO, Integer numFeatures) throws FeaturestoreException {
        if (featureGroupDTO.getEmbeddingIndex() != null) {
            this.embeddingController.validateWithinMappingLimit(project, new Index(featureGroupDTO.getEmbeddingIndex().getIndexName()), numFeatures);
        }
    }

    public void verifyVectorDatabaseSupportedDataType(FeaturegroupDTO featureGroupDTO) throws FeaturestoreException {
        if (featureGroupDTO.getEmbeddingIndex() != null) {
            this.verifyVectorDatabaseSupportedDataType(featureGroupDTO.getFeatures());
        }
    }

    public void verifyVectorDatabaseSupportedDataType(List<FeatureGroupFeatureDTO> featureDTOS) throws FeaturestoreException {
        Set unsupportedFeatures = featureDTOS.stream().filter(f -> OpensearchVectorDatabase.getDataType((String)f.getType()) == null).collect(Collectors.toSet());
        if (unsupportedFeatures.size() > 0) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.VECTOR_DATABASE_DATA_TYPE_NOT_SUPPORTED, Level.FINE, "Vector database does not support data type in the following features: " + Joiner.on((String)", ").join((Iterable)unsupportedFeatures.stream().map(f -> f.getName() + ": " + f.getType()).collect(Collectors.toSet())));
        }
    }
}

