/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuremonitoring.config;

import io.hops.hopsworks.common.featurestore.FeaturestoreConstants;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuremonitoring.config.DescriptiveStatisticsComparisonConfigurationDTO;
import io.hops.hopsworks.common.featurestore.featuremonitoring.config.FeatureMonitoringConfigurationDTO;
import io.hops.hopsworks.common.featurestore.featuremonitoring.config.FeatureMonitoringConfigurationFacade;
import io.hops.hopsworks.common.featurestore.featuremonitoring.monitoringwindowconfiguration.MonitoringWindowConfigurationInputValidation;
import io.hops.hopsworks.common.featurestore.featureview.FeatureViewController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuremonitoring.config.FeatureMonitoringType;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetFeature;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeatureMonitoringConfigurationInputValidation {
    @EJB
    private FeatureMonitoringConfigurationFacade featureMonitoringConfigurationFacade;
    @EJB
    private FeaturegroupController featureGroupController;
    @EJB
    private FeatureViewController featureViewController;
    @EJB
    private MonitoringWindowConfigurationInputValidation monitoringWindowConfigurationInputValidation;
    public static final String FIELD_EXCEEDS_MAXIMAL_LENGTH_MESSAGE = "%s exceeds maximum length of %d characters in feature monitoring congiguration %s";
    public static final String FIELD_MUST_BE_NOT_NULL = "Field %s cannot be null if window config type is %s in feature monitoring congiguration %s";
    public static final String FIELD_MUST_BE_NULL = "Field %s must be null if window config type is %s in feature monitoring congiguration %s";

    public boolean validateConfigOnCreate(Users user, FeatureMonitoringConfigurationDTO dto, Featuregroup featureGroup, FeatureView featureView) throws FeaturestoreException {
        this.validateUniqueConfigNameForEntity(dto.getName(), featureGroup, featureView, false);
        this.validateConfigBasedOnFeatureMonitoringType(dto);
        if (dto.getFeatureName() != null) {
            this.validateFeatureNameExists(user, featureGroup, featureView, dto.getFeatureName());
        }
        this.validateConfigDtoFieldMaximalLength(dto);
        this.monitoringWindowConfigurationInputValidation.validateMonitoringWindowConfigDto(dto.getName(), dto.getDetectionWindowConfig());
        if (dto.getReferenceWindowConfig() != null) {
            this.monitoringWindowConfigurationInputValidation.validateMonitoringWindowConfigDto(dto.getName(), dto.getReferenceWindowConfig());
        }
        if (dto.getFeatureMonitoringType() == FeatureMonitoringType.STATISTICS_COMPARISON) {
            this.validateStatisticsComparisonConfig(dto.getName(), dto.getStatisticsComparisonConfig());
        }
        return true;
    }

    public boolean validateConfigOnUpdate(FeatureMonitoringConfigurationDTO dto, Featuregroup featureGroup, FeatureView featureView) {
        this.validateUniqueConfigNameForEntity(dto.getName(), featureGroup, featureView, true);
        this.validateConfigDtoFieldMaximalLength(dto);
        this.monitoringWindowConfigurationInputValidation.validateMonitoringWindowConfigDto(dto.getName(), dto.getDetectionWindowConfig());
        if (dto.getReferenceWindowConfig() != null) {
            this.monitoringWindowConfigurationInputValidation.validateMonitoringWindowConfigDto(dto.getName(), dto.getReferenceWindowConfig());
        }
        if (dto.getFeatureMonitoringType() == FeatureMonitoringType.STATISTICS_COMPARISON) {
            this.validateStatisticsComparisonConfig(dto.getName(), dto.getStatisticsComparisonConfig());
        }
        return true;
    }

    public void validateUniqueConfigNameForEntity(String name, Featuregroup featureGroup, FeatureView featureView, boolean onUpdate) {
        String userMessage = "";
        boolean toThrowOrNotToThrow = false;
        userMessage = onUpdate ? userMessage + " does not exist for " : userMessage + " already exists for ";
        if (featureGroup != null) {
            toThrowOrNotToThrow = this.featureMonitoringConfigurationFacade.findByFeatureGroupAndName(featureGroup, name).isPresent();
            userMessage = userMessage + "feature group " + featureGroup.getName();
        } else if (featureView != null) {
            toThrowOrNotToThrow = this.featureMonitoringConfigurationFacade.findByFeatureViewAndName(featureView, name).isPresent();
            userMessage = userMessage + "feature view " + featureView.getName();
        }
        if (onUpdate) {
            boolean bl = toThrowOrNotToThrow = !toThrowOrNotToThrow;
        }
        if (toThrowOrNotToThrow) {
            throw new IllegalArgumentException("A feature monitoring configuration with name " + name + userMessage);
        }
    }

    public void validateConfigDtoFieldMaximalLength(FeatureMonitoringConfigurationDTO dto) {
        if (dto.getName().length() > 128) {
            throw new IllegalArgumentException(String.format(FIELD_EXCEEDS_MAXIMAL_LENGTH_MESSAGE, "Name", 128, dto.getName()));
        }
        if (dto.getDescription() != null && dto.getDescription().length() > 2000) {
            throw new IllegalArgumentException(String.format(FIELD_EXCEEDS_MAXIMAL_LENGTH_MESSAGE, "Description", 2000, dto.getName()));
        }
        if (dto.getFeatureName() != null && dto.getFeatureName().length() > 63) {
            throw new IllegalArgumentException(String.format(FIELD_EXCEEDS_MAXIMAL_LENGTH_MESSAGE, "Feature name", 63, dto.getName()));
        }
    }

    public void validateFeatureNameExists(Users user, Featuregroup featureGroup, FeatureView featureView, String featureName) throws FeaturestoreException {
        if (featureGroup != null && !this.featureGroupController.getFeatureNames(featureGroup, featureGroup.getFeaturestore().getProject(), user).contains(featureName)) {
            throw new IllegalArgumentException("The feature group " + featureGroup.getName() + " does not contain a feature with name " + featureName);
        }
        if (featureView != null && !featureView.getFeatures().stream().map(TrainingDatasetFeature::getName).collect(Collectors.toList()).contains(featureName)) {
            throw new IllegalArgumentException("The feature view " + featureView.getName() + " does not contain a feature with name " + featureName);
        }
    }

    public void validateConfigBasedOnFeatureMonitoringType(FeatureMonitoringConfigurationDTO dto) {
        if (dto.getFeatureMonitoringType() == FeatureMonitoringType.STATISTICS_COMPUTATION) {
            if (dto.getStatisticsComparisonConfig() != null) {
                throw new IllegalArgumentException("Statistics comparison configuration of feature monitoring configuration " + dto.getName() + " must be null if feature monitoring type is " + FeatureMonitoringType.STATISTICS_COMPUTATION + ". Use feature monitoring API if you do not wish to compare statistics to a reference.");
            }
            if (dto.getReferenceWindowConfig() != null) {
                throw new IllegalArgumentException("Reference window configuration of feature monitoring configuration " + dto.getName() + " must be null if feature monitoring type is " + FeatureMonitoringType.STATISTICS_COMPUTATION + ". Use feature monitoring API if you do not wish to compare statistics to a reference.");
            }
        } else if (dto.getFeatureMonitoringType() == FeatureMonitoringType.STATISTICS_COMPARISON) {
            if (dto.getReferenceWindowConfig() == null) {
                throw new IllegalArgumentException("Reference window configuration of feature monitoring configuration " + dto.getName() + " cannot be null if feature monitoring type is " + FeatureMonitoringType.STATISTICS_COMPARISON + ". Use scheduled statistics API if you wish to compare statistics to a reference.");
            }
            if (dto.getFeatureName() == null) {
                throw new IllegalArgumentException("Feature name of feature monitoring configuration " + dto.getName() + " cannot be null if feature monitoring type is " + FeatureMonitoringType.STATISTICS_COMPARISON + ". Use monitoring statistics API to compute the statistics on a schedule of the whole entity or provide a feature name to use single feature monitoring.");
            }
            if (dto.getStatisticsComparisonConfig() == null) {
                throw new IllegalArgumentException("Statistics comparison configuration of feature monitoring configuration " + dto.getName() + " cannot be null if feature monitoring type is " + FeatureMonitoringType.STATISTICS_COMPARISON + ". Use scheduled statistics API if you wish to compare statistics to a reference.");
            }
        }
    }

    public void validateStatisticsComparisonConfig(String configName, DescriptiveStatisticsComparisonConfigurationDTO dto) {
        if (!FeaturestoreConstants.ALLOWED_METRICS_IN_STATISTICS_COMPARISON_CONFIG.contains(dto.getMetric().toString())) {
            throw new IllegalArgumentException("The metric " + dto.getMetric() + " is not allowed in statistics comparison configuration " + configName + " allowed metrics are: " + FeaturestoreConstants.ALLOWED_METRICS_IN_STATISTICS_COMPARISON_CONFIG);
        }
    }
}

