/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuremonitoring.monitoringwindowconfiguration;

import io.hops.hopsworks.common.featurestore.FeaturestoreConstants;
import io.hops.hopsworks.common.featurestore.featuremonitoring.monitoringwindowconfiguration.MonitoringWindowConfigurationDTO;
import io.hops.hopsworks.persistence.entity.featurestore.featuremonitoring.config.WindowConfigurationType;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class MonitoringWindowConfigurationInputValidation {
    private static final String FIELD_SPECIFIC_VALUE = "specificValue";
    private static final String FIELD_ROW_PERCENTAGE = "rowPercentage";
    private static final String FIELD_WINDOW_LENGTH = "windowLength";
    private static final String FIELD_TIME_OFFSET = "timeOffset";
    private static final String FIELD_TRAINING_DATASET_VERSION = "trainingDatasetVersion";
    private static final String FIELD_EXCEEDS_MAXIMAL_LENGTH_MESSAGE = "%s exceeds maximum length of %d characters in feature monitoring congiguration %s";
    private static final String FIELD_MUST_BE_NOT_NULL = "Field %s cannot be null if window config type is %s in feature monitoring congiguration %s";
    private static final String FIELD_MUST_BE_NULL = "Field %s must be null if window config type is %s in feature monitoring congiguration %s";

    public boolean validateMonitoringWindowConfigDto(String configName, MonitoringWindowConfigurationDTO dto) {
        this.validateMonitoringWindowConfigDtoNullFieldBasedOnType(configName, dto);
        if (dto.getWindowConfigType() == WindowConfigurationType.ROLLING_TIME) {
            this.validateMonitoringWindowConfigDtoFieldMaximalLength(configName, dto);
            this.validateTimeOffsetAndWindowLengthBasedOnRegex(configName, dto);
        }
        if (dto.getWindowConfigType() == WindowConfigurationType.ROLLING_TIME || dto.getWindowConfigType() == WindowConfigurationType.ALL_TIME) {
            this.validateRowPercentage(configName, dto.getRowPercentage());
        }
        return true;
    }

    public void validateMonitoringWindowConfigDtoNullFieldBasedOnType(String configName, MonitoringWindowConfigurationDTO dto) {
        if (dto.getWindowConfigType() == WindowConfigurationType.SPECIFIC_VALUE) {
            this.fieldToBeOrNotToBeNull(configName, dto, FIELD_SPECIFIC_VALUE, false);
            this.fieldToBeOrNotToBeNull(configName, dto, FIELD_ROW_PERCENTAGE, true);
            this.fieldToBeOrNotToBeNull(configName, dto, FIELD_WINDOW_LENGTH, true);
            this.fieldToBeOrNotToBeNull(configName, dto, FIELD_TIME_OFFSET, true);
            this.fieldToBeOrNotToBeNull(configName, dto, FIELD_TRAINING_DATASET_VERSION, true);
        } else if (dto.getWindowConfigType() == WindowConfigurationType.TRAINING_DATASET) {
            this.fieldToBeOrNotToBeNull(configName, dto, FIELD_TRAINING_DATASET_VERSION, false);
            this.fieldToBeOrNotToBeNull(configName, dto, FIELD_ROW_PERCENTAGE, true);
            this.fieldToBeOrNotToBeNull(configName, dto, FIELD_WINDOW_LENGTH, true);
            this.fieldToBeOrNotToBeNull(configName, dto, FIELD_TIME_OFFSET, true);
            this.fieldToBeOrNotToBeNull(configName, dto, FIELD_SPECIFIC_VALUE, true);
        } else if (dto.getWindowConfigType() == WindowConfigurationType.ALL_TIME) {
            this.fieldToBeOrNotToBeNull(configName, dto, FIELD_ROW_PERCENTAGE, false);
            this.fieldToBeOrNotToBeNull(configName, dto, FIELD_TIME_OFFSET, true);
            this.fieldToBeOrNotToBeNull(configName, dto, FIELD_WINDOW_LENGTH, true);
            this.fieldToBeOrNotToBeNull(configName, dto, FIELD_SPECIFIC_VALUE, true);
            this.fieldToBeOrNotToBeNull(configName, dto, FIELD_TRAINING_DATASET_VERSION, true);
        } else if (dto.getWindowConfigType() == WindowConfigurationType.ROLLING_TIME) {
            this.fieldToBeOrNotToBeNull(configName, dto, FIELD_ROW_PERCENTAGE, false);
            this.fieldToBeOrNotToBeNull(configName, dto, FIELD_TIME_OFFSET, false);
            this.fieldToBeOrNotToBeNull(configName, dto, FIELD_TRAINING_DATASET_VERSION, true);
            this.fieldToBeOrNotToBeNull(configName, dto, FIELD_SPECIFIC_VALUE, true);
        }
    }

    public void fieldToBeOrNotToBeNull(String configName, MonitoringWindowConfigurationDTO dto, String fieldName, boolean mustBeNull) {
        boolean isNull = false;
        switch (fieldName) {
            case "specificValue": {
                if (dto.getSpecificValue() == null) break;
                isNull = true;
                break;
            }
            case "rowPercentage": {
                if (dto.getRowPercentage() == null) break;
                isNull = true;
                break;
            }
            case "windowLength": {
                if (dto.getWindowLength() == null) break;
                isNull = true;
                break;
            }
            case "timeOffset": {
                if (dto.getTimeOffset() == null) break;
                isNull = true;
                break;
            }
            case "trainingDatasetVersion": {
                if (dto.getTrainingDatasetVersion() == null) break;
                isNull = true;
                break;
            }
        }
        if (isNull && mustBeNull) {
            throw new IllegalArgumentException(String.format(FIELD_MUST_BE_NULL, fieldName, dto.getWindowConfigType().toString(), configName));
        }
        if (!isNull && !mustBeNull) {
            throw new IllegalArgumentException(String.format(FIELD_MUST_BE_NOT_NULL, fieldName, dto.getWindowConfigType().toString(), configName));
        }
    }

    public void validateMonitoringWindowConfigDtoFieldMaximalLength(String configName, MonitoringWindowConfigurationDTO dto) {
        if (dto.getWindowLength() != null && dto.getWindowLength().length() > 63) {
            throw new IllegalArgumentException(String.format(FIELD_EXCEEDS_MAXIMAL_LENGTH_MESSAGE, "Window length", 63, configName));
        }
        if (dto.getTimeOffset().length() > 63) {
            throw new IllegalArgumentException(String.format(FIELD_EXCEEDS_MAXIMAL_LENGTH_MESSAGE, "Time offset", 63, configName));
        }
    }

    public void validateRowPercentage(String configName, Float rowPercentage) {
        if (rowPercentage.floatValue() < 0.0f || rowPercentage.floatValue() > 1.0f) {
            throw new IllegalArgumentException("Row percentage of monitoring configuration " + configName + " must be a float between 0 and 1, not" + rowPercentage);
        }
    }

    public void validateTimeOffsetAndWindowLengthBasedOnRegex(String configName, MonitoringWindowConfigurationDTO dto) {
        if (dto.getWindowConfigType() == WindowConfigurationType.ROLLING_TIME) {
            if (FeaturestoreConstants.INVALID_MONITORING_WINDOW_CONFIG_TIME_RANGE_REGEX.matcher(dto.getTimeOffset()).matches() || !FeaturestoreConstants.VALID_MONITORING_WINDOW_CONFIG_TIME_RANGE_REGEX.matcher(dto.getTimeOffset()).matches()) {
                throw new IllegalArgumentException("Time offset of monitoring configuration " + configName + " must be in format 1w2d3h for 1 week 2 day 3 hours.");
            }
            if (dto.getWindowLength() != null && (FeaturestoreConstants.INVALID_MONITORING_WINDOW_CONFIG_TIME_RANGE_REGEX.matcher(dto.getWindowLength()).matches() || !FeaturestoreConstants.VALID_MONITORING_WINDOW_CONFIG_TIME_RANGE_REGEX.matcher(dto.getWindowLength()).matches())) {
                throw new IllegalArgumentException("Window length of monitoring configuration " + configName + " must be in format 1w2d3h for 1 week 2 day 3 hours.");
            }
        }
    }
}

