/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuremonitoring.result;

import io.hops.hopsworks.common.featurestore.featuremonitoring.alert.FeatureMonitoringAlertController;
import io.hops.hopsworks.common.featurestore.featuremonitoring.config.FeatureMonitoringConfigurationController;
import io.hops.hopsworks.common.featurestore.featuremonitoring.result.FeatureMonitoringResultFacade;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.featuremonitoring.config.FeatureMonitoringConfiguration;
import io.hops.hopsworks.persistence.entity.featurestore.featuremonitoring.result.FeatureMonitoringResult;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeatureMonitoringResultController {
    private static final Logger LOGGER = Logger.getLogger(FeatureMonitoringResultController.class.getName());
    @EJB
    FeatureMonitoringResultFacade featureMonitoringResultFacade;
    @EJB
    FeatureMonitoringConfigurationController featureMonitoringConfigurationController;
    @EJB
    FeatureMonitoringAlertController featureMonitoringAlertController;

    public FeatureMonitoringResult createFeatureMonitoringResult(FeatureMonitoringResult result) {
        this.featureMonitoringResultFacade.save(result);
        try {
            this.featureMonitoringAlertController.triggerAlertsByStatus(result.getFeatureMonitoringConfig(), result);
        }
        catch (FeaturestoreException e) {
            LOGGER.log(Level.SEVERE, String.format("Error triggering alerts for Feature Monitoring Result with id: %d error message: %s", result.getId(), e.getUsrMsg()), e);
        }
        return result;
    }

    public FeatureMonitoringResult getFeatureMonitoringResultById(Integer resultId) throws FeaturestoreException {
        Optional<FeatureMonitoringResult> optResult = this.featureMonitoringResultFacade.findById(resultId);
        if (!optResult.isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_MONITORING_ENTITY_NOT_FOUND, Level.WARNING, String.format("Feature Monitoring Result with id %d not found.", resultId));
        }
        return optResult.get();
    }

    public void deleteFeatureMonitoringResult(Integer resultId) throws FeaturestoreException {
        Optional<FeatureMonitoringResult> optResult = this.featureMonitoringResultFacade.findById(resultId);
        if (!optResult.isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_MONITORING_ENTITY_NOT_FOUND, Level.WARNING, String.format("Feature Monitoring Result with id %d not found.", resultId));
        }
        this.featureMonitoringResultFacade.remove(optResult.get());
    }

    public AbstractFacade.CollectionInfo<FeatureMonitoringResult> getAllFeatureMonitoringResultByConfigId(Integer offset, Integer limit, Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, Integer configId) throws FeaturestoreException {
        FeatureMonitoringConfiguration config = this.featureMonitoringConfigurationController.getFeatureMonitoringConfigurationByConfigId(configId);
        return this.featureMonitoringResultFacade.findByConfigId(offset, limit, sorts, filters, config);
    }
}

