/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuremonitoring.result;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuremonitoring.config.FeatureMonitoringConfiguration;
import io.hops.hopsworks.persistence.entity.featurestore.featuremonitoring.result.FeatureMonitoringResult;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class FeatureMonitoringResultFacade
extends AbstractFacade<FeatureMonitoringResult> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public FeatureMonitoringResultFacade() {
        super(FeatureMonitoringResult.class);
    }

    public Optional<FeatureMonitoringResult> findById(Integer resultId) {
        try {
            return Optional.of(this.em.createNamedQuery("FeatureMonitoringResult.findByResultId", FeatureMonitoringResult.class).setParameter("resultId", (Object)resultId).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public AbstractFacade.CollectionInfo<FeatureMonitoringResult> findByConfigId(Integer offset, Integer limit, Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, FeatureMonitoringConfiguration config) {
        String queryStr = this.buildQuery("SELECT result from FeatureMonitoringResult result ", filters, sorts, "result.featureMonitoringConfig=:config");
        String queryCountStr = this.buildQuery("SELECT COUNT(result.id) from FeatureMonitoringResult result ", filters, sorts, "result.featureMonitoringConfig=:config");
        TypedQuery query = this.em.createQuery(queryStr, FeatureMonitoringResult.class).setParameter("config", (Object)config);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, FeatureMonitoringResult.class).setParameter("config", (Object)config);
        this.setFilter(filters, (Query)query);
        this.setFilter(filters, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            q.setParameter(filterBy.getField(), (Object)new Timestamp(Long.parseLong(filterBy.getParam())));
        }
    }

    public static enum Filters {
        MONITORING_TIME_GT("MONITORING_TIME_GT", "result.monitoringTime > :monitoringTimeGt ", "monitoringTimeGt", ""),
        MONITORING_TIME_LT("MONITORING_TIME_LT", "result.monitoringTime < :monitoringTimeLt ", "monitoringTimeLt", ""),
        MONITORING_TIME_GTE("MONITORING_TIME_GTE", "result.monitoringTime >= :monitoringTimeGte ", "monitoringTimeGte", ""),
        MONITORING_TIME_LTE("MONITORING_TIME_LTE", "result.monitoringTime <= :monitoringTimeLte ", "monitoringTimeLte", ""),
        MONITORING_TIME_EQ("MONITORING_TIME_EQ", "result.monitoringTime = :monitoringTimeEq", "monitoringTimeEq", "");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        MONITORING_TIME("MONITORING_TIME", "result.monitoringTime ", "DESC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String toString() {
            return this.value;
        }
    }
}

