/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuremonitoring.result;

import io.hops.hopsworks.common.featurestore.featuremonitoring.config.FeatureMonitoringConfigurationController;
import io.hops.hopsworks.common.featurestore.featuremonitoring.result.FeatureMonitoringResultDTO;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.featuremonitoring.config.FeatureMonitoringConfiguration;
import io.hops.hopsworks.persistence.entity.featurestore.featuremonitoring.config.FeatureMonitoringType;
import io.hops.hopsworks.persistence.entity.featurestore.featuremonitoring.config.WindowConfigurationType;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeatureMonitoringResultInputValidation {
    @EJB
    private FeatureMonitoringConfigurationController featureMonitoringConfigurationController;

    public boolean validateOnCreate(FeatureMonitoringResultDTO resultDto) throws FeaturestoreException {
        if (resultDto.getConfigId() == null) {
            throw new IllegalArgumentException("Feature monitoring config ID not provided");
        }
        if (resultDto.getRaisedException().equals(true)) {
            return true;
        }
        this.validateDetectionStatsField(resultDto);
        FeatureMonitoringConfiguration config = this.featureMonitoringConfigurationController.getFeatureMonitoringConfigurationByConfigId(resultDto.getConfigId());
        this.validateReferenceStatsField(config, resultDto);
        this.validateDifferenceField(config, resultDto);
        return true;
    }

    private void validateDetectionStatsField(FeatureMonitoringResultDTO resultDto) {
        if (resultDto.getDetectionStatisticsId() == null) {
            throw new IllegalArgumentException("Descriptive statistics id not provided for the detection window.");
        }
        if (resultDto.getDetectionStatistics() != null) {
            throw new IllegalArgumentException("Descriptive statistics for the detection window should be registered prior to the monitoring result.");
        }
    }

    private void validateReferenceStatsField(FeatureMonitoringConfiguration config, FeatureMonitoringResultDTO resultDto) {
        boolean hasReferenceField;
        if (resultDto.getReferenceStatistics() != null) {
            throw new IllegalArgumentException("Descriptive statistics for the reference window should be registered prior to the monitoring result.");
        }
        boolean bl = hasReferenceField = resultDto.getReferenceStatisticsId() != null || resultDto.getSpecificValue() != null;
        if (config.getFeatureMonitoringType().equals((Object)FeatureMonitoringType.STATISTICS_COMPUTATION) && hasReferenceField) {
            throw new IllegalArgumentException("Statistics Monitoring configuration " + config.getName() + " cannot have results with specific value or reference statistics id field.");
        }
        if (config.getFeatureMonitoringType().equals((Object)FeatureMonitoringType.STATISTICS_COMPUTATION) && !hasReferenceField) {
            return;
        }
        if (config.getReferenceWindowConfig().getWindowConfigType().equals((Object)WindowConfigurationType.SPECIFIC_VALUE) && resultDto.getSpecificValue() == null) {
            throw new IllegalArgumentException("Feature monitoring configuration " + config.getName() + " result cannot have null specific value field when the reference window is configured to use specific value.");
        }
        if (!config.getReferenceWindowConfig().getWindowConfigType().equals((Object)WindowConfigurationType.SPECIFIC_VALUE) && resultDto.getSpecificValue() != null) {
            throw new IllegalArgumentException("Feature monitoring configuration " + config.getName() + " result cannot have non-null specific value field when the reference window is configured to use descriptive statistics.");
        }
        if (config.getReferenceWindowConfig().getWindowConfigType().equals((Object)WindowConfigurationType.SPECIFIC_VALUE) && resultDto.getSpecificValue() != null) {
            return;
        }
        if (config.getReferenceWindowConfig().getWindowConfigType().equals((Object)WindowConfigurationType.TRAINING_DATASET) && resultDto.getReferenceStatisticsId() == null) {
            throw new IllegalArgumentException("Feature monitoring configuration " + config.getName() + " result cannot have null reference statistics id field when the reference window is configured to use training dataset.");
        }
        if (config.getReferenceWindowConfig().getWindowConfigType().equals((Object)WindowConfigurationType.TRAINING_DATASET)) {
            return;
        }
    }

    private void validateDifferenceField(FeatureMonitoringConfiguration config, FeatureMonitoringResultDTO resultDTO) {
        if (config.getFeatureMonitoringType().equals((Object)FeatureMonitoringType.STATISTICS_COMPUTATION) && resultDTO.getDifference() != null) {
            throw new IllegalArgumentException("Statistics Monitoring configuration " + config.getName() + " cannot have results with non-null difference field.");
        }
        if ((resultDTO.getEmptyDetectionWindow().booleanValue() || resultDTO.getEmptyReferenceWindow().booleanValue()) && resultDTO.getDifference() != null && resultDTO.getSpecificValue() == null) {
            throw new IllegalArgumentException("Feature Monitoring configuration " + config.getName() + " cannot have results with an empty window and non-null difference field.");
        }
    }
}

