/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featureview;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.QueryParam;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class FeatureViewFacade
extends AbstractFacade<FeatureView> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public FeatureViewFacade() {
        super(FeatureView.class);
    }

    public List<FeatureView> findAll() {
        TypedQuery q = this.em.createNamedQuery("FeatureView.findAll", FeatureView.class);
        return q.getResultList();
    }

    public AbstractFacade.CollectionInfo findByFeatureStore(Featurestore featurestore, QueryParam queryParam) {
        return new AbstractFacade.CollectionInfo(this.countByFeatureStore(featurestore, queryParam), this.getByFeatureStore(featurestore, queryParam));
    }

    public List<FeatureView> getByFeatureStore(Featurestore featurestore, QueryParam queryParam) {
        HashMap<String, Object> extraParam = new HashMap<String, Object>();
        extraParam.put("featurestore", featurestore);
        String queryStr = this.buildQuery("SELECT fv FROM FeatureView fv ", queryParam != null ? queryParam.getFilters() : null, queryParam != null ? queryParam.getSorts() : null, "fv.featurestore = :featurestore ");
        Query q = this.makeQuery(queryStr, queryParam, extraParam);
        return q.getResultList();
    }

    public Long countByFeatureStore(Featurestore featurestore, QueryParam queryParam) {
        String queryStr = this.buildQuery("SELECT count(fv.id) FROM FeatureView fv ", queryParam != null ? queryParam.getFilters() : null, null, "fv.featurestore = :featurestore ");
        TypedQuery query = this.em.createQuery(queryStr, Long.class).setParameter("featurestore", (Object)featurestore);
        if (queryParam != null) {
            this.setFilter(queryParam.getFilters(), (Query)query);
        }
        return (Long)query.getSingleResult();
    }

    public Optional<FeatureView> findByIdAndFeatureStore(Integer id, Featurestore featureStore) {
        try {
            return Optional.of(this.em.createNamedQuery("FeatureView.findByIdAndFeaturestore", FeatureView.class).setParameter("id", (Object)id).setParameter("featurestore", (Object)featureStore).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<FeatureView> findByNameVersionAndFeaturestore(String name, Integer version, Featurestore featureStore) {
        try {
            return Optional.of(this.em.createNamedQuery("FeatureView.findByNameVersionAndFeaturestore", FeatureView.class).setParameter("name", (Object)name).setParameter("version", (Object)version).setParameter("featurestore", (Object)featureStore).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Integer findLatestVersion(String name, Featurestore featurestore) {
        TypedQuery query = this.em.createNamedQuery("FeatureView.findMaxVersionByFeaturestoreAndName", Integer.class);
        query.setParameter("name", (Object)name);
        query.setParameter("featurestore", (Object)featurestore);
        return (Integer)query.getSingleResult();
    }

    public List<FeatureView> findByFeatureGroup(Integer featureGroupId) {
        return this.em.createNamedQuery("FeatureView.findByFeatureGroup", FeatureView.class).setParameter("featureGroupId", (Object)featureGroupId).getResultList();
    }

    private Query makeQuery(String queryStr, QueryParam queryParam, Map<String, Object> extraParam) {
        TypedQuery query = this.em.createQuery(queryStr, FeatureView.class);
        if (queryParam != null) {
            this.setFilter(queryParam.getFilters(), (Query)query);
            this.setOffsetAndLim(queryParam.getOffset(), queryParam.getLimit(), (Query)query);
        }
        if (extraParam != null) {
            for (Map.Entry<String, Object> item : extraParam.entrySet()) {
                query.setParameter(item.getKey(), item.getValue());
            }
        }
        return query;
    }

    private void setFilter(Set<AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy aFilter : filter) {
            this.setFilterQuery(aFilter, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.toString())) {
            case NAME: 
            case NAME_LIKE: {
                q.setParameter(filterBy.getParam(), (Object)filterBy.getValue());
                break;
            }
            case VERSION: {
                q.setParameter(filterBy.getParam(), (Object)Integer.valueOf(filterBy.getValue()));
                break;
            }
        }
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public static enum Sorts {
        ID("ID", "fv.id ", "ASC"),
        NAME("NAME", "fv.name ", "ASC"),
        VERSION("VERSION", "fv.version ", "ASC"),
        CREATION("CREATION", "fv.created ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Filters {
        NAME("NAME", String.format("%s.name = :%%s ", "fv"), "name", ""),
        NAME_LIKE("NAME_LIKE", String.format("%s.name LIKE CONCAT('%%%%', :%%s, '%%%%') ", "fv"), "name", ""),
        VERSION("VERSION", String.format("%s.version = :%%s ", "fv"), "version", ""),
        LATEST_VERSION("LATEST_VERSION", String.format("%1$s.version = ( SELECT MAX(%2$s.version) FROM FeatureView %2$s WHERE %1$s.name = %2$s.name AND %1$s.featurestore = %2$s.featurestore ) ", "fv", "fv2"), null, null);

        private final String name;
        private final String sql;
        private final String field;
        private final String defaultValue;

        private Filters(String name, String sql, String field, String defaultValue) {
            this.name = name;
            this.sql = sql;
            this.field = field;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.name;
        }
    }
}

