/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.statistics;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.featurestore.statistics.StatisticsFilters;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.FeatureGroupStatistics;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class FeatureGroupStatisticsFacade
extends AbstractFacade<FeatureGroupStatistics> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public FeatureGroupStatisticsFacade() {
        super(FeatureGroupStatistics.class);
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public AbstractFacade.CollectionInfo<FeatureGroupStatistics> findByFeaturegroup(Integer offset, Integer limit, Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, Featuregroup featuregroup) {
        String queryStr = this.buildQuery("SELECT s from FeatureGroupStatistics s ", filters, sorts, "s.featureGroup = :featureGroup");
        String queryCountStr = this.buildQuery("SELECT COUNT(s.id) from FeatureGroupStatistics s ", filters, sorts, "s.featureGroup = :featureGroup");
        TypedQuery query = this.em.createQuery(queryStr, FeatureGroupStatistics.class).setParameter("featureGroup", (Object)featuregroup);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, FeatureGroupStatistics.class).setParameter("featureGroup", (Object)featuregroup);
        StatisticsFilters.setFilter(filters, (Query)query);
        StatisticsFilters.setFilter(filters, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    public AbstractFacade.CollectionInfo<FeatureGroupStatistics> findByFeaturegroupWithFeatureNames(Integer offset, Integer limit, Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, Set<String> featureNames, Featuregroup featuregroup) throws FeaturestoreException {
        Object fNsParamValue;
        String fNsOperator;
        if (featureNames.size() > 1) {
            fNsOperator = "IN";
            fNsParamValue = featureNames;
        } else {
            fNsOperator = "=";
            fNsParamValue = featureNames.iterator().next();
        }
        if (limit != null) {
            return this.findByFeaturegroupWithFeatureNames(offset, limit, sorts, filters, fNsOperator, fNsParamValue, featuregroup);
        }
        return this.findByFeaturegroupWithFeatureNames(sorts, filters, fNsOperator, fNsParamValue, featuregroup);
    }

    private AbstractFacade.CollectionInfo<FeatureGroupStatistics> findByFeaturegroupWithFeatureNames(Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, String fNsOperator, Object fNsParamValue, Featuregroup featuregroup) throws FeaturestoreException {
        String queryStr = this.buildQuery("SELECT DISTINCT s from FeatureGroupStatistics s LEFT JOIN FETCH s.featureDescriptiveStatistics fds ", filters, sorts, "s.featureGroup = :featureGroup AND fds.featureName " + fNsOperator + " :featureName");
        String queryCountStr = this.buildQuery("SELECT COUNT(DISTINCT s.id) from FeatureGroupStatistics s LEFT JOIN FETCH s.featureDescriptiveStatistics fds ", filters, sorts, "s.featureGroup = :featureGroup AND fds.featureName " + fNsOperator + " :featureName");
        TypedQuery query = this.em.createQuery(queryStr, FeatureGroupStatistics.class).setParameter("featureGroup", (Object)featuregroup).setParameter("featureName", fNsParamValue);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, FeatureGroupStatistics.class).setParameter("featureGroup", (Object)featuregroup).setParameter("featureName", fNsParamValue);
        StatisticsFilters.setFilter(filters, (Query)query);
        StatisticsFilters.setFilter(filters, (Query)queryCount);
        long count = (Long)queryCount.getSingleResult();
        if (count == 0L) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.STATISTICS_NOT_FOUND, Level.FINE, "Statistics for feature group id '" + featuregroup.getId() + "' not found. Please, try again with different filters.");
        }
        return new AbstractFacade.CollectionInfo(Long.valueOf(count), query.getResultList());
    }

    private AbstractFacade.CollectionInfo<FeatureGroupStatistics> findByFeaturegroupWithFeatureNames(Integer offset, Integer limit, Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, String fNsOperator, Object fNsParamValue, Featuregroup featuregroup) throws FeaturestoreException {
        String fgsQueryStr = this.buildQuery("SELECT DISTINCT s.id from FeatureGroupStatistics s LEFT JOIN s.featureDescriptiveStatistics fds ", filters, sorts, "s.featureGroup = :featureGroup AND fds.featureName " + fNsOperator + " :featureName");
        String fgsQueryCountStr = this.buildQuery("SELECT COUNT(DISTINCT s.id) from FeatureGroupStatistics s LEFT JOIN s.featureDescriptiveStatistics fds ", filters, sorts, "s.featureGroup = :featureGroup AND fds.featureName " + fNsOperator + " :featureName");
        Query fgsQuery = this.em.createQuery(fgsQueryStr).setParameter("featureGroup", (Object)featuregroup).setParameter("featureName", fNsParamValue);
        Query fgsQueryCount = this.em.createQuery(fgsQueryCountStr).setParameter("featureGroup", (Object)featuregroup).setParameter("featureName", fNsParamValue);
        StatisticsFilters.setFilter(filters, fgsQuery);
        this.setOffsetAndLim(offset, limit, fgsQuery);
        StatisticsFilters.setFilter(filters, fgsQueryCount);
        long count = (Long)fgsQueryCount.getSingleResult();
        if (count == 0L) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.STATISTICS_NOT_FOUND, Level.FINE, "Statistics for feature group id '" + featuregroup.getId() + "' not found. Please, try again with different filters.");
        }
        Set fgsIds = fgsQuery.getResultList().stream().collect(Collectors.toSet());
        String queryStr = this.buildQuery("SELECT DISTINCT s from FeatureGroupStatistics s LEFT JOIN FETCH s.featureDescriptiveStatistics fds ", filters, sorts, "s.id IN :fgsIds AND fds.featureName " + fNsOperator + " :featureName");
        TypedQuery query = this.em.createQuery(queryStr, FeatureGroupStatistics.class).setParameter("fgsIds", fgsIds).setParameter("featureName", fNsParamValue);
        StatisticsFilters.setFilter(filters, (Query)query);
        return new AbstractFacade.CollectionInfo(Long.valueOf(count), query.getResultList());
    }
}

