/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.statistics;

import io.hops.hopsworks.common.featurestore.statistics.FeatureDescriptiveStatisticsFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.util.PayaraClusterManager;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.FeatureDescriptiveStatistics;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.AccessTimeout;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.javatuples.Pair;

@Singleton
@Startup
@DependsOn(value={"Settings"})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class StatisticsCleaner {
    private static final Logger LOG = Logger.getLogger(StatisticsCleaner.class.getName());
    private int batchSize;
    @EJB
    private Settings settings;
    @EJB
    private FeatureDescriptiveStatisticsFacade featureDescriptiveStatisticsFacade;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private PayaraClusterManager payaraClusterManager;
    @Resource
    private TimerService timerService;
    private Timer timer;

    @PostConstruct
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void init() {
        this.batchSize = this.settings.getStatisticsCleanerBatchSize();
        this.timer = this.timerService.createIntervalTimer(10L, (long)this.settings.getStatisticsCleanerInterval(), new TimerConfig((Serializable)((Object)"StatisticsCleaner"), false));
    }

    @PreDestroy
    private void destroyTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Lock(value=LockType.WRITE)
    @AccessTimeout(value=1000L)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    @Timeout
    public void deleteOrphanStatistics(Timer timer) {
        if (!this.payaraClusterManager.amIThePrimary()) {
            return;
        }
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps();
            LOG.log(Level.FINE, "DeleteOrphanStatistics start");
            List<FeatureDescriptiveStatistics> fds = this.featureDescriptiveStatisticsFacade.findOrphaned((Pair<Integer, Integer>)new Pair((Object)0, (Object)this.batchSize)).stream().filter(f -> !f.getFeatureName().equals("for-migration") && !f.getFeatureName().equals("to-be-deleted")).collect(Collectors.toList());
            while (!fds.isEmpty()) {
                String fdsIds = fds.stream().map(FeatureDescriptiveStatistics::getId).map(Object::toString).collect(Collectors.joining(", "));
                LOG.log(Level.INFO, "Deleting orphaned statistics: " + fdsIds);
                this.deleteExtendedStatsFiles(fds, udfso);
                this.featureDescriptiveStatisticsFacade.batchDelete(fds);
                fds = this.featureDescriptiveStatisticsFacade.findOrphaned((Pair<Integer, Integer>)new Pair((Object)0, (Object)this.batchSize));
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "StatisticsCleaner timer error", ex);
        }
        finally {
            this.dfs.closeDfsClient(udfso);
        }
        LOG.log(Level.FINE, "DeleteOrphanStatistics end");
    }

    private void deleteExtendedStatsFiles(List<FeatureDescriptiveStatistics> fds, DistributedFileSystemOps udfso) throws IOException {
        for (FeatureDescriptiveStatistics stats : fds) {
            if (stats.getExtendedStatisticsPath() == null) continue;
            udfso.rm(stats.getExtendedStatisticsPath(), true);
        }
    }
}

