/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.statistics;

import io.hops.hopsworks.common.dataset.DatasetController;
import io.hops.hopsworks.common.featurestore.activity.FeaturestoreActivityFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.FeatureGroupCommitController;
import io.hops.hopsworks.common.featurestore.featureview.FeatureViewController;
import io.hops.hopsworks.common.featurestore.statistics.FeatureDescriptiveStatisticsFacade;
import io.hops.hopsworks.common.featurestore.statistics.FeatureGroupDescriptiveStatisticsFacade;
import io.hops.hopsworks.common.featurestore.statistics.FeatureGroupStatisticsFacade;
import io.hops.hopsworks.common.featurestore.statistics.FeatureViewDescriptiveStatisticsFacade;
import io.hops.hopsworks.common.featurestore.statistics.FeatureViewStatisticsFacade;
import io.hops.hopsworks.common.featurestore.statistics.StatisticsFilterBy;
import io.hops.hopsworks.common.featurestore.statistics.StatisticsFilters;
import io.hops.hopsworks.common.featurestore.statistics.TrainingDatasetStatisticsFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.DatasetException;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.HopsSecurityException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetAccessPermission;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.FeatureDescriptiveStatistics;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.FeatureGroupDescriptiveStatistics;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.FeatureGroupStatistics;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.FeatureViewDescriptiveStatistics;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.FeatureViewStatistics;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.TrainingDatasetStatistics;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.split.SplitName;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;
import org.javatuples.Pair;
import org.json.JSONException;
import org.json.JSONObject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class StatisticsController {
    @EJB
    private DistributedFsService dfs;
    @EJB
    private DatasetController datasetController;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private FeatureGroupStatisticsFacade featureGroupStatisticsFacade;
    @EJB
    private FeatureViewStatisticsFacade featureViewStatisticsFacade;
    @EJB
    private FeatureGroupDescriptiveStatisticsFacade featureGroupDescriptiveStatisticsFacade;
    @EJB
    private FeatureViewDescriptiveStatisticsFacade featureViewDescriptiveStatisticsFacade;
    @EJB
    private TrainingDatasetStatisticsFacade trainingDatasetStatisticsFacade;
    @EJB
    private FeatureGroupCommitController featureGroupCommitController;
    @EJB
    private FeaturestoreActivityFacade fsActivityFacade;
    @EJB
    private Settings settings;
    @EJB
    private FeatureDescriptiveStatisticsFacade featureDescriptiveStatisticsFacade;

    public AbstractFacade.CollectionInfo<FeatureGroupStatistics> getStatisticsByFeatureGroup(Integer offset, Integer limit, Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, Featuregroup featuregroup) throws FeaturestoreException {
        this.overwriteFiltersIfNeeded(featuregroup, filters);
        return this.featureGroupStatisticsFacade.findByFeaturegroup(offset, limit, sorts, filters, featuregroup);
    }

    public AbstractFacade.CollectionInfo<FeatureGroupStatistics> getStatisticsByFeatureGroupAndFeatureNames(Integer offset, Integer limit, Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, Set<String> featureNames, Featuregroup featuregroup) throws FeaturestoreException {
        this.overwriteFiltersIfNeeded(featuregroup, filters);
        return this.featureGroupStatisticsFacade.findByFeaturegroupWithFeatureNames(offset, limit, sorts, filters, featureNames, featuregroup);
    }

    public FeatureGroupStatistics registerFeatureGroupStatistics(Project project, Users user, Long computationTime, Long windowStartCommitTime, Long windowEndCommitTime, Float rowPercentage, Collection<FeatureDescriptiveStatistics> descriptiveStatistics, Featuregroup featuregroup) throws FeaturestoreException, IOException, DatasetException, HopsSecurityException {
        FeatureGroupStatistics statistics;
        Timestamp computationTimestamp = new Timestamp(computationTime);
        if (!FeaturegroupController.isTimeTravelEnabled(featuregroup)) {
            this.registerExtendedStatistics(project, user, featuregroup.getName(), featuregroup.getVersion(), "FeatureGroups", null, computationTime, false, null, descriptiveStatistics);
            statistics = (FeatureGroupStatistics)this.featureGroupStatisticsFacade.update(new FeatureGroupStatistics((Date)computationTimestamp, rowPercentage, descriptiveStatistics, featuregroup));
        } else {
            block4: {
                try {
                    Pair<Long, Long> startEndCommitTimes = this.featureGroupCommitController.getStartEndCommitTimesByWindowTime(featuregroup, windowStartCommitTime, windowEndCommitTime);
                    windowStartCommitTime = (Long)startEndCommitTimes.getValue0();
                    windowEndCommitTime = (Long)startEndCommitTimes.getValue1();
                }
                catch (FeaturestoreException e) {
                    if (e.getErrorCode().equals(RESTCodes.FeaturestoreErrorCode.FEATURE_GROUP_COMMIT_NOT_FOUND) && descriptiveStatistics.iterator().next().getCount() <= 0L) break block4;
                    throw e;
                }
            }
            this.registerExtendedStatistics(project, user, featuregroup.getName(), featuregroup.getVersion(), "FeatureGroups", windowStartCommitTime, windowEndCommitTime, false, null, descriptiveStatistics);
            Set<StatisticsFilterBy> filters = this.buildStatisticsQueryFilters(windowStartCommitTime, windowEndCommitTime, rowPercentage, null);
            AbstractFacade.CollectionInfo<FeatureGroupStatistics> fgs = this.featureGroupStatisticsFacade.findByFeaturegroup(0, 1, null, filters, featuregroup);
            statistics = fgs.getCount() > 0L ? this.registerFeatureGroupDescriptiveStatistics(filters, descriptiveStatistics, (FeatureGroupStatistics)fgs.getItems().get(0), featuregroup) : (FeatureGroupStatistics)this.featureGroupStatisticsFacade.update(new FeatureGroupStatistics((Date)computationTimestamp, windowStartCommitTime, windowEndCommitTime, rowPercentage, descriptiveStatistics, featuregroup));
        }
        this.fsActivityFacade.logStatisticsActivity(user, featuregroup, new Date(computationTimestamp.getTime()), statistics);
        return statistics;
    }

    public void deleteFeatureGroupStatistics(Project project, Users user, Featuregroup featuregroup) throws FeaturestoreException {
        this.deleteExtendedStatistics(project, user, featuregroup.getName(), featuregroup.getVersion(), "FeatureGroups");
    }

    public AbstractFacade.CollectionInfo<FeatureViewStatistics> getStatisticsByFeatureView(Integer offset, Integer limit, Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, FeatureView featureView) throws FeaturestoreException {
        this.overwriteFiltersIfNeeded(featureView, filters);
        return this.featureViewStatisticsFacade.findByFeatureView(offset, limit, sorts, filters, featureView);
    }

    public AbstractFacade.CollectionInfo<FeatureViewStatistics> getStatisticsByFeatureViewAndFeatureNames(Integer offset, Integer limit, Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, Set<String> featureNames, FeatureView featureView) throws FeaturestoreException {
        this.overwriteFiltersIfNeeded(featureView, filters);
        return this.featureViewStatisticsFacade.findByFeatureViewWithFeatureNames(offset, limit, sorts, filters, featureNames, featureView);
    }

    public FeatureViewStatistics registerFeatureViewStatistics(Project project, Users user, Long computationTime, Long windowStartCommitTime, Long windowEndCommitTime, Float rowPercentage, Collection<FeatureDescriptiveStatistics> descriptiveStatistics, FeatureView featureView) throws FeaturestoreException, IOException, DatasetException, HopsSecurityException {
        FeatureViewStatistics statistics;
        Timestamp computationTimestamp = new Timestamp(computationTime);
        Featuregroup featuregroup = FeatureViewController.getLeftFeatureGroup(featureView);
        if (!FeaturegroupController.isTimeTravelEnabled(featuregroup)) {
            this.registerExtendedStatistics(project, user, featureView.getName(), featureView.getVersion(), "FeatureViews", null, computationTime, false, null, descriptiveStatistics);
            statistics = (FeatureViewStatistics)this.featureViewStatisticsFacade.update(new FeatureViewStatistics((Date)computationTimestamp, rowPercentage, descriptiveStatistics, featureView));
        } else {
            block4: {
                try {
                    Pair<Long, Long> startEndCommitTimes = this.featureGroupCommitController.getStartEndCommitTimesByWindowTime(featuregroup, windowStartCommitTime, windowEndCommitTime);
                    windowStartCommitTime = (Long)startEndCommitTimes.getValue0();
                    windowEndCommitTime = (Long)startEndCommitTimes.getValue1();
                }
                catch (FeaturestoreException e) {
                    if (e.getErrorCode().equals(RESTCodes.FeaturestoreErrorCode.FEATURE_GROUP_COMMIT_NOT_FOUND) && descriptiveStatistics.iterator().next().getCount() <= 0L) break block4;
                    throw e;
                }
            }
            this.registerExtendedStatistics(project, user, featureView.getName(), featureView.getVersion(), "FeatureViews", windowStartCommitTime, windowEndCommitTime, false, null, descriptiveStatistics);
            Set<StatisticsFilterBy> filters = this.buildStatisticsQueryFilters(windowStartCommitTime, windowEndCommitTime, rowPercentage, null);
            AbstractFacade.CollectionInfo<FeatureViewStatistics> fvs = this.featureViewStatisticsFacade.findByFeatureView(0, 1, null, filters, featureView);
            statistics = fvs.getCount() > 0L ? this.registerFeatureViewDescriptiveStatistics(filters, descriptiveStatistics, (FeatureViewStatistics)fvs.getItems().get(0), featureView) : (FeatureViewStatistics)this.featureViewStatisticsFacade.update(new FeatureViewStatistics((Date)computationTimestamp, windowStartCommitTime, windowEndCommitTime, rowPercentage, descriptiveStatistics, featureView));
        }
        this.fsActivityFacade.logStatisticsActivity(user, featureView, new Date(computationTimestamp.getTime()), statistics);
        return statistics;
    }

    public void deleteFeatureViewStatistics(Project project, Users user, FeatureView featureView) throws FeaturestoreException {
        this.deleteExtendedStatistics(project, user, featureView.getName(), featureView.getVersion(), "FeatureViews");
    }

    public AbstractFacade.CollectionInfo<TrainingDatasetStatistics> getStatisticsByTrainingDataset(Set<? extends AbstractFacade.FilterBy> filters, TrainingDataset trainingDataset) {
        return this.trainingDatasetStatisticsFacade.findByTrainingDataset(filters, trainingDataset);
    }

    public AbstractFacade.CollectionInfo<TrainingDatasetStatistics> getStatisticsByTrainingDatasetAndFeatureNames(Set<? extends AbstractFacade.FilterBy> filters, Set<String> featureNames, TrainingDataset trainingDataset) throws FeaturestoreException {
        return this.trainingDatasetStatisticsFacade.findByTrainingDatasetWithFeatureNames(filters, featureNames, trainingDataset);
    }

    public TrainingDatasetStatistics registerTrainingDatasetStatistics(Project project, Users user, Long computationTime, boolean beforeTransformation, Float rowPercentage, Collection<FeatureDescriptiveStatistics> descriptiveStatistics, TrainingDataset trainingDataset) throws DatasetException, HopsSecurityException, IOException, FeaturestoreException {
        this.registerExtendedStatistics(project, user, trainingDataset.getName(), trainingDataset.getVersion(), "TrainingDatasets", null, computationTime, beforeTransformation, null, descriptiveStatistics);
        Timestamp computationTimestamp = new Timestamp(computationTime);
        TrainingDatasetStatistics statistics = new TrainingDatasetStatistics((Date)computationTimestamp, rowPercentage, descriptiveStatistics, trainingDataset);
        statistics.setForTransformation(beforeTransformation);
        this.setExistingTrainingDatasetStatisticsIDs(trainingDataset, statistics, beforeTransformation, rowPercentage);
        statistics = (TrainingDatasetStatistics)this.trainingDatasetStatisticsFacade.update(statistics);
        if (!beforeTransformation) {
            this.fsActivityFacade.logStatisticsActivity(user, trainingDataset, new Date(computationTimestamp.getTime()), statistics);
        }
        return statistics;
    }

    public TrainingDatasetStatistics registerTrainingDatasetSplitStatistics(Project project, Users user, Long computationTime, Float rowPercentage, Map<String, Collection<FeatureDescriptiveStatistics>> splitStatistics, TrainingDataset trainingDataset) throws DatasetException, HopsSecurityException, IOException, FeaturestoreException {
        for (Map.Entry<String, Collection<FeatureDescriptiveStatistics>> entry : splitStatistics.entrySet()) {
            this.registerExtendedStatistics(project, user, trainingDataset.getName(), trainingDataset.getVersion(), "TrainingDatasets", null, computationTime, false, entry.getKey(), entry.getValue());
        }
        Timestamp computationTimestamp = new Timestamp(computationTime);
        TrainingDatasetStatistics statistics = new TrainingDatasetStatistics((Date)computationTimestamp, rowPercentage, splitStatistics.get(SplitName.TRAIN.getName()), splitStatistics.get(SplitName.TEST.getName()), (Collection)splitStatistics.getOrDefault(SplitName.VALIDATION.getName(), null), trainingDataset);
        this.setExistingTrainingDatasetStatisticsIDs(trainingDataset, statistics, false, rowPercentage);
        statistics = (TrainingDatasetStatistics)this.trainingDatasetStatisticsFacade.update(statistics);
        this.fsActivityFacade.logStatisticsActivity(user, trainingDataset, new Date(computationTimestamp.getTime()), statistics);
        return statistics;
    }

    public void deleteTrainingDatasetStatistics(Project project, Users user, TrainingDataset trainingDataset) throws FeaturestoreException {
        this.deleteExtendedStatistics(project, user, trainingDataset.getName(), trainingDataset.getVersion(), "TrainingDatasets");
    }

    private void setExistingTrainingDatasetStatisticsIDs(TrainingDataset trainingDataset, TrainingDatasetStatistics statistics, Boolean beforeTransformation, Float rowPercentage) {
        Set<StatisticsFilterBy> filters = this.buildStatisticsQueryFilters(null, null, rowPercentage, beforeTransformation);
        AbstractFacade.CollectionInfo<TrainingDatasetStatistics> tdStatisticsList = this.trainingDatasetStatisticsFacade.findByTrainingDataset(filters, trainingDataset);
        if (tdStatisticsList != null && tdStatisticsList.getCount() == 1L) {
            TrainingDatasetStatistics existingStatistics = (TrainingDatasetStatistics)tdStatisticsList.getItems().get(0);
            statistics.setId(existingStatistics.getId());
            this.setExistingFeatureDescriptiveStatisticsIDs(statistics.getTrainFeatureDescriptiveStatistics(), existingStatistics.getTrainFeatureDescriptiveStatistics());
            this.setExistingFeatureDescriptiveStatisticsIDs(statistics.getTestFeatureDescriptiveStatistics(), existingStatistics.getTestFeatureDescriptiveStatistics());
            this.setExistingFeatureDescriptiveStatisticsIDs(statistics.getValFeatureDescriptiveStatistics(), existingStatistics.getValFeatureDescriptiveStatistics());
        }
    }

    private FeatureGroupStatistics registerFeatureGroupDescriptiveStatistics(Set<StatisticsFilterBy> filters, Collection<FeatureDescriptiveStatistics> descriptiveStatistics, FeatureGroupStatistics fgStatistics, Featuregroup featuregroup) throws FeaturestoreException {
        Set<String> featureNames = descriptiveStatistics.stream().map(FeatureDescriptiveStatistics::getFeatureName).collect(Collectors.toSet());
        AbstractFacade.CollectionInfo<FeatureGroupStatistics> fgsWithFeatures = this.getStatisticsByFeatureGroupAndFeatureNames(0, 1, null, filters, featureNames, featuregroup);
        HashMap existingFds = null;
        if (fgsWithFeatures.getCount() > 0L) {
            existingFds = ((FeatureGroupStatistics)fgsWithFeatures.getItems().get(0)).getFeatureDescriptiveStatistics().stream().filter(ds -> featureNames.contains(ds.getFeatureName())).collect(Collectors.toMap(FeatureDescriptiveStatistics::getFeatureName, Function.identity(), (prev, next) -> next, HashMap::new));
        }
        for (FeatureDescriptiveStatistics fds : descriptiveStatistics) {
            if (existingFds != null && existingFds.containsKey(fds.getFeatureName())) {
                fds.setId(((FeatureDescriptiveStatistics)existingFds.get(fds.getFeatureName())).getId());
            }
            fds = (FeatureDescriptiveStatistics)this.featureDescriptiveStatisticsFacade.update(fds);
            FeatureGroupDescriptiveStatistics fgds = new FeatureGroupDescriptiveStatistics(fgStatistics, fds);
            this.featureGroupDescriptiveStatisticsFacade.update(fgds);
        }
        return fgStatistics;
    }

    private FeatureViewStatistics registerFeatureViewDescriptiveStatistics(Set<StatisticsFilterBy> filters, Collection<FeatureDescriptiveStatistics> descriptiveStatistics, FeatureViewStatistics fvStatistics, FeatureView featureView) throws FeaturestoreException {
        Set<String> featureNames = descriptiveStatistics.stream().map(FeatureDescriptiveStatistics::getFeatureName).collect(Collectors.toSet());
        AbstractFacade.CollectionInfo<FeatureViewStatistics> fvsWithFeatures = this.getStatisticsByFeatureViewAndFeatureNames(0, 1, null, filters, featureNames, featureView);
        HashMap existingFds = null;
        if (fvsWithFeatures.getCount() > 0L) {
            existingFds = ((FeatureViewStatistics)fvsWithFeatures.getItems().get(0)).getFeatureDescriptiveStatistics().stream().filter(ds -> featureNames.contains(ds.getFeatureName())).collect(Collectors.toMap(FeatureDescriptiveStatistics::getFeatureName, Function.identity(), (prev, next) -> next, HashMap::new));
        }
        for (FeatureDescriptiveStatistics fds : descriptiveStatistics) {
            if (existingFds != null && existingFds.containsKey(fds.getFeatureName())) {
                fds.setId(((FeatureDescriptiveStatistics)existingFds.get(fds.getFeatureName())).getId());
            }
            fds = (FeatureDescriptiveStatistics)this.featureDescriptiveStatisticsFacade.update(fds);
            FeatureViewDescriptiveStatistics fgds = new FeatureViewDescriptiveStatistics(fvStatistics, fds);
            this.featureViewDescriptiveStatisticsFacade.update(fgds);
        }
        return fvStatistics;
    }

    public Set<StatisticsFilterBy> buildStatisticsQueryFilters(Long windowStartCommitTime, Long windowEndCommitTime, Float rowPercentage, Boolean beforeTransformation) {
        HashSet<StatisticsFilterBy> filters = new HashSet<StatisticsFilterBy>();
        filters.add(new StatisticsFilterBy(StatisticsFilters.Filters.ROW_PERCENTAGE_EQ, rowPercentage != null ? String.valueOf(rowPercentage) : null));
        if (windowStartCommitTime != null) {
            filters.add(new StatisticsFilterBy(StatisticsFilters.Filters.WINDOW_START_COMMIT_TIME_EQ, String.valueOf(windowStartCommitTime)));
        }
        if (windowEndCommitTime != null) {
            filters.add(new StatisticsFilterBy(StatisticsFilters.Filters.WINDOW_END_COMMIT_TIME_EQ, String.valueOf(windowEndCommitTime)));
        }
        if (beforeTransformation != null) {
            filters.add(new StatisticsFilterBy(StatisticsFilters.Filters.BEFORE_TRANSFORMATION_EQ, String.valueOf(beforeTransformation)));
        }
        return filters;
    }

    public void setExistingFeatureDescriptiveStatisticsIDs(Collection<FeatureDescriptiveStatistics> statistics, Collection<FeatureDescriptiveStatistics> existingStatistics) {
        if (statistics == null || existingStatistics == null) {
            return;
        }
        Map<String, Integer> existingStatsMap = existingStatistics.stream().collect(Collectors.toMap(FeatureDescriptiveStatistics::getFeatureName, FeatureDescriptiveStatistics::getId));
        for (FeatureDescriptiveStatistics fds : statistics) {
            if (!existingStatsMap.containsKey(fds.getFeatureName())) continue;
            Integer id = existingStatsMap.get(fds.getFeatureName());
            fds.setId(id);
        }
    }

    public void appendExtendedStatistics(Project project, Users user, Collection<FeatureDescriptiveStatistics> descriptiveStatistics) throws FeaturestoreException {
        for (FeatureDescriptiveStatistics fds : descriptiveStatistics) {
            if (fds.getExtendedStatisticsPath() == null) continue;
            String stats = this.readExtendedStatistics(project, user, fds.getExtendedStatisticsPath());
            fds.setExtendedStatistics(stats);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerExtendedStatistics(Project project, Users user, String entityName, Integer version, String entitySubDir, Long startCommitTime, Long endCommitTime, Boolean beforeTransformation, String splitName, Collection<FeatureDescriptiveStatistics> descriptiveStatistics) throws IOException, DatasetException, HopsSecurityException, FeaturestoreException {
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(this.hdfsUsersController.getHdfsUserName(project, user));
            Path dirPath = this.getExtendedStatisticsDirPath(project, user, udfso, entityName, version, entitySubDir);
            for (FeatureDescriptiveStatistics fds : descriptiveStatistics) {
                if (fds.getExtendedStatistics() == null) continue;
                String path = this.createExtendedStatisticsFile(startCommitTime, endCommitTime, fds.getFeatureName(), fds.getExtendedStatistics(), beforeTransformation, splitName, udfso, dirPath);
                fds.setExtendedStatisticsPath(path);
            }
            this.dfs.closeDfsClient(udfso);
        }
        catch (Throwable throwable) {
            this.dfs.closeDfsClient(udfso);
            throw throwable;
        }
    }

    private String createExtendedStatisticsFile(Long startTime, Long endTime, String featureName, String extendedStatistics, Boolean beforeTransformation, String splitName, DistributedFileSystemOps udfso, Path dirPath) throws IOException, FeaturestoreException {
        Path filePath = beforeTransformation != false ? new Path(dirPath, this.transformationFnStatisticsFileName(startTime, endTime, featureName)) : (splitName != null ? new Path(dirPath, this.splitStatisticsFileName(splitName, endTime, featureName)) : new Path(dirPath, this.statisticsFileName(startTime, endTime, featureName)));
        extendedStatistics = this.sanitizeExtendedStatistics(extendedStatistics);
        udfso.create(filePath, extendedStatistics);
        return filePath.toString();
    }

    private Path getExtendedStatisticsDirPath(Project project, Users user, DistributedFileSystemOps udfso, String entityName, Integer version, String entitySubDir) throws DatasetException, HopsSecurityException, IOException {
        Path dirPath;
        String dirName = entityName + "_" + version;
        Dataset statistics = this.getOrCreateStatisticsDataset(project, user);
        Path subDir = new Path(Utils.getDatasetPath(statistics, this.settings), entitySubDir);
        if (!udfso.isDir(subDir.toString())) {
            udfso.mkdir(subDir.toString());
        }
        if (!udfso.isDir((dirPath = new Path(subDir, dirName)).toString())) {
            udfso.mkdir(dirPath.toString());
        }
        return dirPath;
    }

    private void deleteExtendedStatistics(Project project, Users user, String entityName, Integer version, String entitySubDir) throws FeaturestoreException {
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(this.hdfsUsersController.getHdfsUserName(project, user));
            String dirName = entityName + "_" + version;
            Dataset statistics = this.getOrCreateStatisticsDataset(project, user);
            Path subDir = new Path(Utils.getDatasetPath(statistics, this.settings), entitySubDir);
            Path dirPath = new Path(subDir, dirName);
            udfso.rm(dirPath, true);
            this.dfs.closeDfsClient(udfso);
        }
        catch (DatasetException | HopsSecurityException | IOException e) {
            try {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_DELETING_STATISTICS, Level.WARNING, "", e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.dfs.closeDfsClient(udfso);
                throw throwable;
            }
        }
    }

    public Pair<Long, Long> extractTimeWindowFromFilters(Set<AbstractFacade.FilterBy> filters, StatisticsFilters.Filters windowStartFilter, StatisticsFilters.Filters windowEndFilter) {
        Long windowStartTime = null;
        Long windowEndTime = null;
        for (AbstractFacade.FilterBy filter : filters) {
            if (filter.getValue().equals(windowStartFilter.getValue())) {
                windowStartTime = Long.valueOf(filter.getParam());
                continue;
            }
            if (!filter.getValue().equals(windowEndFilter.getValue())) continue;
            windowEndTime = Long.valueOf(filter.getParam());
        }
        return new Pair(windowStartTime, windowEndTime);
    }

    private void overwriteFiltersIfNeeded(Featuregroup featuregroup, Set<AbstractFacade.FilterBy> filters) throws FeaturestoreException {
        Set<AbstractFacade.FilterBy> filterSet;
        Pair<Long, Long> windowCommitTimes;
        if (FeaturegroupController.isTimeTravelEnabled(featuregroup) && ((windowCommitTimes = this.extractTimeWindowFromFilters(filterSet = filters, StatisticsFilters.Filters.WINDOW_START_COMMIT_TIME_EQ, StatisticsFilters.Filters.WINDOW_END_COMMIT_TIME_EQ)).getValue0() != null || windowCommitTimes.getValue1() != null)) {
            Pair<Long, Long> startEndCommits = this.featureGroupCommitController.getStartEndCommitTimesByWindowTime(featuregroup, (Long)windowCommitTimes.getValue0(), (Long)windowCommitTimes.getValue1());
            this.overwriteTimeWindowFilters(filterSet, (Long)startEndCommits.getValue0(), (Long)startEndCommits.getValue1(), StatisticsFilters.Filters.WINDOW_START_COMMIT_TIME_EQ, StatisticsFilters.Filters.WINDOW_END_COMMIT_TIME_EQ);
        }
    }

    private void overwriteFiltersIfNeeded(FeatureView featureView, Set<AbstractFacade.FilterBy> filters) throws FeaturestoreException {
        Featuregroup featuregroup = FeatureViewController.getLeftFeatureGroup(featureView);
        this.overwriteFiltersIfNeeded(featuregroup, filters);
    }

    public void overwriteTimeWindowFilters(Set<AbstractFacade.FilterBy> filters, Long windowStartTime, Long windowEndTime, StatisticsFilters.Filters windowStartFilter, StatisticsFilters.Filters windowEndFilter) {
        filters.removeIf(f -> f.getValue().equals(windowStartFilter.getValue()) || f.getValue().equals(windowEndFilter.getValue()));
        filters.add(new StatisticsFilterBy(windowStartFilter, String.valueOf(windowStartTime)));
        filters.add(new StatisticsFilterBy(windowEndFilter, String.valueOf(windowEndTime)));
    }

    private Dataset getOrCreateStatisticsDataset(Project project, Users user) throws DatasetException, HopsSecurityException {
        Optional<Dataset> statsDataset = project.getDatasetCollection().stream().filter(d -> d.getName().equals(Settings.ServiceDataset.STATISTICS.getName())).findFirst();
        if (statsDataset.isPresent()) {
            return statsDataset.get();
        }
        return this.createStatisticsDataset(project, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dataset createStatisticsDataset(Project project, Users user) throws DatasetException, HopsSecurityException {
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfs.getDfsOps();
            Dataset dataset = this.datasetController.createDataset(user, project, Settings.ServiceDataset.STATISTICS.getName(), Settings.ServiceDataset.STATISTICS.getDescription(), Provenance.Type.DISABLED.dto, false, DatasetAccessPermission.EDITABLE, dfso);
            return dataset;
        }
        finally {
            this.dfs.closeDfsClient(dfso);
        }
    }

    private String sanitizeExtendedStatistics(String statistics) throws FeaturestoreException {
        JSONObject statisticsJson = null;
        try {
            statisticsJson = new JSONObject(statistics);
        }
        catch (JSONException jex) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_SAVING_STATISTICS, Level.WARNING, "Not a valid JSON", jex.getMessage(), (Throwable)jex);
        }
        return statisticsJson.toString();
    }

    private String splitStatisticsFileName(String splitName, Long commitTime, String featureName) {
        return commitTime + "_" + splitName + "_" + featureName + ".json";
    }

    private String statisticsFileName(Long startCommitTime, Long endCommitTime, String featureName) {
        String name = startCommitTime != null ? startCommitTime + "_" : "";
        return name + endCommitTime + "_" + featureName + ".json";
    }

    private String transformationFnStatisticsFileName(Long startCommitTime, Long endCommitTime, String featureName) {
        String name = "transformation_fn_";
        name = name + (startCommitTime != null ? startCommitTime + "_" : "");
        return name + endCommitTime + "_" + featureName + ".json";
    }

    private String readExtendedStatistics(Project project, Users user, String path) throws FeaturestoreException {
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(this.hdfsUsersController.getHdfsUserName(project, user));
            String string = udfso.cat(path);
            this.dfs.closeDfsClient(udfso);
            return string;
        }
        catch (IOException e) {
            try {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.STATISTICS_READ_ERROR, Level.WARNING, e.getMessage(), e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.dfs.closeDfsClient(udfso);
                throw throwable;
            }
        }
    }
}

