/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.statistics;

import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import java.sql.Timestamp;
import java.util.Set;
import java.util.logging.Logger;
import javax.persistence.Query;

public class StatisticsFilters {
    private static final Logger LOGGER = Logger.getLogger(StatisticsFilters.class.getName());
    private Long computationTime;
    private Long windowStartCommitTime;
    private Long windowEndCommitTime;
    private Float rowPercentage;
    private Boolean beforeTransformation;
    private Integer transformedWithVersion;

    public StatisticsFilters(Set<AbstractFacade.FilterBy> filters) {
        this.rowPercentage = Float.valueOf(Filters.ROW_PERCENTAGE_EQ.getDefaultParam());
        this.beforeTransformation = Boolean.valueOf(Filters.BEFORE_TRANSFORMATION_EQ.getDefaultParam());
        if (filters != null) {
            for (AbstractFacade.FilterBy filter : filters) {
                if (filter.getValue().startsWith("COMPUTATION_TIME_")) {
                    this.computationTime = Long.valueOf(filter.getParam());
                    continue;
                }
                if (filter.getValue().startsWith("WINDOW_START_COMMIT_TIME_")) {
                    this.windowStartCommitTime = Long.valueOf(filter.getParam());
                    continue;
                }
                if (filter.getValue().startsWith("WINDOW_END_COMMIT_TIME_")) {
                    this.windowEndCommitTime = Long.valueOf(filter.getParam());
                    continue;
                }
                if (filter.getValue().startsWith(Filters.ROW_PERCENTAGE_EQ.getValue())) {
                    this.rowPercentage = Float.valueOf(filter.getParam());
                    continue;
                }
                if (!filter.getValue().startsWith(Filters.BEFORE_TRANSFORMATION_EQ.getValue())) continue;
                this.beforeTransformation = Boolean.valueOf(filter.getParam());
            }
        }
    }

    public static void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            Object paramValue = filterBy.getValue().startsWith("COMPUTATION_TIME_") ? new Timestamp(Long.parseLong(filterBy.getParam())) : (filterBy.getValue().equals(Filters.ROW_PERCENTAGE_EQ.getValue()) ? Float.valueOf(Float.parseFloat(filterBy.getParam())) : (filterBy.getValue().startsWith("WINDOW_") ? Long.valueOf(Long.parseLong(filterBy.getParam())) : (filterBy.getValue().equals(Filters.BEFORE_TRANSFORMATION_EQ.getValue()) ? Boolean.valueOf(Boolean.parseBoolean(filterBy.getParam())) : filterBy.getParam())));
            q.setParameter(filterBy.getField(), paramValue);
        }
    }

    public StatisticsFilters() {
    }

    public Long getComputationTime() {
        return this.computationTime;
    }

    public Long getWindowStartCommitTime() {
        return this.windowStartCommitTime;
    }

    public Long getWindowEndCommitTime() {
        return this.windowEndCommitTime;
    }

    public Float getRowPercentage() {
        return this.rowPercentage;
    }

    public Boolean getBeforeTransformation() {
        return this.beforeTransformation;
    }

    public Integer getTransformedWithVersion() {
        return this.transformedWithVersion;
    }

    public void setComputationTime(Long computationTime) {
        this.computationTime = computationTime;
    }

    public void setWindowStartCommitTime(Long windowStartCommitTime) {
        this.windowStartCommitTime = windowStartCommitTime;
    }

    public void setWindowEndCommitTime(Long windowEndCommitTime) {
        this.windowEndCommitTime = windowEndCommitTime;
    }

    public void setRowPercentage(Float rowPercentage) {
        this.rowPercentage = rowPercentage;
    }

    public void setBeforeTransformation(Boolean beforeTransformation) {
        this.beforeTransformation = beforeTransformation;
    }

    public void setTransformedWithVersion(Integer transformedWithVersion) {
        this.transformedWithVersion = transformedWithVersion;
    }

    public static enum Filters {
        ROW_PERCENTAGE_EQ("ROW_PERCENTAGE_EQ", "s.rowPercentage = :rowPercentage", "rowPercentage", "1.0"),
        COMPUTATION_TIME_GT("COMPUTATION_TIME_GT", "s.computationTime > :computationTime", "computationTime", ""),
        COMPUTATION_TIME_LT("COMPUTATION_TIME_LT", "s.computationTime < :computationTime", "computationTime", ""),
        COMPUTATION_TIME_EQ("COMPUTATION_TIME_EQ", "s.computationTime = :computationTime", "computationTime", ""),
        COMPUTATION_TIME_LTOEQ("COMPUTATION_TIME_LTOEQ", "s.computationTime <= :computationTime", "computationTime", ""),
        WINDOW_START_COMMIT_TIME_GTOEQ("WINDOW_START_COMMIT_TIME_GTOEQ", "s.windowStartCommitTime >= :windowStartCommitTime", "windowStartCommitTime", ""),
        WINDOW_START_COMMIT_TIME_EQ("WINDOW_START_COMMIT_TIME_EQ", "s.windowStartCommitTime = :windowStartCommitTime", "windowStartCommitTime", ""),
        WINDOW_END_COMMIT_TIME_LTOEQ("WINDOW_END_COMMIT_TIME_LTOEQ", "s.windowEndCommitTime <= :windowEndCommitTime", "windowEndCommitTime", ""),
        WINDOW_END_COMMIT_TIME_EQ("WINDOW_END_COMMIT_TIME_EQ", "s.windowEndCommitTime = :windowEndCommitTime", "windowEndCommitTime", ""),
        BEFORE_TRANSFORMATION_EQ("BEFORE_TRANSFORMATION_EQ", "s.beforeTransformation = :beforeTransformation", "beforeTransformation", "false");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        COMPUTATION_TIME("COMPUTATION_TIME", "s.computationTime ", "DESC"),
        WINDOW_START_COMMIT_TIME("WINDOW_START_COMMIT_TIME", "s.windowStartCommitTime ", "ASC"),
        WINDOW_END_COMMIT_TIME("WINDOW_END_COMMIT_TIME", "s.windowEndCommitTime ", "DESC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String toString() {
            return this.value;
        }
    }
}

