/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.QueryParam;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnectorType;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class FeaturestoreConnectorFacade
extends AbstractFacade<FeaturestoreConnector> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public FeaturestoreConnectorFacade() {
        super(FeaturestoreConnector.class);
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public Optional<FeaturestoreConnector> findById(Integer id) {
        try {
            return Optional.of(this.em.createNamedQuery("FeaturestoreConnector.findById", FeaturestoreConnector.class).setParameter("id", (Object)id).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<FeaturestoreConnector> findByIdType(Integer id, FeaturestoreConnectorType type) {
        try {
            return Optional.of(this.em.createNamedQuery("FeaturestoreConnector.findByIdType", FeaturestoreConnector.class).setParameter("id", (Object)id).setParameter("type", (Object)type).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public List<FeaturestoreConnector> findByFeaturestore(Featurestore featurestore) {
        return this.em.createNamedQuery("FeaturestoreConnector.findByFeaturestore", FeaturestoreConnector.class).setParameter("featurestore", (Object)featurestore).getResultList();
    }

    public Optional<FeaturestoreConnector> findByFeaturestoreName(Featurestore featurestore, String name) {
        try {
            return Optional.of(this.em.createNamedQuery("FeaturestoreConnector.findByFeaturestoreName", FeaturestoreConnector.class).setParameter("featurestore", (Object)featurestore).setParameter("name", (Object)name).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public AbstractFacade.CollectionInfo findByFeaturestoreAndTypes(Featurestore featurestore, Set<FeaturestoreConnectorType> types, QueryParam queryParam) {
        return new AbstractFacade.CollectionInfo(this.countByFeaturestore(featurestore, types, queryParam), this.getByType(featurestore, types, queryParam));
    }

    private List<FeaturestoreConnector> getByType(Featurestore featurestore, Set<FeaturestoreConnectorType> types, QueryParam queryParam) {
        String queryStr = this.buildQuery("SELECT fsConn FROM FeaturestoreConnector fsConn ", queryParam != null ? queryParam.getFilters() : null, queryParam != null ? queryParam.getSorts() : null, "fsConn.featurestore = :featurestore AND fsConn.connectorType IN :types");
        TypedQuery query = this.em.createQuery(queryStr, FeaturestoreConnector.class).setParameter("featurestore", (Object)featurestore).setParameter("types", types);
        if (queryParam != null) {
            this.setFilter(queryParam.getFilters(), (Query)query);
            this.setOffsetAndLim(queryParam.getOffset(), queryParam.getLimit(), (Query)query);
        }
        return query.getResultList();
    }

    public void deleteByFeaturestoreName(Featurestore featurestore, String name) {
        this.findByFeaturestoreName(featurestore, name).ifPresent(arg_0 -> ((FeaturestoreConnectorFacade)this).remove(arg_0));
    }

    public Long countByFeaturestore(Featurestore featurestore, Set<FeaturestoreConnectorType> types, QueryParam queryParam) {
        String queryStr = this.buildQuery("SELECT count(fsConn.id) FROM FeaturestoreConnector fsConn ", queryParam != null ? queryParam.getFilters() : null, null, "fsConn.featurestore = :featurestore AND fsConn.connectorType IN :types");
        TypedQuery query = this.em.createQuery(queryStr, Long.class).setParameter("featurestore", (Object)featurestore).setParameter("types", types);
        if (queryParam != null) {
            this.setFilter(queryParam.getFilters(), (Query)query);
        }
        return (Long)query.getSingleResult();
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filters, Query q) {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filters) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filter, Query q) {
        switch (Filters.valueOf(filter.getValue())) {
            case NAME: 
            case NAME_LIKE: {
                q.setParameter(filter.getField(), (Object)filter.getParam());
                break;
            }
            case TYPE: {
                q.setParameter(filter.getField(), (Object)FeaturestoreConnectorType.valueOf((String)filter.getParam().toUpperCase()));
                break;
            }
        }
    }

    public static enum Sorts {
        ID("ID", "fsConn.id", "ASC"),
        NAME("NAME", "fsConn.name", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Filters {
        NAME("NAME", "fsConn.name = :name", "name", ""),
        NAME_LIKE("NAME_LIKE", "fsConn.name LIKE CONCAT('%', :name, '%') ", "name", ""),
        TYPE("TYPE", "fsConn.connectorType = :type", "type", "");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }
}

