/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.connectionChecker;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.featurestore.OptionDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.connectionChecker.ConnectionCheckerDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.jdbc.FeaturestoreJdbcConnectorController;
import io.hops.hopsworks.common.featurestore.storageconnectors.jdbc.FeaturestoreJdbcConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.snowflake.FeaturestoreSnowflakeConnectorController;
import io.hops.hopsworks.common.featurestore.storageconnectors.snowflake.FeaturestoreSnowflakeConnectorDTO;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.proxies.client.HttpClient;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.file.PathUtils;
import org.opensearch.common.Strings;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ConnectionChecker {
    private static final Logger LOGGER = Logger.getLogger(ConnectionChecker.class.getName());
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private Settings settings;
    @EJB
    private FeaturestoreSnowflakeConnectorController snowflakeConnectorController;
    @EJB
    private ProjectUtils projectUtils;
    @EJB
    private HttpClient httpClient;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private FeaturestoreJdbcConnectorController featurestoreJdbcConnectorController;
    private Path STAGING_PATH;
    private Path REQUEST_SCRATCH_DIR;

    @PostConstruct
    public void init() {
        this.STAGING_PATH = Paths.get(this.settings.getStagingDir(), "connectors");
    }

    public ConnectionCheckerDTO checkConnection(Users user, Project project, Featurestore featurestore, FeaturestoreStorageConnectorDTO storageConnectorDto) throws FeaturestoreException {
        File jsonFile = null;
        this.REQUEST_SCRATCH_DIR = Paths.get(this.STAGING_PATH.toString(), String.format("user_%s_project_%d_fs_%d_connector_%s", user.getUsername(), project.getId(), featurestore.getId(), storageConnectorDto.getName()));
        try {
            Files.createDirectories(this.REQUEST_SCRATCH_DIR, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CONNECTION_CHECKER_ERROR, Level.SEVERE, "Failed to create staging directory", e.getMessage(), (Throwable)e);
        }
        switch (storageConnectorDto.getStorageConnectorType()) {
            case SNOWFLAKE: {
                this.snowflakeConnectorController.verifyConnectorDTO((FeaturestoreSnowflakeConnectorDTO)storageConnectorDto);
                break;
            }
            case JDBC: {
                FeaturestoreJdbcConnectorDTO dto = (FeaturestoreJdbcConnectorDTO)storageConnectorDto;
                this.featurestoreJdbcConnectorController.validationDTO(dto);
                List<OptionDTO> optionsList = dto.getArguments();
                if (!optionsList.isEmpty()) {
                    dto.setConnectionString(this.getQueryParamsUrl(optionsList, dto.getConnectionString()));
                }
                if (Strings.isNullOrEmpty((String)dto.getDriverPath())) break;
                this.copyKeyFile(project, user, dto.getDriverPath());
                break;
            }
            default: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_TYPE, Level.FINE, "Storage connector type '" + storageConnectorDto.getStorageConnectorType() + "' is not yet supported");
            }
        }
        try {
            jsonFile = new File(this.buildInputFilePath(user, project, featurestore).toUri());
            LOGGER.log(Level.FINE, "Creating input JSON at path {}", jsonFile.getAbsolutePath());
            ObjectMapper objMapper = this.httpClient.getObjectMapper();
            objMapper.registerModule((Module)new JavaTimeModule());
            objMapper.writeValue(jsonFile, (Object)storageConnectorDto);
            ProcessResult result = this.execute(jsonFile.toPath());
            LOGGER.log(Level.FINE, () -> String.format("Output response for connection test: %s%s", result.getStdout(), result.getStderr()));
            ConnectionCheckerDTO outputDto = new ConnectionCheckerDTO();
            outputDto.setConnectionOutput(String.format("%s%s", result.getStdout(), result.getStderr()));
            outputDto.setStatusCode(result.getExitCode());
            ConnectionCheckerDTO connectionCheckerDTO = outputDto;
            return connectionCheckerDTO;
        }
        catch (IOException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CONNECTION_CHECKER_ERROR, Level.SEVERE, "Failed to create JSON file from input request", e.getMessage(), (Throwable)e);
        }
        finally {
            this.deleteStagedDir();
        }
    }

    private String getQueryParamsUrl(List<OptionDTO> optionsList, String connectionString) {
        StringJoiner sj = connectionString.contains("?") ? new StringJoiner("&", "&", "") : new StringJoiner("&", "?", "");
        for (OptionDTO args : optionsList) {
            sj.add(args.getName() + "=" + args.getValue());
        }
        connectionString = connectionString + sj.toString();
        return connectionString;
    }

    private void copyKeyFile(Project project, Users user, String keyPath) throws FeaturestoreException {
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(this.hdfsUsersController.getHdfsUserName(project, user));
        try {
            udfso.copyToLocal(keyPath, this.REQUEST_SCRATCH_DIR.toString());
        }
        catch (IOException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CONNECTION_CHECKER_ERROR, Level.SEVERE, "Failed to copy key file from HDFS", "", (Throwable)e);
        }
        finally {
            this.dfs.closeDfsClient(udfso);
        }
    }

    private Path buildInputFilePath(Users user, Project project, Featurestore fs) throws FeaturestoreException {
        try {
            Files.createDirectories(this.REQUEST_SCRATCH_DIR, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CONNECTION_CHECKER_ERROR, Level.SEVERE, "Failed to create staging directory", e.getMessage(), (Throwable)e);
        }
        return Paths.get(this.REQUEST_SCRATCH_DIR.toString(), String.format("%s_%s_%s_%s.json", user.getUsername(), project.getId(), fs.getId(), System.currentTimeMillis()));
    }

    private void getContainerLogs(Path logFile) throws FeaturestoreException {
        if (Files.exists(logFile, new LinkOption[0])) {
            try {
                LOGGER.log(Level.FINE, "Reading container logs from path {}", logFile.toAbsolutePath());
                String logLines = String.join((CharSequence)"\n", Files.readAllLines(logFile));
                if (!Strings.isNullOrEmpty((String)logLines)) {
                    LOGGER.log(Level.INFO, logLines);
                }
            }
            catch (IOException e) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FILE_READ_ERROR, Level.SEVERE, String.format("Failure during reading container logs %s", logFile), "", (Throwable)e);
            }
            finally {
                this.deleteStagedDir();
            }
        }
    }

    private void deleteStagedDir() throws FeaturestoreException {
        try {
            PathUtils.delete((Path)this.REQUEST_SCRATCH_DIR);
            LOGGER.log(Level.FINE, "Deleted staged directory: {}", this.REQUEST_SCRATCH_DIR);
        }
        catch (IOException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FILE_DELETION_ERROR, Level.SEVERE, String.format("Failure during cleaning up staged directory %s", this.REQUEST_SCRATCH_DIR), "", (Throwable)e);
        }
    }

    protected ProcessResult execute(Path jsonFile) throws FeaturestoreException {
        try {
            ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().setWaitTimeout(10L, TimeUnit.SECONDS).addCommand("/usr/bin/sudo").addCommand(Paths.get(this.settings.getSudoersDir(), this.settings.getTEST_CONNECTOR_LAUNCHER()).toString()).addCommand(jsonFile.toString()).addCommand(this.projectUtils.getFullDockerImageName(this.settings.getTestConnectorImage())).build();
            String containerLogFileName = FilenameUtils.getBaseName((String)jsonFile.toString()).concat(".log");
            LOGGER.log(Level.INFO, "Executing process to start docker container for testing connection");
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                this.getContainerLogs(Paths.get(jsonFile.getParent().toString(), containerLogFileName));
            }
            LOGGER.log(Level.INFO, "Ended process of docker container for testing connection");
            return processResult;
        }
        catch (ServiceDiscoveryException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.DOCKER_FULLNAME_ERROR, Level.SEVERE, String.format("Full docker image not found for image %s", this.settings.getTestConnectorImage()), e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CONNECTION_CHECKER_LAUNCH_ERROR, Level.SEVERE, "Could not execute connection check", e.getMessage(), (Throwable)e);
        }
    }
}

