/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.trainingdatasets;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.logicalclocks.shaded.com.google.common.collect.Streams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.hops.hopsworks.common.commands.featurestore.search.SearchFSCommandLogger;
import io.hops.hopsworks.common.dao.user.activity.ActivityFacade;
import io.hops.hopsworks.common.featurestore.FeaturestoreController;
import io.hops.hopsworks.common.featurestore.activity.FeaturestoreActivityFacade;
import io.hops.hopsworks.common.featurestore.app.FsJobManagerController;
import io.hops.hopsworks.common.featurestore.feature.TrainingDatasetFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.online.OnlineFeaturegroupController;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreController;
import io.hops.hopsworks.common.featurestore.query.Feature;
import io.hops.hopsworks.common.featurestore.query.Query;
import io.hops.hopsworks.common.featurestore.query.QueryController;
import io.hops.hopsworks.common.featurestore.query.QueryDTO;
import io.hops.hopsworks.common.featurestore.query.filter.Filter;
import io.hops.hopsworks.common.featurestore.query.filter.FilterController;
import io.hops.hopsworks.common.featurestore.query.filter.FilterLogic;
import io.hops.hopsworks.common.featurestore.query.filter.FilterValue;
import io.hops.hopsworks.common.featurestore.query.join.Join;
import io.hops.hopsworks.common.featurestore.query.pit.PitJoinController;
import io.hops.hopsworks.common.featurestore.statistics.StatisticsController;
import io.hops.hopsworks.common.featurestore.statistics.columns.StatisticColumnController;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreConnectorFacade;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetFacade;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetInputValidation;
import io.hops.hopsworks.common.featurestore.trainingdatasets.external.ExternalTrainingDatasetController;
import io.hops.hopsworks.common.featurestore.trainingdatasets.hopsfs.HopsfsTrainingDatasetController;
import io.hops.hopsworks.common.featurestore.transformationFunction.TransformationFunctionFacade;
import io.hops.hopsworks.common.featurestore.utils.FeaturestoreUtils;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.security.QuotaEnforcementException;
import io.hops.hopsworks.common.security.QuotasEnforcement;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.JobException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.activity.FeaturestoreActivityMeta;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.FeaturegroupType;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.CachedFeatureExtraConstraints;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.TimeTravelFormat;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.ondemand.OnDemandFeature;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.StatisticColumn;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.StatisticsConfig;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnectorType;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.SqlFilterLogic;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetFeature;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetFilter;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetFilterCondition;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetJoin;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetJoinCondition;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetType;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.split.SplitType;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.split.TrainingDatasetSplit;
import io.hops.hopsworks.persistence.entity.featurestore.transformationFunction.TransformationFunction;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.activity.ActivityFlag;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.apache.calcite.sql.JoinType;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.javatuples.Pair;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class TrainingDatasetController {
    @EJB
    private TrainingDatasetFacade trainingDatasetFacade;
    @EJB
    private HopsfsTrainingDatasetController hopsfsTrainingDatasetController;
    @EJB
    private ExternalTrainingDatasetController externalTrainingDatasetController;
    @EJB
    private TrainingDatasetInputValidation trainingDatasetInputValidation;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private HdfsUsersController hdfsUsersBean;
    @EJB
    private FeaturestoreUtils featurestoreUtils;
    @EJB
    private StatisticsController statisticsController;
    @EJB
    private OnlineFeaturestoreController onlineFeaturestoreController;
    @EJB
    private FeaturegroupController featuregroupController;
    @EJB
    private FeaturestoreConnectorFacade featurestoreConnectorFacade;
    @EJB
    private FeaturestoreActivityFacade fsActivityFacade;
    @EJB
    private StatisticColumnController statisticColumnController;
    @EJB
    private OnlineFeaturegroupController onlineFeaturegroupController;
    @EJB
    private TransformationFunctionFacade transformationFunctionFacade;
    @EJB
    private TrainingDatasetInputValidation inputValidation;
    @EJB
    private PitJoinController pitJoinController;
    @EJB
    private QueryController queryController;
    @EJB
    private ActivityFacade activityFacade;
    @EJB
    private QuotasEnforcement quotasEnforcement;
    @EJB
    private FilterController filterController;
    @Inject
    private FsJobManagerController fsJobManagerController;
    @Inject
    private Settings settings;
    @Inject
    private FeaturestoreController featurestoreController;
    @EJB
    private SearchFSCommandLogger searchCommandLogger;

    public List<TrainingDatasetDTO> getTrainingDatasetsForFeaturestore(Users user, Project project, Featurestore featurestore) throws ServiceException, FeaturestoreException {
        ArrayList<TrainingDatasetDTO> trainingDatasets = new ArrayList<TrainingDatasetDTO>();
        for (TrainingDataset td : this.trainingDatasetFacade.findByFeaturestore(featurestore)) {
            trainingDatasets.add(this.convertTrainingDatasetToDTO(user, project, td));
        }
        return trainingDatasets;
    }

    public TrainingDatasetDTO convertTrainingDatasetToDTO(Users user, Project project, TrainingDataset trainingDataset) throws ServiceException, FeaturestoreException {
        return this.convertTrainingDatasetToDTO(user, project, trainingDataset, false);
    }

    public TrainingDatasetDTO convertTrainingDatasetToDTO(Users user, Project project, TrainingDataset trainingDataset, Boolean skipFeature) throws ServiceException, FeaturestoreException {
        TrainingDatasetDTO trainingDatasetDTO = new TrainingDatasetDTO(trainingDataset);
        trainingDatasetDTO.setFeaturestoreName(this.featurestoreController.getOfflineFeaturestoreDbName(trainingDataset.getFeaturestore()));
        if (!skipFeature.booleanValue()) {
            List<TrainingDatasetFeature> tdFeatures = this.getFeaturesSorted(trainingDataset, true);
            Map<Integer, String> fsLookupTable = this.getFsLookupTableFeatures(tdFeatures);
            trainingDatasetDTO.setFeatures(tdFeatures.stream().map(f -> new TrainingDatasetFeatureDTO(this.checkPrefix((TrainingDatasetFeature)f), f.getType(), f.getFeatureGroup() != null ? new FeaturegroupDTO(f.getFeatureGroup().getFeaturestore().getId(), (String)fsLookupTable.get(f.getFeatureGroup().getFeaturestore().getId()), f.getFeatureGroup().getId(), f.getFeatureGroup().getName(), f.getFeatureGroup().getVersion(), f.getFeatureGroup().isDeprecated()) : null, f.getName(), f.getIndex(), f.isLabel(), f.isInferenceHelperColumn(), f.isTrainingHelperColumn())).collect(Collectors.toList()));
        }
        switch (trainingDataset.getTrainingDatasetType()) {
            case HOPSFS_TRAINING_DATASET: 
            case IN_MEMORY_TRAINING_DATASET: {
                return this.hopsfsTrainingDatasetController.convertHopsfsTrainingDatasetToDTO(trainingDatasetDTO, trainingDataset);
            }
            case EXTERNAL_TRAINING_DATASET: {
                return this.externalTrainingDatasetController.convertExternalTrainingDatasetToDTO(user, project, trainingDatasetDTO, trainingDataset);
            }
        }
        throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_TRAINING_DATASET_TYPE.getMessage() + ", Recognized training dataset types are: " + TrainingDatasetType.HOPSFS_TRAINING_DATASET + ", and: " + TrainingDatasetType.EXTERNAL_TRAINING_DATASET + ". The provided training dataset type was not recognized: " + trainingDataset.getTrainingDatasetType());
    }

    public TrainingDatasetDTO createTrainingDataset(Users user, Project project, Featurestore featurestore, FeatureView featureView, TrainingDatasetDTO trainingDatasetDTO) throws FeaturestoreException, IOException, ServiceException {
        trainingDatasetDTO.setName(featureView.getName() + "_" + featureView.getVersion());
        Query query = this.queryController.makeQuery(featureView, project, user, true, false, false, false, false, false);
        if (query.getDeletedFeatureGroups() != null && !query.getDeletedFeatureGroups().isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_NOT_FOUND, Level.SEVERE, String.format("Cannot create the training dataset because parent feature groups of the following features are not available anymore: %s", String.join((CharSequence)", ", query.getDeletedFeatureGroups())));
        }
        return this.createTrainingDataset(user, project, featurestore, featureView, trainingDatasetDTO, query, true);
    }

    public TrainingDatasetDTO createTrainingDataset(Users user, Project project, Featurestore featurestore, TrainingDatasetDTO trainingDatasetDTO) throws FeaturestoreException, IOException, ServiceException {
        Query query = null;
        if (trainingDatasetDTO.getQueryDTO() != null) {
            query = this.constructQuery(trainingDatasetDTO.getQueryDTO(), project, user);
        } else if (trainingDatasetDTO.getFeatures() == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NO_SCHEMA, Level.FINE, "The training dataset doesn't have any feature");
        }
        return this.createTrainingDataset(user, project, featurestore, null, trainingDatasetDTO, query, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrainingDatasetDTO createTrainingDataset(Users user, Project project, Featurestore featurestore, FeatureView featureView, TrainingDatasetDTO trainingDatasetDTO, Query query, Boolean skipFeature) throws FeaturestoreException, IOException, ServiceException {
        FeaturestoreConnector featurestoreConnector;
        this.featurestoreUtils.verifyUserProjectEqualsFsProject(user, project, featurestore, FeaturestoreUtils.ActionMessage.CREATE_TRAINING_DATASET);
        try {
            this.quotasEnforcement.enforceTrainingDatasetsQuota(featurestore);
        }
        catch (QuotaEnforcementException ex) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_COULD_NOT_BE_CREATED, Level.SEVERE, ex.getMessage(), ex.getMessage(), (Throwable)ex);
        }
        if (trainingDatasetDTO.getVersion() == null) {
            List<TrainingDataset> tdPrevious = featureView != null ? this.trainingDatasetFacade.findByFeatureViewAndVersionOrderedDescVersion(featureView) : this.trainingDatasetFacade.findByNameAndFeaturestoreOrderedDescVersion(trainingDatasetDTO.getName(), featurestore);
            if (tdPrevious != null && !tdPrevious.isEmpty()) {
                trainingDatasetDTO.setVersion(tdPrevious.get(0).getVersion() + 1);
            } else {
                trainingDatasetDTO.setVersion(1);
            }
        }
        if (featureView != null && this.trainingDatasetFacade.findByFeatureViewAndVersionNullable(featureView, trainingDatasetDTO.getVersion()).isPresent() || featureView == null && this.trainingDatasetFacade.findByNameVersionAndFeaturestore(trainingDatasetDTO.getName(), trainingDatasetDTO.getVersion(), featurestore).isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_ALREADY_EXISTS, Level.FINE, "Training Dataset: " + trainingDatasetDTO.getName() + ", version: " + trainingDatasetDTO.getVersion());
        }
        this.inputValidation.validate(trainingDatasetDTO, query);
        if (trainingDatasetDTO.getTrainingDatasetType() == TrainingDatasetType.HOPSFS_TRAINING_DATASET) {
            featurestoreConnector = trainingDatasetDTO.getStorageConnector() != null && trainingDatasetDTO.getStorageConnector().getId() != null ? this.featurestoreConnectorFacade.findByIdType(trainingDatasetDTO.getStorageConnector().getId(), FeaturestoreConnectorType.HOPSFS).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.HOPSFS_CONNECTOR_NOT_FOUND, Level.FINE, "HOPSFS Connector: " + trainingDatasetDTO.getStorageConnector().getId())) : this.getDefaultHopsFSTrainingDatasetConnector(featurestore);
        } else if (trainingDatasetDTO.getTrainingDatasetType() == TrainingDatasetType.EXTERNAL_TRAINING_DATASET) {
            if (trainingDatasetDTO.getStorageConnector() == null) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CONNECTOR_NOT_FOUND, Level.FINE, "Storage connector is empty");
            }
            featurestoreConnector = this.featurestoreConnectorFacade.findById(trainingDatasetDTO.getStorageConnector().getId()).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CONNECTOR_NOT_FOUND, Level.FINE, "Connector: " + trainingDatasetDTO.getStorageConnector().getId()));
        } else {
            featurestoreConnector = this.getDefaultHopsFSTrainingDatasetConnector(featurestore);
        }
        Dataset trainingDatasetsFolder = featurestoreConnector.getHopsfsConnector() != null ? featurestoreConnector.getHopsfsConnector().getHopsfsDataset() : this.getDefaultHopsFSTrainingDatasetConnector(featurestore).getHopsfsConnector().getHopsfsDataset();
        String tagPath = this.getTrainingDatasetPath(Utils.getDatasetPath(trainingDatasetsFolder, this.settings).toString(), trainingDatasetDTO.getName(), trainingDatasetDTO.getVersion());
        DistributedFileSystemOps udfso = null;
        String username = this.hdfsUsersBean.getHdfsUserName(project, user);
        try {
            udfso = this.dfs.getDfsOps(username);
            udfso.mkdir(tagPath);
            Pair<TrainingDatasetDTO, TrainingDataset> aux = this.createTrainingDatasetMetadata(user, project, featurestore, featureView, trainingDatasetDTO, query, featurestoreConnector, tagPath, skipFeature);
            TrainingDatasetDTO completeTrainingDatasetDTO = (TrainingDatasetDTO)aux.getValue0();
            this.searchCommandLogger.create((TrainingDataset)aux.getValue1());
            if (featureView == null) {
                this.searchCommandLogger.updateMetadata((TrainingDataset)aux.getValue1());
            }
            this.activityFacade.persistActivity(" created a new training dataset named " + completeTrainingDatasetDTO.getName(), project, user, ActivityFlag.SERVICE);
            TrainingDatasetDTO trainingDatasetDTO2 = completeTrainingDatasetDTO;
            return trainingDatasetDTO2;
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    public FeaturestoreConnector getHopsFsConnector(TrainingDataset trainingDataset) throws FeaturestoreException {
        FeaturestoreConnector featurestoreConnector = null;
        switch (trainingDataset.getTrainingDatasetType()) {
            case HOPSFS_TRAINING_DATASET: 
            case IN_MEMORY_TRAINING_DATASET: {
                featurestoreConnector = trainingDataset.getFeaturestoreConnector();
                break;
            }
            case EXTERNAL_TRAINING_DATASET: {
                featurestoreConnector = this.getDefaultHopsFSTrainingDatasetConnector(trainingDataset.getFeaturestore());
            }
        }
        return featurestoreConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(justification="Should be fixed", value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean isTrainingDatasetAvailable(TrainingDataset trainingDataset, Users user) throws FeaturestoreException, IOException {
        switch (trainingDataset.getTrainingDatasetType()) {
            case IN_MEMORY_TRAINING_DATASET: {
                return false;
            }
            case EXTERNAL_TRAINING_DATASET: {
                return null;
            }
        }
        String trainingDatasetRootPath = this.getTrainingDatasetPath(Utils.getDatasetPath(this.getHopsFsConnector(trainingDataset).getHopsfsConnector().getHopsfsDataset(), this.settings).toString(), trainingDataset.getName(), trainingDataset.getVersion());
        String username = this.hdfsUsersBean.getHdfsUserName(trainingDataset.getFeaturestore().getProject(), user);
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfs.getDfsOps(username);
            if (!trainingDataset.getSplits().isEmpty()) {
                for (TrainingDatasetSplit split : trainingDataset.getSplits()) {
                    if (dfso.exists(trainingDatasetRootPath + "/" + split.getName())) continue;
                    Boolean bl = false;
                    return bl;
                }
                Boolean bl = true;
                return bl;
            }
            Boolean bl = dfso.exists(trainingDatasetRootPath + "/" + trainingDataset.getName());
            return bl;
        }
        finally {
            this.dfs.closeDfsClient(dfso);
        }
    }

    private FeaturestoreConnector getDefaultHopsFSTrainingDatasetConnector(Featurestore featurestore) throws FeaturestoreException {
        String connectorName = featurestore.getProject().getName() + "_" + Settings.ServiceDataset.TRAININGDATASETS.getName();
        return this.featurestoreConnectorFacade.findByFeaturestoreName(featurestore, connectorName).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.HOPSFS_CONNECTOR_NOT_FOUND, Level.FINE, "HOPSFS Connector: " + connectorName));
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    private Pair<TrainingDatasetDTO, TrainingDataset> createTrainingDatasetMetadata(Users user, Project project, Featurestore featurestore, FeatureView featureView, TrainingDatasetDTO trainingDatasetDTO, Query query, FeaturestoreConnector featurestoreConnector, String tagPath, Boolean skipFeature) throws FeaturestoreException, ServiceException {
        TrainingDataset trainingDataset = new TrainingDataset();
        trainingDataset.setFeatureView(featureView);
        if (trainingDatasetDTO.getEventStartTime() != null) {
            trainingDataset.setStartTime(trainingDatasetDTO.getEventStartTime());
        }
        if (trainingDatasetDTO.getEventEndTime() != null) {
            trainingDataset.setEndTime(trainingDatasetDTO.getEventEndTime());
        }
        trainingDataset.setSampleRatio(trainingDatasetDTO.getSampleRatio());
        trainingDataset.setName(trainingDatasetDTO.getName());
        trainingDataset.setDataFormat(trainingDatasetDTO.getDataFormat());
        trainingDataset.setDescription(trainingDatasetDTO.getDescription());
        trainingDataset.setFeaturestore(featurestore);
        trainingDataset.setCreated(new Date());
        trainingDataset.setCreator(user);
        trainingDataset.setVersion(trainingDatasetDTO.getVersion());
        trainingDataset.setTrainingDatasetType(trainingDatasetDTO.getTrainingDatasetType());
        trainingDataset.setSeed(trainingDatasetDTO.getSeed());
        trainingDataset.setSplits((Collection)trainingDatasetDTO.getSplits().stream().map(split -> {
            if (SplitType.RANDOM_SPLIT.equals((Object)split.getSplitType())) {
                return new TrainingDatasetSplit(trainingDataset, split.getName(), split.getPercentage());
            }
            return new TrainingDatasetSplit(trainingDataset, split.getName(), split.getStartTime(), split.getEndTime());
        }).collect(Collectors.toList()));
        trainingDataset.setCoalesce(Boolean.valueOf(trainingDatasetDTO.getCoalesce() != null ? trainingDatasetDTO.getCoalesce() : false));
        trainingDataset.setFeaturestoreConnector(featurestoreConnector);
        trainingDataset.setConnectorPath(trainingDatasetDTO.getLocation());
        trainingDataset.setTagPath(tagPath);
        StatisticsConfig statisticsConfig = new StatisticsConfig(trainingDatasetDTO.getStatisticsConfig().getEnabled().booleanValue(), trainingDatasetDTO.getStatisticsConfig().getCorrelations().booleanValue(), trainingDatasetDTO.getStatisticsConfig().getHistograms().booleanValue(), trainingDatasetDTO.getStatisticsConfig().getExactUniqueness().booleanValue());
        statisticsConfig.setTrainingDataset(trainingDataset);
        statisticsConfig.setStatisticColumns((Collection)trainingDatasetDTO.getStatisticsConfig().getColumns().stream().map(sc -> new StatisticColumn(statisticsConfig, sc)).collect(Collectors.toList()));
        trainingDataset.setStatisticsConfig(statisticsConfig);
        trainingDataset.setTrainSplit(trainingDatasetDTO.getTrainSplit());
        if (featureView == null) {
            trainingDataset.setQuery(trainingDatasetDTO.getQueryDTO() != null);
            if (trainingDataset.isQuery()) {
                this.setTrainingDatasetQuery(query, trainingDatasetDTO.getFeatures(), trainingDataset);
            } else if (trainingDatasetDTO.getFeatures() != null) {
                trainingDataset.setFeatures(this.getTrainingDatasetFeatures(trainingDatasetDTO.getFeatures(), trainingDataset));
            }
        } else if (trainingDatasetDTO.getExtraFilter() != null) {
            trainingDataset.setFilters(this.convertToFilterEntities(this.filterController.convertFilterLogic(project, user, query, trainingDatasetDTO.getExtraFilter()), trainingDataset, "L"));
        }
        TrainingDataset dbTrainingDataset = (TrainingDataset)this.trainingDatasetFacade.update(trainingDataset);
        this.fsActivityFacade.logMetadataActivity(user, dbTrainingDataset, featureView, FeaturestoreActivityMeta.TD_CREATED);
        return Pair.with((Object)this.convertTrainingDatasetToDTO(user, project, dbTrainingDataset, skipFeature), (Object)dbTrainingDataset);
    }

    private Query constructQuery(QueryDTO queryDTO, Project project, Users user) throws FeaturestoreException {
        HashMap<Integer, String> fgAliasLookup = new HashMap<Integer, String>();
        HashMap<Integer, Featuregroup> fgLookup = new HashMap<Integer, Featuregroup>();
        HashMap<Integer, List<Feature>> availableFeatureLookup = new HashMap<Integer, List<Feature>>();
        this.queryController.populateFgLookupTables(queryDTO, 0, fgAliasLookup, fgLookup, availableFeatureLookup, project, user, null);
        return this.queryController.convertQueryDTO(queryDTO, fgAliasLookup, fgLookup, availableFeatureLookup, this.pitJoinController.isPitEnabled(queryDTO));
    }

    private void setTrainingDatasetQuery(Query query, List<TrainingDatasetFeatureDTO> features, TrainingDataset trainingDataset) throws FeaturestoreException {
        List<TrainingDatasetJoin> tdJoins = this.collectJoins(query, trainingDataset, null);
        trainingDataset.setJoins(tdJoins);
        List<TrainingDatasetFeature> tdFeatures = this.collectFeatures(query, features, trainingDataset, null, 0, tdJoins, 0);
        trainingDataset.setFeatures(tdFeatures);
        List<TrainingDatasetFilter> filters = this.convertToFilterEntities(query.getFilter(), trainingDataset, "L");
        trainingDataset.setFilters(filters);
    }

    List<TrainingDatasetFilter> convertToFilterEntities(FilterLogic filterLogic, TrainingDataset trainingDataset, String path) {
        return this.convertToFilterEntities(filterLogic, null, trainingDataset, path);
    }

    public List<TrainingDatasetFilter> convertToFilterEntities(FilterLogic filterLogic, FeatureView featureView, String path) {
        return this.convertToFilterEntities(filterLogic, featureView, null, path);
    }

    private List<TrainingDatasetFilter> convertToFilterEntities(FilterLogic filterLogic, FeatureView featureView, TrainingDataset trainingDataset, String path) {
        ArrayList<TrainingDatasetFilter> filters = new ArrayList<TrainingDatasetFilter>();
        if (filterLogic == null) {
            return filters;
        }
        if (filterLogic.getType().equals((Object)SqlFilterLogic.SINGLE)) {
            if (filterLogic.getLeftFilter() == null) {
                filters.add(this.makeTrainingDatasetFilter(path, featureView, trainingDataset, filterLogic.getRightFilter(), SqlFilterLogic.SINGLE));
            } else {
                filters.add(this.makeTrainingDatasetFilter(path, featureView, trainingDataset, filterLogic.getLeftFilter(), filterLogic.getType()));
            }
        } else {
            filters.add(this.makeTrainingDatasetFilter(path, featureView, trainingDataset, null, filterLogic.getType()));
            if (filterLogic.getLeftFilter() != null) {
                filters.add(this.makeTrainingDatasetFilter(path + ".L", featureView, trainingDataset, filterLogic.getLeftFilter(), SqlFilterLogic.SINGLE));
            }
            if (filterLogic.getRightFilter() != null) {
                filters.add(this.makeTrainingDatasetFilter(path + ".R", featureView, trainingDataset, filterLogic.getRightFilter(), SqlFilterLogic.SINGLE));
            }
            filters.addAll(this.convertToFilterEntities(filterLogic.getLeftLogic(), featureView, trainingDataset, path + ".L"));
            filters.addAll(this.convertToFilterEntities(filterLogic.getRightLogic(), featureView, trainingDataset, path + ".R"));
        }
        return filters;
    }

    private TrainingDatasetFilter makeTrainingDatasetFilter(String path, FeatureView featureView, TrainingDataset trainingDataset, Filter filter, SqlFilterLogic type) {
        TrainingDatasetFilter trainingDatasetFilter = featureView == null ? new TrainingDatasetFilter(trainingDataset) : new TrainingDatasetFilter(featureView);
        TrainingDatasetFilterCondition condition = filter == null ? null : this.convertFilter(filter, trainingDatasetFilter);
        trainingDatasetFilter.setCondition(condition);
        trainingDatasetFilter.setPath(path);
        trainingDatasetFilter.setType(type);
        return trainingDatasetFilter;
    }

    private TrainingDatasetFilterCondition convertFilter(Filter filter, TrainingDatasetFilter trainingDatasetFilter) {
        return new TrainingDatasetFilterCondition(trainingDatasetFilter, filter.getFeatures().get(0).getFeatureGroup(), filter.getFeatures().get(0).getName(), filter.getCondition(), filter.getValue().getFeatureGroupId(), filter.getValue().getValue());
    }

    public List<TrainingDatasetFeature> collectFeatures(Query query, List<TrainingDatasetFeatureDTO> featureDTOs, TrainingDataset trainingDataset, FeatureView featureView, int featureIndex, List<TrainingDatasetJoin> tdJoins, int joinIndex) throws FeaturestoreException {
        ArrayList<TrainingDatasetFeature> features = new ArrayList<TrainingDatasetFeature>();
        boolean isLabel = false;
        boolean isInferenceHelper = false;
        boolean isTrainingHelper = false;
        TransformationFunction transformationFunction = null;
        for (Feature f : query.getFeatures()) {
            TrainingDatasetFeature trainingDatasetFeature;
            if (featureDTOs != null && !featureDTOs.isEmpty()) {
                isLabel = featureDTOs.stream().anyMatch(dto -> f.getName().equals(dto.getName()) && dto.getLabel() != false && (dto.getFeaturegroup() == null || f.getFeatureGroup().getId().equals(dto.getFeaturegroup().getId())));
                isInferenceHelper = featureDTOs.stream().anyMatch(dto -> f.getName().equals(dto.getName()) && dto.getInferenceHelperColumn() != false && (dto.getFeaturegroup() == null || f.getFeatureGroup().getId().equals(dto.getFeaturegroup().getId())));
                isTrainingHelper = featureDTOs.stream().anyMatch(dto -> f.getName().equals(dto.getName()) && dto.getTrainingHelperColumn() != false && (dto.getFeaturegroup() == null || f.getFeatureGroup().getId().equals(dto.getFeaturegroup().getId())));
                transformationFunction = this.getTransformationFunction(f, featureDTOs, tdJoins.get(joinIndex).getPrefix());
            }
            if (trainingDataset != null) {
                ++featureIndex;
                trainingDatasetFeature = new TrainingDatasetFeature(trainingDataset, tdJoins.get(joinIndex), query.getFeaturegroup(), f.getName(), f.getType(), Integer.valueOf(featureIndex), isLabel, isInferenceHelper, isTrainingHelper, transformationFunction);
            } else {
                ++featureIndex;
                trainingDatasetFeature = new TrainingDatasetFeature(featureView, tdJoins.get(joinIndex), query.getFeaturegroup(), f.getName(), f.getType(), Integer.valueOf(featureIndex), isLabel, isInferenceHelper, isTrainingHelper, transformationFunction);
            }
            features.add(trainingDatasetFeature);
        }
        if (query.getJoins() != null) {
            for (Join join : query.getJoins()) {
                List<TrainingDatasetFeature> joinFeatures = this.collectFeatures(join.getRightQuery(), featureDTOs, trainingDataset, featureView, featureIndex, tdJoins, ++joinIndex);
                features.addAll(joinFeatures);
                featureIndex += joinFeatures.size();
            }
        }
        return features;
    }

    public List<TrainingDatasetJoin> collectJoins(Query query, TrainingDataset trainingDataset, FeatureView featureView) {
        ArrayList<TrainingDatasetJoin> joins = new ArrayList<TrainingDatasetJoin>();
        Featuregroup featuregroup = query.getFeaturegroup();
        int index = 0;
        if (featuregroup.getFeaturegroupType() == FeaturegroupType.CACHED_FEATURE_GROUP && featuregroup.getCachedFeaturegroup().getTimeTravelFormat() == TimeTravelFormat.HUDI || featuregroup.getFeaturegroupType() == FeaturegroupType.STREAM_FEATURE_GROUP) {
            joins.add(this.makeTrainingDatasetJoin(trainingDataset, featureView, featuregroup, query.getLeftFeatureGroupEndCommitId(), (short)0, index++, null));
        } else {
            joins.add(this.makeTrainingDatasetJoin(trainingDataset, featureView, query.getFeaturegroup(), null, (short)0, index++, null));
        }
        if (query.getJoins() != null && !query.getJoins().isEmpty()) {
            for (Join join : query.getJoins()) {
                Featuregroup rightFeaturegroup = join.getRightQuery().getFeaturegroup();
                TrainingDatasetJoin tdJoin = rightFeaturegroup.getFeaturegroupType() == FeaturegroupType.CACHED_FEATURE_GROUP && rightFeaturegroup.getCachedFeaturegroup().getTimeTravelFormat() == TimeTravelFormat.HUDI || rightFeaturegroup.getFeaturegroupType() == FeaturegroupType.STREAM_FEATURE_GROUP ? this.makeTrainingDatasetJoin(trainingDataset, featureView, rightFeaturegroup, join.getRightQuery().getLeftFeatureGroupEndCommitId(), (short)join.getJoinType().ordinal(), index++, join.getPrefix()) : this.makeTrainingDatasetJoin(trainingDataset, featureView, rightFeaturegroup, null, (short)join.getJoinType().ordinal(), index++, join.getPrefix());
                tdJoin.setConditions(this.collectJoinConditions(join, tdJoin));
                joins.add(tdJoin);
            }
        }
        return joins;
    }

    public List<TrainingDatasetFilter> collectFilters(Query query, FeatureView featureView) {
        FilterLogic filterLogic = this.collectFilterLogics(Lists.newArrayList((Object[])new Query[]{query}));
        return this.convertToFilterEntities(filterLogic, featureView, "L");
    }

    FilterLogic collectFilterLogics(List<Query> queries) {
        if (queries.size() > 0) {
            Query query = queries.get(0);
            ArrayList subQueries = Lists.newArrayList();
            if (query.getJoins() != null) {
                subQueries.addAll(query.getJoins().stream().map(Join::getRightQuery).collect(Collectors.toList()));
            }
            subQueries.addAll(queries.subList(1, queries.size()));
            FilterLogic filterSubQueries = this.collectFilterLogics(subQueries);
            if (query.getFilter() != null && filterSubQueries != null) {
                FilterLogic filterLogic = new FilterLogic();
                filterLogic.setType(SqlFilterLogic.AND);
                filterLogic.setLeftLogic(query.getFilter());
                filterLogic.setRightLogic(filterSubQueries);
                return filterLogic;
            }
            if (query.getFilter() != null) {
                return query.getFilter();
            }
            if (filterSubQueries != null) {
                return filterSubQueries;
            }
            return null;
        }
        return null;
    }

    private TrainingDatasetJoin makeTrainingDatasetJoin(TrainingDataset trainingDataset, FeatureView featureView, Featuregroup featureGroup, Long featureGroupCommitId, short type, int index, String prefix) {
        if (trainingDataset != null) {
            return new TrainingDatasetJoin(trainingDataset, featureGroup, featureGroupCommitId, type, index, prefix);
        }
        return new TrainingDatasetJoin(featureView, featureGroup, featureGroupCommitId, type, index, prefix);
    }

    private List<TrainingDatasetJoinCondition> collectJoinConditions(Join join, TrainingDatasetJoin tdJoin) {
        return Streams.zip(join.getLeftOn().stream(), join.getRightOn().stream(), (left, right) -> new TrainingDatasetJoinCondition(tdJoin, left.getName(), right.getName())).collect(Collectors.toList());
    }

    private List<TrainingDatasetFeature> getTrainingDatasetFeatures(List<TrainingDatasetFeatureDTO> featureList, TrainingDataset trainingDataset) {
        ArrayList<TrainingDatasetFeature> trainingDatasetFeatureList = new ArrayList<TrainingDatasetFeature>();
        int index = 0;
        for (TrainingDatasetFeatureDTO f : featureList) {
            trainingDatasetFeatureList.add(new TrainingDatasetFeature(trainingDataset, f.getName(), f.getType(), Integer.valueOf(index++), f.getLabel().booleanValue(), null));
        }
        return trainingDatasetFeatureList;
    }

    public TrainingDatasetDTO getTrainingDatasetWithIdAndFeaturestore(Users user, Project project, Featurestore featurestore, Integer id) throws FeaturestoreException, ServiceException {
        TrainingDataset trainingDataset = this.getTrainingDatasetById(featurestore, id);
        return this.convertTrainingDatasetToDTO(user, project, trainingDataset);
    }

    public TrainingDataset getTrainingDatasetById(Featurestore featurestore, Integer id) throws FeaturestoreException {
        return this.trainingDatasetFacade.findByIdAndFeaturestore(id, featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "trainingDatasetId: " + id));
    }

    public TrainingDataset getTrainingDatasetByFeatureViewAndVersion(FeatureView featureView, Integer version) throws FeaturestoreException {
        return this.trainingDatasetFacade.findByFeatureViewAndVersion(featureView, version);
    }

    public List<TrainingDataset> getTrainingDatasetByFeatureView(FeatureView featureView) {
        return this.trainingDatasetFacade.findByFeatureView(featureView);
    }

    public List<TrainingDatasetDTO> getWithNameAndFeaturestore(Users user, Project project, Featurestore featurestore, String name) throws FeaturestoreException, ServiceException {
        List<TrainingDataset> trainingDatasetList = this.trainingDatasetFacade.findByNameAndFeaturestore(name, featurestore);
        if (trainingDatasetList == null || trainingDatasetList.isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "training dataset name : " + name);
        }
        ArrayList<TrainingDatasetDTO> trainingDatasetDTOS = new ArrayList<TrainingDatasetDTO>();
        for (TrainingDataset td : trainingDatasetList) {
            trainingDatasetDTOS.add(this.convertTrainingDatasetToDTO(user, project, td));
        }
        return trainingDatasetDTOS;
    }

    public TrainingDatasetDTO getWithNameVersionAndFeaturestore(Users user, Project project, Featurestore featurestore, String name, Integer version) throws FeaturestoreException, ServiceException {
        Optional<TrainingDataset> trainingDataset = this.trainingDatasetFacade.findByNameVersionAndFeaturestore(name, version, featurestore);
        return this.convertTrainingDatasetToDTO(user, project, trainingDataset.orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "training dataset name : " + name)));
    }

    public String delete(Users user, Project project, Featurestore featurestore, Integer trainingDatasetId) throws FeaturestoreException, JobException {
        TrainingDataset trainingDataset = this.trainingDatasetFacade.findByIdAndFeaturestore(trainingDatasetId, featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "training dataset id:" + trainingDatasetId));
        return this.delete(user, project, featurestore, trainingDataset);
    }

    public void delete(Users user, Project project, Featurestore featurestore, FeatureView featureView, Integer trainingDatasetVersion) throws FeaturestoreException, JobException {
        TrainingDataset trainingDataset = this.getTrainingDatasetByFeatureViewAndVersion(featureView, trainingDatasetVersion);
        String trainingDatasetName = this.delete(user, project, featurestore, trainingDataset);
        this.activityFacade.persistActivity(" deleted a training dataset(data and metadata) named " + trainingDatasetName + " and version " + trainingDataset.getVersion(), project, user, ActivityFlag.SERVICE);
    }

    public void delete(Users user, Project project, Featurestore featurestore, FeatureView featureView) throws FeaturestoreException, JobException {
        List<TrainingDataset> trainingDatasets = this.getTrainingDatasetByFeatureView(featureView);
        for (TrainingDataset trainingDataset : trainingDatasets) {
            this.featurestoreUtils.verifyTrainingDatasetDataOwnerOrSelf(user, project, trainingDataset, FeaturestoreUtils.ActionMessage.DELETE_TRAINING_DATASET);
        }
        for (TrainingDataset trainingDataset : trainingDatasets) {
            this.delete(user, project, featurestore, featureView, trainingDataset.getVersion());
        }
    }

    public String delete(Users user, Project project, Featurestore featurestore, TrainingDataset trainingDataset) throws FeaturestoreException, JobException {
        this.featurestoreUtils.verifyTrainingDatasetDataOwnerOrSelf(user, project, trainingDataset, FeaturestoreUtils.ActionMessage.DELETE_TRAINING_DATASET);
        this.statisticsController.deleteTrainingDatasetStatistics(project, user, trainingDataset);
        this.searchCommandLogger.delete(trainingDataset);
        this.trainingDatasetFacade.remove(trainingDataset);
        this.deleteHopsfsTrainingData(user, project, trainingDataset, false);
        this.fsJobManagerController.deleteJobs(project, user, trainingDataset);
        return trainingDataset.getName();
    }

    public void deleteDataOnly(Users user, Project project, Featurestore featurestore, FeatureView featureView, Integer trainingDatasetVersion) throws FeaturestoreException {
        TrainingDataset trainingDataset = this.getTrainingDatasetByFeatureViewAndVersion(featureView, trainingDatasetVersion);
        this.featurestoreUtils.verifyTrainingDatasetDataOwnerOrSelf(user, project, trainingDataset, FeaturestoreUtils.ActionMessage.DELETE_TRAINING_DATASET_DATA_ONLY);
        this.deleteDataOnly(user, project, trainingDataset);
    }

    public void deleteDataOnly(Users user, Project project, Featurestore featurestore, FeatureView featureView) throws FeaturestoreException {
        List<TrainingDataset> trainingDatasets = this.getTrainingDatasetByFeatureView(featureView);
        for (TrainingDataset trainingDataset : trainingDatasets) {
            this.featurestoreUtils.verifyTrainingDatasetDataOwnerOrSelf(user, project, trainingDataset, FeaturestoreUtils.ActionMessage.DELETE_TRAINING_DATASET_DATA_ONLY);
        }
        ArrayList failedTd = Lists.newArrayList();
        for (TrainingDataset trainingDataset : trainingDatasets) {
            try {
                this.deleteDataOnly(user, project, trainingDataset);
            }
            catch (FeaturestoreException e) {
                if (RESTCodes.FeaturestoreErrorCode.FAILED_TO_DELETE_TD_DATA.equals((Object)e.getErrorCode())) {
                    failedTd.add(trainingDataset.getVersion());
                    continue;
                }
                throw e;
            }
        }
        if (!failedTd.isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FAILED_TO_DELETE_TD_DATA, Level.FINE, String.format("Failed to delete data for training dataset version: %s. Delete data only is only applicable to 'HOPSFS_TRAINING_DATASET'", Joiner.on((String)", ").join((Iterable)failedTd.stream().sorted().collect(Collectors.toList()))));
        }
    }

    private void deleteDataOnly(Users user, Project project, TrainingDataset trainingDataset) throws FeaturestoreException {
        this.checkDeleteDataOnly(trainingDataset);
        this.deleteHopsfsTrainingData(user, project, trainingDataset, true);
        this.activityFacade.persistActivity(" deleted a training dataset(data only) named " + trainingDataset.getName() + " and version " + trainingDataset.getVersion(), project, user, ActivityFlag.SERVICE);
    }

    private void checkDeleteDataOnly(TrainingDataset trainingDataset) throws FeaturestoreException {
        if (!TrainingDatasetType.HOPSFS_TRAINING_DATASET.equals((Object)trainingDataset.getTrainingDatasetType())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FAILED_TO_DELETE_TD_DATA, Level.FINE, String.format("Failed to delete data for training dataset version: %d. Delete data only is only applicable to 'HOPSFS_TRAINING_DATASET' but not %s.", trainingDataset.getVersion(), trainingDataset.getTrainingDatasetType()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteHopsfsTrainingData(Users user, Project project, TrainingDataset trainingDataset, Boolean keepMetadata) {
        String username = this.hdfsUsersBean.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(username);
        try {
            if (keepMetadata.booleanValue()) {
                FileStatus[] fileStatuses;
                for (FileStatus fileStatus : fileStatuses = udfso.listStatus(new Path(trainingDataset.getTagPath()))) {
                    udfso.rm(fileStatus.getPath(), true);
                }
            } else {
                udfso.rm(trainingDataset.getTagPath(), true);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    public TrainingDatasetDTO updateTrainingDatasetMetadata(Users user, Project project, Featurestore featurestore, TrainingDatasetDTO trainingDatasetDTO) throws FeaturestoreException, ServiceException {
        TrainingDataset trainingDataset = this.trainingDatasetFacade.findByIdAndFeaturestore(trainingDatasetDTO.getId(), featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "training dataset id: " + trainingDatasetDTO.getId()));
        this.featurestoreUtils.verifyTrainingDatasetDataOwnerOrSelf(user, project, trainingDataset, FeaturestoreUtils.ActionMessage.UPDATE_TRAINING_DATASET_METADATA);
        this.trainingDatasetInputValidation.verifyUserInput(trainingDatasetDTO);
        trainingDataset.setDescription(trainingDatasetDTO.getDescription());
        this.trainingDatasetFacade.update(trainingDataset);
        TrainingDataset updatedTrainingDataset = this.trainingDatasetFacade.findByIdAndFeaturestore(trainingDatasetDTO.getId(), featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NOT_FOUND, Level.FINE, "training dataset id: " + trainingDatasetDTO.getId()));
        return this.convertTrainingDatasetToDTO(user, project, updatedTrainingDataset);
    }

    public TrainingDatasetDTO updateTrainingDatasetStatsConfig(Users user, Project project, Featurestore featurestore, TrainingDatasetDTO trainingDatasetDTO) throws FeaturestoreException, ServiceException {
        TrainingDataset trainingDataset = this.getTrainingDatasetById(featurestore, trainingDatasetDTO.getId());
        this.featurestoreUtils.verifyTrainingDatasetDataOwnerOrSelf(user, project, trainingDataset, FeaturestoreUtils.ActionMessage.UPDATE_TRAINING_DATASET_STATS_CONFIG);
        if (trainingDatasetDTO.getStatisticsConfig().getEnabled() != null) {
            trainingDataset.getStatisticsConfig().setDescriptive(trainingDatasetDTO.getStatisticsConfig().getEnabled().booleanValue());
        }
        if (trainingDatasetDTO.getStatisticsConfig().getHistograms() != null) {
            trainingDataset.getStatisticsConfig().setHistograms(trainingDatasetDTO.getStatisticsConfig().getHistograms().booleanValue());
        }
        if (trainingDatasetDTO.getStatisticsConfig().getCorrelations() != null) {
            trainingDataset.getStatisticsConfig().setCorrelations(trainingDatasetDTO.getStatisticsConfig().getCorrelations().booleanValue());
        }
        if (trainingDatasetDTO.getStatisticsConfig().getExactUniqueness() != null) {
            trainingDataset.getStatisticsConfig().setExactUniqueness(trainingDatasetDTO.getStatisticsConfig().getExactUniqueness().booleanValue());
        }
        this.statisticColumnController.verifyStatisticColumnsExist(trainingDatasetDTO, trainingDataset);
        trainingDataset = (TrainingDataset)this.trainingDatasetFacade.update(trainingDataset);
        this.statisticColumnController.persistStatisticColumns(trainingDataset, trainingDatasetDTO.getStatisticsConfig().getColumns());
        trainingDataset = this.getTrainingDatasetById(featurestore, trainingDatasetDTO.getId());
        this.activityFacade.persistActivity(" edited training dataset named " + trainingDatasetDTO.getName(), project, user, ActivityFlag.SERVICE);
        return this.convertTrainingDatasetToDTO(user, project, trainingDataset);
    }

    public String getTrainingDatasetFolderName(Project project) {
        return project.getName() + "_" + Settings.ServiceDataset.TRAININGDATASETS.getName();
    }

    public String getTrainingDatasetPath(String trainingDatasetsFolderPath, String trainingDatasetName, Integer version) {
        return trainingDatasetsFolderPath + "/" + trainingDatasetName + "_" + version;
    }

    public Query getQuery(TrainingDataset trainingDataset, boolean withLabel, Project project, Users user, Boolean isHiveEngine) throws FeaturestoreException {
        if (!trainingDataset.isQuery()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRAINING_DATASET_NO_QUERY, Level.FINE, "Inference vector is only available for datasets generated by queries");
        }
        List<TrainingDatasetJoin> joins = this.getJoinsSorted(trainingDataset);
        List<TrainingDatasetFeature> tdFeatures = this.getFeaturesSorted(trainingDataset, withLabel);
        return this.getQuery(joins, tdFeatures, trainingDataset.getFilters(), project, user, isHiveEngine, false, false);
    }

    public Query getQuery(List<TrainingDatasetJoin> joins, List<TrainingDatasetFeature> tdFeatures, Collection<TrainingDatasetFilter> trainingDatasetFilters, Project project, Users user, Boolean isHiveEngine, boolean withPrimaryKeys, boolean withEventTime) throws FeaturestoreException {
        return this.getQuery(joins, tdFeatures, trainingDatasetFilters, project, user, isHiveEngine, Lists.newArrayList(), withPrimaryKeys, withEventTime);
    }

    public Query getQuery(List<TrainingDatasetJoin> joins, List<TrainingDatasetFeature> tdFeatures, Collection<TrainingDatasetFilter> trainingDatasetFilters, Project project, Users user, Boolean isHiveEngine, Collection<TrainingDatasetFilter> extraFilters, boolean withPrimaryKeys, boolean withEventTime) throws FeaturestoreException {
        Map<Integer, String> fgAliasLookup = this.getAliasLookupTable(joins);
        if (tdFeatures.stream().anyMatch(j -> j.getFeatureGroup() == null)) {
            return new Query(tdFeatures.stream().filter(j -> j.getFeatureGroup() == null).map(TrainingDatasetFeature::getName).collect(Collectors.toList()));
        }
        HashMap<Integer, List<Feature>> availableFeaturesLookup = new HashMap<Integer, List<Feature>>();
        for (TrainingDatasetJoin join : joins) {
            if (availableFeaturesLookup.containsKey(join.getFeatureGroup().getId())) continue;
            List availableFeatures = this.featuregroupController.getFeatures(join.getFeatureGroup(), project, user).stream().map(f -> new Feature(f.getName(), (String)fgAliasLookup.get(join.getId()), f.getType(), f.getPrimary(), f.getDefaultValue(), join.getPrefix(), join.getFeatureGroup())).collect(Collectors.toList());
            availableFeaturesLookup.put(join.getFeatureGroup().getId(), availableFeatures);
        }
        Map<String, Feature> featureLookup = availableFeaturesLookup.values().stream().flatMap(Collection::stream).collect(Collectors.toMap(f -> this.makeFeatureLookupKey(f.getFeatureGroup().getId(), f.getName()), f -> f, (f1, f2) -> f1));
        List<Feature> features = new ArrayList<Feature>();
        for (TrainingDatasetFeature requestedFeature : tdFeatures) {
            Feature tdFeature = featureLookup.get(this.makeFeatureLookupKey(requestedFeature.getFeatureGroup().getId(), requestedFeature.getName()));
            if (tdFeature == null) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_DOES_NOT_EXIST, Level.FINE, "Feature: " + requestedFeature.getName() + " not found in feature group: " + requestedFeature.getFeatureGroup().getName());
            }
            Feature featureWithCorrectAlias = new Feature(tdFeature.getName(), fgAliasLookup.get(requestedFeature.getTrainingDatasetJoin().getId()), tdFeature.getType(), tdFeature.getDefaultValue(), tdFeature.getPrefix(), requestedFeature.getFeatureGroup(), requestedFeature.getIndex());
            features.add(featureWithCorrectAlias);
        }
        features = this.addPrimaryKeyEventTimeFeature(features, featureLookup, joins, fgAliasLookup, withEventTime, withPrimaryKeys);
        Map<Integer, String> fsLookup = this.getFsLookupTableJoins(joins);
        if (joins.size() == 0) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_NOT_FOUND, Level.FINE, "Failed to construct the query because the query contains no features. It is possible that some feature groups are deleted. Please create a new query.");
        }
        Query query = new Query(fsLookup.get(joins.get(0).getFeatureGroup().getFeaturestore().getId()), this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(joins.get(0).getFeatureGroup().getFeaturestore().getProject()), joins.get(0).getFeatureGroup(), fgAliasLookup.get(joins.get(0).getId()), features, (List)availableFeaturesLookup.get(joins.get(0).getFeatureGroup().getId()), isHiveEngine);
        ArrayList<Join> queryJoins = new ArrayList<Join>();
        for (int i = 1; i < joins.size(); ++i) {
            queryJoins.add(this.getQueryJoin(query, joins.get(i), fgAliasLookup, fsLookup, availableFeaturesLookup, isHiveEngine));
        }
        query.setJoins(queryJoins);
        FilterLogic filterLogic = this.convertToFilterLogic(trainingDatasetFilters, featureLookup, "L");
        query.setFilter(filterLogic);
        if (!extraFilters.isEmpty()) {
            FilterLogic extraFilterLogic = this.convertToFilterLogic(extraFilters, featureLookup, "L");
            this.queryController.appendFilter(query, SqlFilterLogic.AND, extraFilterLogic);
        }
        return query;
    }

    public FilterLogic convertToFilterLogic(Collection<TrainingDatasetFilter> trainingDatasetFilters, Map<String, Feature> features, String headPath) throws FeaturestoreException {
        if (trainingDatasetFilters == null || trainingDatasetFilters.size() == 0) {
            return null;
        }
        FilterLogic filterLogic = new FilterLogic();
        TrainingDatasetFilter headNode = trainingDatasetFilters.stream().filter(filter -> filter.getPath().equals(headPath)).findFirst().orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_GET_QUERY_FILTER, Level.WARNING));
        filterLogic.setType(headNode.getType());
        if (headNode.getType().equals((Object)SqlFilterLogic.SINGLE)) {
            Filter filter2 = this.convertToFilter(headNode.getCondition(), features);
            filterLogic.setLeftFilter(filter2);
        } else {
            List<TrainingDatasetFilter> leftChildren = trainingDatasetFilters.stream().filter(filter -> filter.getPath().startsWith(headPath + ".L")).collect(Collectors.toList());
            List<TrainingDatasetFilter> rightChildren = trainingDatasetFilters.stream().filter(filter -> filter.getPath().startsWith(headPath + ".R")).collect(Collectors.toList());
            if (!leftChildren.isEmpty()) {
                if (leftChildren.size() == 1) {
                    filterLogic.setLeftFilter(this.convertToFilter(((TrainingDatasetFilter)leftChildren.get(0)).getCondition(), features));
                } else {
                    filterLogic.setLeftLogic(this.convertToFilterLogic(leftChildren, features, headPath + ".L"));
                }
            }
            if (!rightChildren.isEmpty()) {
                if (rightChildren.size() == 1) {
                    filterLogic.setRightFilter(this.convertToFilter(((TrainingDatasetFilter)rightChildren.get(0)).getCondition(), features));
                } else {
                    filterLogic.setRightLogic(this.convertToFilterLogic(rightChildren, features, headPath + ".R"));
                }
            }
        }
        return filterLogic;
    }

    private Filter convertToFilter(TrainingDatasetFilterCondition condition, Map<String, Feature> features) {
        FilterValue filterValue;
        if (condition.getValueFeatureGroupId() == null) {
            filterValue = new FilterValue(condition.getValue());
        } else {
            Feature filterValueFeature = features.get(this.makeFeatureLookupKey(condition.getValueFeatureGroupId(), condition.getValue()));
            filterValue = new FilterValue(condition.getValueFeatureGroupId(), filterValueFeature.getFgAlias(), condition.getValue());
        }
        return new Filter(features.get(this.makeFeatureLookupKey(condition.getFeatureGroup().getId(), condition.getFeature())), condition.getCondition(), filterValue);
    }

    private String makeFeatureLookupKey(Integer featureGroupId, String featureName) {
        return featureGroupId + "." + featureName;
    }

    public Map<Integer, String> getAliasLookupTable(List<TrainingDatasetJoin> tdJoins) {
        int i = 0;
        HashMap<Integer, String> fgAlias = new HashMap<Integer, String>();
        for (TrainingDatasetJoin tdJoin : tdJoins) {
            fgAlias.put(tdJoin.getId(), "fg" + i++);
        }
        return fgAlias;
    }

    public Map<Integer, String> getFsLookupTableJoins(List<TrainingDatasetJoin> tdJoins) {
        HashMap<Integer, String> fsLookup = new HashMap<Integer, String>();
        for (TrainingDatasetJoin join : tdJoins) {
            if (fsLookup.containsKey(join.getFeatureGroup().getFeaturestore().getId())) continue;
            fsLookup.put(join.getFeatureGroup().getFeaturestore().getId(), this.featurestoreController.getOfflineFeaturestoreDbName(join.getFeatureGroup().getFeaturestore()));
        }
        return fsLookup;
    }

    public Map<Integer, String> getFsLookupTableFeatures(List<TrainingDatasetFeature> tdFeatures) {
        HashMap<Integer, String> fsLookup = new HashMap<Integer, String>();
        for (TrainingDatasetFeature tdFeature : tdFeatures) {
            if (tdFeature.getFeatureGroup() == null || fsLookup.containsKey(tdFeature.getFeatureGroup().getFeaturestore().getId())) continue;
            fsLookup.put(tdFeature.getFeatureGroup().getFeaturestore().getId(), this.featurestoreController.getOfflineFeaturestoreDbName(tdFeature.getFeatureGroup().getFeaturestore()));
        }
        return fsLookup;
    }

    public List<TrainingDatasetFeature> getFeaturesSorted(TrainingDataset trainingDataset, boolean withLabel) {
        return trainingDataset.getFeatures().stream().sorted((t1, t2) -> {
            if (t1.getIndex() != null) {
                return t1.getIndex().compareTo(t2.getIndex());
            }
            return t1.getName().compareTo(t2.getName());
        }).filter(f -> !f.isLabel() || withLabel).collect(Collectors.toList());
    }

    public List<TrainingDatasetJoin> getJoinsSorted(TrainingDataset trainingDataset) {
        return this.getJoinsSorted(trainingDataset.getJoins());
    }

    public List<TrainingDatasetJoin> getJoinsSorted(Collection<TrainingDatasetJoin> joins) {
        return joins.stream().sorted(Comparator.comparing(TrainingDatasetJoin::getIndex)).collect(Collectors.toList());
    }

    public Join getQueryJoin(Query leftQuery, TrainingDatasetJoin rightTdJoin, Map<Integer, String> fgAliasLookup, Map<Integer, String> fsLookup, Map<Integer, List<Feature>> availableFeaturesLookup, Boolean isHiveEngine) throws FeaturestoreException {
        String rightAs = fgAliasLookup.get(rightTdJoin.getId());
        Query rightQuery = new Query(fsLookup.get(rightTdJoin.getFeatureGroup().getFeaturestore().getId()), this.onlineFeaturestoreController.getOnlineFeaturestoreDbName(rightTdJoin.getFeatureGroup().getFeaturestore().getProject()), rightTdJoin.getFeatureGroup(), rightAs, new ArrayList<Feature>(), availableFeaturesLookup.get(rightTdJoin.getFeatureGroup().getId()), isHiveEngine);
        List<Feature> leftOn = rightTdJoin.getConditions().stream().map(c -> new Feature(c.getLeftFeature())).collect(Collectors.toList());
        List<Feature> rightOn = rightTdJoin.getConditions().stream().map(c -> new Feature(c.getRightFeature())).collect(Collectors.toList());
        JoinType joinType = JoinType.values()[rightTdJoin.getType()];
        return this.queryController.extractLeftRightOn(leftQuery, rightQuery, leftOn, rightOn, joinType, rightTdJoin.getPrefix());
    }

    private TransformationFunction getTransformationFunction(Feature feature, List<TrainingDatasetFeatureDTO> featureDTOs, String prefix) throws FeaturestoreException {
        TrainingDatasetFeatureDTO featureDTO;
        if (Strings.isNullOrEmpty((String)prefix)) {
            prefix = "";
        }
        String finalPrefix = prefix;
        List trainingDatasetFeatureDTOS = featureDTOs.stream().filter(dto -> feature.getName().equals(dto.getFeatureGroupFeatureName()) && (dto.getFeaturegroup() == null || feature.getFeatureGroup().getId().equals(dto.getFeaturegroup().getId())) && dto.getName().equals(finalPrefix + feature.getName())).collect(Collectors.toList());
        TransformationFunction transformationFunction = null;
        if (trainingDatasetFeatureDTOS.size() > 1) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.AMBIGUOUS_FEATURE_ERROR, Level.FINE, String.format("Failed to attach transformation function because provided feature %s exists in multiple feature groups.", feature.getName()));
        }
        if (trainingDatasetFeatureDTOS.size() == 1 && (featureDTO = (TrainingDatasetFeatureDTO)trainingDatasetFeatureDTOS.get(0)).getTransformationFunction() != null) {
            transformationFunction = this.getTransformationFunctionById(featureDTO.getTransformationFunction().getId());
        }
        return transformationFunction;
    }

    TransformationFunction getTransformationFunctionById(Integer id) throws FeaturestoreException {
        return this.transformationFunctionFacade.findById(id).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.TRANSFORMATION_FUNCTION_DOES_NOT_EXIST, Level.FINE, "Could not find transformation function with ID" + id));
    }

    public String checkPrefix(TrainingDatasetFeature feature) {
        if (feature.getTrainingDatasetJoin() != null && feature.getTrainingDatasetJoin().getPrefix() != null) {
            return feature.getTrainingDatasetJoin().getPrefix() + feature.getName();
        }
        return feature.getName();
    }

    private void addSelectedFeature(List<String> featureNames, Featuregroup featureGroup, Map<String, Feature> featureLookup, List<Feature> features, TrainingDatasetJoin join, Map<Integer, String> fgAliasLookup) {
        for (String featureName : featureNames) {
            Feature feature = featureLookup.get(this.makeFeatureLookupKey(featureGroup.getId(), featureName));
            Feature newFeature = new Feature(feature.getName(), fgAliasLookup.get(join.getId()), feature.getType(), feature.getDefaultValue(), join.getPrefix(), join.getFeatureGroup(), null);
            if (!features.stream().noneMatch(f -> f.getName().equals(featureName) && f.getFeatureGroup().getId().equals(featureGroup.getId()))) continue;
            features.add(newFeature);
        }
    }

    private List<Feature> addPrimaryKeyEventTimeFeature(List<Feature> features, Map<String, Feature> featureLookup, List<TrainingDatasetJoin> joins, Map<Integer, String> fgAliasLookup, boolean withEventTime, boolean withPrimaryKeys) {
        if (withPrimaryKeys || withEventTime) {
            for (TrainingDatasetJoin join : joins) {
                ArrayList<String> featureNames = new ArrayList<String>();
                if (withEventTime && join.getFeatureGroup().getEventTime() != null) {
                    featureNames.add(join.getFeatureGroup().getEventTime());
                }
                if (withPrimaryKeys) {
                    if (join.getFeatureGroup().getStreamFeatureGroup() != null) {
                        featureNames.addAll(join.getFeatureGroup().getStreamFeatureGroup().getFeaturesExtraConstraints().stream().filter(CachedFeatureExtraConstraints::getPrimary).map(CachedFeatureExtraConstraints::getName).collect(Collectors.toList()));
                    }
                    if (join.getFeatureGroup().getCachedFeaturegroup() != null) {
                        featureNames.addAll(join.getFeatureGroup().getCachedFeaturegroup().getFeaturesExtraConstraints().stream().filter(CachedFeatureExtraConstraints::getPrimary).map(CachedFeatureExtraConstraints::getName).collect(Collectors.toList()));
                    }
                    if (join.getFeatureGroup().getOnDemandFeaturegroup() != null) {
                        featureNames.addAll(join.getFeatureGroup().getOnDemandFeaturegroup().getFeatures().stream().filter(OnDemandFeature::getPrimary).map(OnDemandFeature::getName).collect(Collectors.toList()));
                    }
                }
                this.addSelectedFeature(featureNames, join.getFeatureGroup(), featureLookup, features, join, fgAliasLookup);
            }
        }
        return features;
    }
}

