/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.git;

import io.hops.hopsworks.common.git.BasicAuthSecrets;
import io.hops.hopsworks.common.git.CommandExecutor;
import io.hops.hopsworks.exceptions.GitOpException;
import io.hops.hopsworks.exceptions.HopsSecurityException;
import io.hops.hopsworks.persistence.entity.git.GitOpExecution;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import javax.ejb.Asynchronous;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;

@Stateless
@LocalBean
public class AsynchronousGitCommandExecutor {
    @Inject
    private CommandExecutor commandExecutor;

    @Asynchronous
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void execute(GitOpExecution gitOpExecution, BasicAuthSecrets authSecrets) throws GitOpException, HopsSecurityException {
        try {
            this.commandExecutor.execute(gitOpExecution, authSecrets);
        }
        catch (Exception ex) {
            throw new GitOpException((RESTCodes.RESTErrorCode)RESTCodes.GitOpErrorCode.GIT_OPERATION_ERROR, Level.SEVERE, ex.getMessage());
        }
    }

    @Asynchronous
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void cancelGitExecution(GitOpExecution execution, String message) {
        this.commandExecutor.cancelGitExecution(execution, message);
    }
}

