/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.git;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.dao.git.GitOpExecutionFacade;
import io.hops.hopsworks.common.dao.git.GitPaths;
import io.hops.hopsworks.common.dao.git.GitRepositoryFacade;
import io.hops.hopsworks.common.git.BasicAuthSecrets;
import io.hops.hopsworks.common.git.CommandExecutor;
import io.hops.hopsworks.common.git.GitJWTManager;
import io.hops.hopsworks.common.git.util.GitCommandOperationUtil;
import io.hops.hopsworks.common.git.util.GitContainerArgumentsWriter;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.integrations.LocalhostStereotype;
import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.GitOpException;
import io.hops.hopsworks.persistence.entity.git.GitOpExecution;
import io.hops.hopsworks.persistence.entity.git.GitRepository;
import io.hops.hopsworks.persistence.entity.git.config.GitOpExecutionState;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@LocalhostStereotype
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class LocalCommandExecutor
implements CommandExecutor {
    private static final Logger LOGGER = Logger.getLogger(LocalCommandExecutor.class.getName());
    @EJB
    private Settings settings;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private GitOpExecutionFacade gitOpExecutionFacade;
    @EJB
    private GitCommandOperationUtil gitCommandOperationUtil;
    @EJB
    private GitRepositoryFacade gitRepositoryFacade;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private GitContainerArgumentsWriter argumentsWriter;
    @EJB
    private CertificateMaterializer certificateMaterializer;
    @EJB
    private GitJWTManager gitJWTManager;
    @EJB
    private DistributedFsService dfsService;

    @Override
    public void execute(GitOpExecution gitOpExecution, BasicAuthSecrets authSecrets) throws GitOpException, IOException, ServiceDiscoveryException {
        int maxTries = 5;
        String pid = "";
        String gitCommand = gitOpExecution.getGitCommandConfiguration().getCommandType().getGitCommand();
        String prog = this.settings.getSudoersDir() + "/git.sh";
        GitPaths gitPaths = this.prepareCommandExecution(gitOpExecution);
        this.argumentsWriter.createArgumentFile(gitOpExecution, gitPaths, authSecrets);
        String commandArgumentsFile = gitPaths.getConfDirPath() + File.separator + "git_container_launch_script_arguments";
        while (maxTries > 0 && Strings.isNullOrEmpty((String)pid)) {
            try {
                ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("start").addCommand(commandArgumentsFile).redirectErrorStream(true).setCurrentWorkingDirectory(new File(gitPaths.getGitPath())).setWaitTimeout(60L, TimeUnit.SECONDS).build();
                String pidFile = gitPaths.getRunDirPath() + "/git.pid";
                ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
                if (processResult.getExitCode() != 0) {
                    String errorMsg = "Could not start git service to execute command " + gitCommand + " . Exit code: " + processResult.getExitCode() + " Error: stdout: " + processResult.getStdout() + " stderr: " + processResult.getStderr();
                    LOGGER.log(Level.SEVERE, errorMsg);
                    throw new IOException(errorMsg);
                }
                pid = Files.readFirstLine((File)new File(pidFile), (Charset)Charset.defaultCharset());
                Optional<GitRepository> optional = this.gitRepositoryFacade.findById(gitOpExecution.getRepository().getId());
                this.gitRepositoryFacade.updateRepositoryCid(optional.get(), pid);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Problem executing shell script to start git command service", ex);
                --maxTries;
            }
        }
        if (Strings.isNullOrEmpty((String)pid)) {
            this.updateExecutionStateToFail(gitOpExecution);
        }
    }

    @Override
    public void cancelGitExecution(GitOpExecution execution, String message) {
        if (execution.getState().isFinalState()) {
            return;
        }
        try {
            this.gitOpExecutionFacade.updateState(execution, GitOpExecutionState.CANCELLED, message);
            GitRepository repository = execution.getRepository();
            for (int maxTries = 10; maxTries > 0 && Strings.isNullOrEmpty((String)repository.getCid()); --maxTries) {
                Optional<GitRepository> optional = this.gitRepositoryFacade.findById(repository.getId());
                if (optional.isPresent()) {
                    repository = optional.get();
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.INFO, "Interrupted while waiting for the git container to start");
                }
            }
            this.shutdownCommandService(repository, execution);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Error when cancelling git execution with ID: " + execution.getId(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GitPaths prepareCommandExecution(GitOpExecution gitOpExecution) throws GitOpException, IOException {
        GitPaths gitPaths = new GitPaths(this.settings.getStagingDir() + "/private_dirs/", gitOpExecution.getConfigSecret());
        this.gitCommandOperationUtil.generatePaths(gitPaths);
        DistributedFileSystemOps udfso = null;
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(gitOpExecution.getRepository().getProject(), gitOpExecution.getUser());
        try {
            udfso = this.dfsService.getDfsOps(hdfsUsername);
            HopsUtils.materializeCertificatesForUserCustomDir(gitOpExecution.getRepository().getProject().getName(), gitOpExecution.getUser().getUsername(), this.settings.getHdfsTmpCertDir(), udfso, this.certificateMaterializer, this.settings, gitPaths.getCertificatesDirPath());
            this.gitJWTManager.materializeJWT(gitOpExecution.getUser(), gitPaths.getTokenPath());
        }
        finally {
            if (udfso != null) {
                this.dfsService.closeDfsClient(udfso);
            }
        }
        return gitPaths;
    }

    private void shutdownCommandService(GitRepository repository, GitOpExecution execution) {
        String cid = repository.getCid();
        try {
            this.gitRepositoryFacade.updateRepositoryCid(repository, null);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to update repository pid", e);
        }
        this.killGitContainer(execution, cid);
        this.gitCommandOperationUtil.cleanUp(repository.getProject(), execution.getUser(), execution.getConfigSecret());
    }

    @Override
    public void monitorCommands(GitOpExecution execution, String localMemberIp, boolean amIPrimary, long waitTime) {
        long timeElapsed;
        if (execution.getHostname().equals(localMemberIp) && (timeElapsed = System.currentTimeMillis() - execution.getExecutionStart()) > this.settings.getGitJwtExpMs() + waitTime) {
            LOGGER.log(Level.INFO, "Killing git execution with Id + [{0}] with state {1}", new Object[]{execution.getId(), execution.getState().toString()});
            this.gitOpExecutionFacade.updateState(execution, GitOpExecutionState.TIMEDOUT, "Timeout");
            this.shutdownCommandService(execution.getRepository(), execution);
        }
    }

    private void killGitContainer(GitOpExecution execution, String containerId) {
        if (Strings.isNullOrEmpty((String)containerId)) {
            return;
        }
        String gitHomePath = this.gitCommandOperationUtil.getGitHome(execution.getConfigSecret());
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(execution.getRepository().getProject(), execution.getUser());
        String prog = this.settings.getSudoersDir() + "/git.sh";
        int exitValue = 0;
        ProcessDescriptor.Builder pdBuilder = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("kill").addCommand(gitHomePath).addCommand(containerId).addCommand(hdfsUsername).redirectErrorStream(true).setWaitTimeout(10L, TimeUnit.SECONDS);
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(pdBuilder.build());
            LOGGER.log(Level.FINE, processResult.getStdout());
            exitValue = processResult.getExitCode();
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Failed to shutdown git container executing command for user " + hdfsUsername, ex);
        }
        if (exitValue != 0) {
            LOGGER.log(Level.SEVERE, "Exited with " + exitValue + "Failed to shutdown git container executing command for user " + hdfsUsername);
        }
    }

    private void updateExecutionStateToFail(GitOpExecution gitOpExecution) {
        Optional<GitOpExecution> optional = this.gitOpExecutionFacade.findByIdAndRepository(gitOpExecution.getRepository(), gitOpExecution.getId());
        if ((gitOpExecution = optional.get()).getState() == GitOpExecutionState.CANCELLED) {
            return;
        }
        this.gitCommandOperationUtil.cleanUp(gitOpExecution.getRepository().getProject(), gitOpExecution.getUser(), gitOpExecution.getConfigSecret());
        this.gitOpExecutionFacade.updateState(gitOpExecution, GitOpExecutionState.FAILED, "Could not launch container to execute git command.");
        this.gitRepositoryFacade.updateRepositoryCid(gitOpExecution.getRepository(), null);
        LOGGER.log(Level.SEVERE, "Problem executing shell script to start git command service.");
    }
}

