/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.hdfs;

import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.metadata.hdfs.entity.MetaStatus;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.security.UserGroupInformation;

public class DistributedFileSystemOps {
    private static final Logger logger = Logger.getLogger(DistributedFileSystemOps.class.getName());
    public static final String HOPSFS_SCHEME = "hopsfs";
    private final DistributedFileSystem dfs;
    private Configuration conf;
    private final String effectiveUser;

    public DistributedFileSystemOps(UserGroupInformation ugi, Configuration conf, URI uri) {
        this.dfs = this.getDfs(ugi, conf, uri);
        this.conf = conf;
        this.effectiveUser = ugi.getUserName();
    }

    public DistributedFileSystemOps(UserGroupInformation ugi, Configuration conf) {
        this(ugi, conf, null);
    }

    private DistributedFileSystem getDfs(UserGroupInformation ugi, final Configuration conf, final URI uri) {
        FileSystem fs = null;
        try {
            fs = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws IOException {
                    if (null != uri) {
                        return FileSystem.get((URI)uri, (Configuration)conf);
                    }
                    return FileSystem.get((URI)FileSystem.getDefaultUri((Configuration)conf), (Configuration)conf);
                }
            });
        }
        catch (IOException | InterruptedException ex) {
            logger.log(Level.SEVERE, "Unable to initialize FileSystem", ex);
        }
        return (DistributedFileSystem)fs;
    }

    public DistributedFileSystem getFilesystem() {
        return this.dfs;
    }

    public String getEffectiveUser() {
        return this.effectiveUser;
    }

    public String cat(Path file) throws IOException {
        ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream();
        byte[] buffer = new byte[65536];
        try (FSDataInputStream dataStream = this.dfs.open(file);){
            int length;
            while ((length = dataStream.read(buffer)) != -1) {
                outputBuffer.write(buffer, 0, length);
            }
        }
        return outputBuffer.toString("UTF-8");
    }

    public String cat(String file) throws IOException {
        Path path = new Path(file);
        return this.cat(path);
    }

    public void copyToLocal(String src, String dest) throws IOException {
        this.dfs.copyToLocalFile(new Path(src), new Path(dest));
    }

    public boolean mkdir(Path path) throws IOException {
        return this.dfs.mkdir(path, FsPermission.getDefault());
    }

    public boolean mkdir(Path location, FsPermission filePermission) throws IOException {
        return this.dfs.mkdir(location, filePermission);
    }

    public boolean mkdir(String path) throws IOException {
        Path location = new Path(path);
        return this.dfs.mkdir(location, FsPermission.getDefault());
    }

    public boolean mkdirs(String location, FsPermission filePermission) throws IOException {
        return this.mkdirs(new Path(location), filePermission);
    }

    public boolean mkdirs(Path location, FsPermission filePermission) throws IOException {
        return this.dfs.mkdirs(location, filePermission);
    }

    public void touchz(String location) throws IOException {
        this.touchz(new Path(location));
    }

    public void touchz(Path location) throws IOException {
        this.dfs.create(location).close();
    }

    public FileStatus[] listStatus(Path location) throws IOException {
        return this.dfs.listStatus(location);
    }

    public FileStatus getFileStatus(Path location) throws IOException {
        return this.dfs.getFileStatus(location);
    }

    public boolean rm(Path location, boolean recursive) throws IOException {
        logger.log(Level.INFO, "Deleting {0} as {1}", new Object[]{location.toString(), this.dfs.toString()});
        if (this.dfs.exists(location)) {
            return this.dfs.delete(location, recursive);
        }
        return true;
    }

    public boolean rm(String location, boolean recursive) throws IOException {
        return this.rm(new Path(location), recursive);
    }

    public void copyFromLocal(boolean deleteSource, Path source, Path destination) throws IOException {
        this.dfs.copyFromLocalFile(deleteSource, source, destination);
    }

    public void copyToHDFSFromLocal(boolean deleteSource, String src, String destination) throws IOException {
        Path dirs = new Path(Utils.getDirectoryPart(destination));
        this.mkdirs(dirs, this.getParentPermission(dirs));
        Path destp = new Path(destination);
        Path srcp = new Path(src);
        this.copyFromLocal(deleteSource, srcp, destp);
    }

    public void moveWithinHdfs(Path source, Path destination) throws IOException {
        this.dfs.rename(source, destination);
    }

    public void moveWithinHdfs(Path source, Path destination, boolean overwrite) throws IOException {
        Options.Rename renameOption = overwrite ? Options.Rename.OVERWRITE : Options.Rename.NONE;
        this.dfs.rename(source, destination, new Options.Rename[]{renameOption});
    }

    public boolean exists(String path) throws IOException {
        Path location = new Path(path);
        return this.dfs.exists(location);
    }

    public boolean exists(Path path) throws IOException {
        return this.dfs.exists(path);
    }

    public void copyInHdfs(Path src, Path dst) throws IOException {
        Path[] srcs = FileUtil.stat2Paths((FileStatus[])this.dfs.globStatus(src), (Path)src);
        if (srcs.length > 1 && !this.dfs.isDirectory(dst)) {
            throw new IOException("When copying multiple files, destination should be a directory.");
        }
        for (Path src1 : srcs) {
            FileUtil.copy((FileSystem)this.dfs, (Path)src1, (FileSystem)this.dfs, (Path)dst, (boolean)false, (Configuration)this.conf);
        }
    }

    public FSDataOutputStream create(String path) throws IOException {
        Path dstPath = new Path(path);
        String dirs = Utils.getDirectoryPart(path);
        Path dirsPath = new Path(dirs);
        if (!this.exists(dirs)) {
            this.dfs.mkdirs(dirsPath);
        }
        return this.dfs.create(dstPath);
    }

    public FSDataOutputStream create(Path path) throws IOException {
        return this.create(path.toString());
    }

    public FSDataOutputStream append(String path) throws IOException {
        return this.append(new Path(path));
    }

    public FSDataOutputStream append(Path path) throws IOException {
        if (!this.exists(path)) {
            return this.create(path);
        }
        return this.dfs.append(path);
    }

    public void create(Path path, String content) throws IOException {
        try (FSDataOutputStream outputStream = this.dfs.create(path);){
            outputStream.writeBytes(content);
            outputStream.flush();
        }
    }

    public void create(Path path, byte[] content) throws IOException {
        try (FSDataOutputStream outputStream = this.dfs.create(path);){
            outputStream.write(content, 0, content.length);
            outputStream.flush();
        }
    }

    public void setPermission(Path path, FsPermission permission) throws IOException {
        this.dfs.setPermission(path, permission);
    }

    public void setPermission(Path path, List<AclEntry> aclEntries) throws IOException {
        this.dfs.setAcl(path, aclEntries);
    }

    public void updateAcls(Path path, List<AclEntry> aclEntries) throws IOException {
        this.dfs.modifyAclEntries(path, aclEntries);
    }

    public void setPermission(Set<Path> paths, FsPermission permission) throws IOException {
        for (Path path : paths) {
            this.setPermission(path, permission);
        }
    }

    public void setOwner(Path path, String username, String groupname) throws IOException {
        this.dfs.setOwner(path, username, groupname);
    }

    public void setHdfsSpaceQuota(Path src, long diskspaceQuota) throws IOException {
        this.setHdfsQuotaBytes(src, -1L, diskspaceQuota);
    }

    public void setHdfsQuotaBytes(Path src, long numberOfFiles, long diskspaceQuotaInBytes) throws IOException {
        this.dfs.setQuota(src, numberOfFiles, diskspaceQuotaInBytes);
    }

    public FSDataInputStream open(Path location) throws IOException {
        return this.dfs.open(location);
    }

    public FSDataInputStream open(String location) throws IOException {
        Path path = new Path(location);
        return this.dfs.open(path);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public FsPermission getParentPermission(Path path) throws IOException {
        Path location = new Path(path.toUri());
        if (this.dfs.exists(location)) {
            location = location.getParent();
            return this.dfs.getFileStatus(location).getPermission();
        }
        while (!this.dfs.exists(location)) {
            location = location.getParent();
        }
        return this.dfs.getFileStatus(location).getPermission();
    }

    public boolean isDir(String path) {
        Path location = new Path(path);
        try {
            return this.dfs.isDirectory(location);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public void setMetaStatus(Path path, Inode.MetaStatus status) throws IOException {
        switch (status) {
            case DISABLED: {
                this.dfs.setMetaStatus(path, MetaStatus.DISABLED);
                break;
            }
            case META_ENABLED: {
                this.dfs.setMetaStatus(path, MetaStatus.META_ENABLED);
                break;
            }
            case MIN_PROV_ENABLED: {
                this.dfs.setMetaStatus(path, MetaStatus.MIN_PROV_ENABLED);
                break;
            }
            case FULL_PROV_ENABLED: {
                this.dfs.setMetaStatus(path, MetaStatus.FULL_PROV_ENABLED);
            }
        }
    }

    public void setMetaStatus(String location, Inode.MetaStatus status) throws IOException {
        Path path = new Path(location);
        this.setMetaStatus(path, status);
    }

    public void close() {
        try {
            this.dfs.close();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Error while closing file system.", ex);
        }
    }

    public void addUser(String userName) throws IOException {
        this.dfs.addUser(userName);
    }

    public void removeUser(String userName) throws IOException {
        this.dfs.removeUser(userName);
    }

    public void addGroup(String groupName) throws IOException {
        this.dfs.addGroup(groupName);
    }

    public void removeGroup(String groupName) throws IOException {
        this.dfs.removeGroup(groupName);
    }

    public void addUserToGroup(String userName, String groupName) throws IOException {
        this.dfs.addUserToGroup(userName, groupName);
    }

    public void removeUserFromGroup(String userName, String groupName) throws IOException {
        this.dfs.removeUserFromGroup(userName, groupName);
    }

    public void setStoragePolicy(Path path, StoragePolicy storagePolicy) throws IOException {
        this.dfs.setStoragePolicy(path, storagePolicy.toString());
    }

    public void setXAttr(Path path, String name, byte[] value) throws IOException {
        this.dfs.setXAttr(path, name, value);
    }

    public void removeXAttr(Path path, String name) throws IOException {
        this.dfs.removeXAttr(path, name);
    }

    public byte[] getXAttr(Path path, String name) throws IOException {
        return this.dfs.getXAttr(path, name);
    }

    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        return this.dfs.getXAttrs(path);
    }

    public static enum StoragePolicy {
        CLOUD("CLOUD"),
        SMALL_FILES("DB"),
        DEFAULT("HOT");

        private String policyName;

        private StoragePolicy(String policyName) {
            this.policyName = policyName;
        }

        public String toString() {
            return this.policyName;
        }

        public static StoragePolicy fromPolicy(String policyName) {
            switch (policyName) {
                case "CLOUD": {
                    return CLOUD;
                }
                case "DB": {
                    return SMALL_FILES;
                }
                case "HOT": {
                    return DEFAULT;
                }
            }
            throw new IllegalArgumentException("unknown policy:" + policyName);
        }
    }
}

