/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.hdfs.inode;

import io.hops.common.Pair;
import io.hops.hopsworks.common.dao.hdfs.inode.InodeFacade;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetType;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.lang3.ArrayUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class InodeController {
    private static final Logger LOGGER = Logger.getLogger(InodeController.class.getName());
    @EJB
    private InodeFacade inodeFacade;

    public void getAllChildren(Inode parent, List<Inode> children) {
        List<Inode> curr = this.inodeFacade.findByParent(parent);
        children.addAll(curr);
        for (Inode inode : curr) {
            if (!inode.isDir()) continue;
            this.getAllChildren(inode, children);
        }
    }

    public boolean existsPath(String path) {
        return this.getInode(path) != null;
    }

    public Inode getInodeAtPath(String path) {
        return this.getInode(path);
    }

    public Inode getInodeAtPath(Inode inode, int depth, String path) {
        return this.getInode(inode, depth, path.split("/"));
    }

    public Inode getProjectRoot(String name) {
        return this.getInode(Utils.getProjectPath(name));
    }

    public Inode getProjectDatasetInode(Inode projectInode, String datasetPath, Dataset dataset) {
        if (dataset.getDsType().equals((Object)DatasetType.FEATURESTORE) || dataset.getDsType().equals((Object)DatasetType.HIVEDB)) {
            return this.getInodeAtPath(datasetPath);
        }
        return this.getInode(projectInode, 3, new String[]{dataset.getName()});
    }

    public Inode getProjectRootForInode(Inode i) throws IllegalStateException {
        if (this.isProjectRoot(i)) {
            return i;
        }
        Inode parent = this.inodeFacade.findParent(i);
        if (parent == null) {
            throw new IllegalStateException("Transversing the path from folder did not encounter project root folder.");
        }
        return this.getProjectRootForInode(parent);
    }

    public boolean isProjectRoot(Inode i) {
        Inode parent = this.inodeFacade.findParent(i);
        if (!parent.getInodePK().getName().equals("Projects")) {
            return false;
        }
        return parent.getInodePK().getParentId() == 1L;
    }

    public String getProjectNameForInode(Inode i) throws IllegalStateException {
        Inode projectRoot = this.getProjectRootForInode(i);
        return projectRoot.getInodePK().getName();
    }

    public String getPath(Inode i) {
        if (i == null) {
            throw new IllegalArgumentException("Inode was not provided.");
        }
        ArrayList<String> pathComponents = new ArrayList<String>();
        Inode parent = i;
        while (parent.getId() != 1L) {
            pathComponents.add(parent.getInodePK().getName());
            parent = this.inodeFacade.findParent(parent);
        }
        StringBuilder path = new StringBuilder();
        for (int j = pathComponents.size() - 1; j >= 0; --j) {
            path.append("/").append((String)pathComponents.get(j));
        }
        return path.toString();
    }

    public List<Inode> getChildren(String path) throws FileNotFoundException {
        Inode parent = this.getInode(path);
        if (parent == null) {
            throw new FileNotFoundException("Path not found : " + path);
        }
        if (!parent.isDir()) {
            throw new FileNotFoundException("Path is not a directory.");
        }
        return this.getChildren(parent);
    }

    public List<Inode> getChildren(Inode parent) {
        return this.inodeFacade.findByParent(parent);
    }

    public Pair<Inode, Inode> getProjectAndDatasetRootForInode(Inode i) throws IllegalStateException {
        Inode project = i;
        Inode dataset = i;
        do {
            dataset = project;
            if ((project = this.inodeFacade.findParent(project)) != null) continue;
            throw new IllegalStateException("Transversing the path from folder did not encounter project root folder.");
        } while (!this.isProjectRoot(project));
        return new Pair((Object)project, (Object)dataset);
    }

    public long getSize(Inode inode) {
        if (!inode.isDir()) {
            return inode.getSize();
        }
        long size = 0L;
        List<Inode> children = this.getChildren(inode);
        for (Inode i : children) {
            if (!i.isDir()) {
                size += i.getSize();
                continue;
            }
            size += this.getSize(i);
        }
        return size;
    }

    private Inode getInode(String path) {
        Object[] p;
        if (path.charAt(0) == '/') {
            p = path.substring(1).split("/");
        } else if (path.startsWith("hopsfs")) {
            p = path.split("/");
            p = (String[])ArrayUtils.subarray((Object[])p, (int)3, (int)p.length);
        } else {
            p = path.split("/");
        }
        if (p.length < 1) {
            return null;
        }
        return this.getInode(this.inodeFacade.getRootNode((String)p[0]), 1, (String[])Arrays.copyOfRange(p, 1, p.length));
    }

    private Inode getInode(Inode inode, int depth, String[] p) {
        Inode curr = inode;
        if (curr == null) {
            return null;
        }
        for (int i = 0; i < p.length; ++i) {
            long partitionId = HopsUtils.calculatePartitionId(curr.getId(), p[i], i + depth + 1);
            Inode next = this.inodeFacade.findByInodePK(curr, p[i], partitionId);
            if (next == null) {
                return null;
            }
            curr = next;
        }
        return curr;
    }
}

