/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.hive;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.service.Service;
import io.hops.hopsworks.common.dao.dataset.DatasetFacade;
import io.hops.hopsworks.common.dao.user.activity.ActivityFacade;
import io.hops.hopsworks.common.dataset.DatasetController;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.provenance.core.HopsFSProvenanceController;
import io.hops.hopsworks.common.provenance.core.dto.ProvTypeDTO;
import io.hops.hopsworks.common.security.BaseHadoopClientsService;
import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.CryptoPasswordNotFoundException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetAccessPermission;
import io.hops.hopsworks.persistence.entity.dataset.DatasetType;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.log.operation.OperationType;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.activity.ActivityFlag;
import io.hops.hopsworks.restutils.RESTCodes;
import io.hops.hopsworks.servicediscovery.HopsworksService;
import io.hops.hopsworks.servicediscovery.tags.HiveTags;
import io.hops.hopsworks.servicediscovery.tags.ServiceTags;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

@Stateless(name="HiveController")
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class HiveController {
    public static final String HIVE_JDBC_PREFIX = "jdbc:hopshive://";
    public static final String HIVE_DRIVER = "io.hops.hive.jdbc.HiveDriver";
    public static final int CONNECTION_TIMEOUT = 600000;
    @EJB
    private Settings settings;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private InodeController inodeController;
    @EJB
    private DatasetFacade datasetFacade;
    @EJB
    private BaseHadoopClientsService bhcs;
    @EJB
    private DatasetController datasetController;
    @EJB
    private ActivityFacade activityFacade;
    @EJB
    private HopsFSProvenanceController fsProvenanceCtrl;
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;
    @EJB
    private CertificateMaterializer certificateMaterializer;
    private static final Logger logger = Logger.getLogger(HiveController.class.getName());

    public void createDatasetDb(Project project, Users user, DistributedFileSystemOps dfso, String dbName, ProvTypeDTO metaStatus) throws IOException {
        this.createDatasetDb(project, user, dfso, dbName, DatasetType.HIVEDB, null, metaStatus);
    }

    public void createDatasetDb(Project project, Users user, DistributedFileSystemOps dfso, String dbName, DatasetType datasetType, Featurestore featurestore, ProvTypeDTO metaStatus) throws IOException {
        if (datasetType != DatasetType.HIVEDB && datasetType != DatasetType.FEATURESTORE) {
            throw new IllegalArgumentException("Invalid dataset type for hive database");
        }
        Dataset dbDataset = new Dataset(project, this.getDbDirName(dbName), DatasetAccessPermission.EDITABLE_BY_OWNERS);
        dbDataset.setDsType(datasetType);
        dbDataset.setSearchable(true);
        dbDataset.setFeatureStore(featurestore);
        this.datasetFacade.persistDataset(dbDataset);
        Path dbPath = this.getDbPath(dbName);
        try {
            this.hdfsUsersController.createDatasetGroupsAndSetPermissions(user, project, dbDataset, dbPath, dfso);
            this.fsProvenanceCtrl.updateHiveDatasetProvCore(project, dbPath.toString(), metaStatus, dfso);
            Inode dbInode = this.inodeController.getInodeAtPath(dbPath.toString());
            this.datasetController.logDataset(project, dbDataset, dbInode, OperationType.Add);
            this.activityFacade.persistActivity(" added a new dataset named " + dbDataset.getName(), project, user, ActivityFlag.DATASET);
            switch (datasetType) {
                case HIVEDB: {
                    dfso.setHdfsSpaceQuota(dbPath, this.settings.getHiveDbDefaultQuota());
                    break;
                }
                case FEATURESTORE: {
                    dfso.setHdfsSpaceQuota(dbPath, this.settings.getFeaturestoreDbDefaultQuota());
                }
            }
        }
        catch (ProvenanceException | IOException e) {
            logger.log(Level.SEVERE, "Cannot assign Hive database directory " + dbPath + " to correct user/group. Trace: " + e);
            try {
                dfso.rm(dbPath, true);
            }
            catch (IOException rmEx) {
                logger.log(Level.SEVERE, "Cannot delete Hive database directory: " + dbPath + " Trace: " + rmEx);
            }
            throw new IOException(e);
        }
    }

    public void dropDatabases(Project project, DistributedFileSystemOps dfso, boolean forceCleanup) throws IOException, ServiceException {
        Dataset projectDs = this.datasetController.getByProjectAndDsName(project, this.settings.getHiveWarehouse(), project.getName().toLowerCase() + ".db");
        Dataset featurestoreDs = this.datasetController.getByProjectAndDsName(project, this.settings.getHiveWarehouse(), project.getName().toLowerCase() + "_featurestore" + ".db");
        if (projectDs != null && projectDs.getDsType() == DatasetType.HIVEDB || forceCleanup) {
            this.dropDatabase(project.getName(), project, dfso);
        }
        if (featurestoreDs != null && featurestoreDs.getDsType() == DatasetType.FEATURESTORE || forceCleanup) {
            this.dropDatabase(project.getName() + "_featurestore", project, dfso);
        }
    }

    public void createDatabase(String dbName, String dbDescription) throws IOException, ServiceException {
        Database database = new Database();
        database.setName(dbName);
        database.setDescription(dbDescription);
        ThriftHiveMetastore.Client client = null;
        try {
            client = this.openSuperMetastoreClient();
            client.create_database(database);
        }
        catch (TException e) {
            throw new IOException(e);
        }
        finally {
            this.finalizeMetastoreOperation(null, null, client);
        }
    }

    private void dropDatabase(String dbName, Project project, DistributedFileSystemOps dfso) throws IOException, ServiceException {
        ThriftHiveMetastore.Client superClient = null;
        ThriftHiveMetastore.Client projectOwnerClient = null;
        try {
            projectOwnerClient = this.openUserMetastoreClient(project, project.getOwner());
            for (String tableName : projectOwnerClient.get_all_tables(dbName)) {
                projectOwnerClient.drop_table(dbName, tableName, true);
            }
            Path dbPath = this.getDbPath(dbName);
            dfso.rm(new Path(dbPath, "storage_connector_resources"), true);
            dfso.setOwner(dbPath, this.settings.getHiveSuperUser(), this.settings.getHiveSuperUser());
            superClient = this.openSuperMetastoreClient();
            superClient.drop_database(dbName, true, true);
            this.finalizeMetastoreOperation(null, null, superClient);
            this.finalizeMetastoreOperation(project, project.getOwner(), projectOwnerClient);
        }
        catch (TException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                this.finalizeMetastoreOperation(null, null, superClient);
                this.finalizeMetastoreOperation(project, project.getOwner(), projectOwnerClient);
                throw throwable;
            }
        }
    }

    private ThriftHiveMetastore.Client openSuperMetastoreClient() throws ServiceException, IOException {
        return this.openMetastoreClient(this.settings.getHopsworksUser(), this.bhcs.getSuperKeystorePath(), this.bhcs.getSuperKeystorePassword(), this.bhcs.getSuperKeystore(), this.bhcs.getSuperTrustStorePath(), this.bhcs.getSuperTrustStorePassword(), this.bhcs.getSuperTrustStore());
    }

    public ThriftHiveMetastore.Client openUserMetastoreClient(Project project, Users user) throws ServiceException, IOException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        try {
            this.certificateMaterializer.materializeCertificatesLocal(user.getUsername(), project.getName());
            CertificateMaterializer.CryptoMaterial userMaterial = this.certificateMaterializer.getUserMaterial(user.getUsername(), project.getName());
            String password = String.copyValueOf(userMaterial.getPassword());
            return this.openMetastoreClient(hdfsUsername, this.certificateMaterializer.getUserTransientKeystorePath(project, user), password, userMaterial.getKeyStore(), this.certificateMaterializer.getUserTransientTruststorePath(project, user), password, userMaterial.getTrustStore());
        }
        catch (CryptoPasswordNotFoundException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.METASTORE_CONNECTION_ERROR, Level.SEVERE, "Hive metastore connection error", e.getMessage(), (Throwable)e);
        }
    }

    private ThriftHiveMetastore.Client openMetastoreClient(String user, String keyStorePath, String keyStorePassword, ByteBuffer keyStore, String trustStorePath, String trustStorePassword, ByteBuffer trustStore) throws ServiceException {
        ThriftHiveMetastore.Client client = null;
        try {
            Service metastoreService = this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(HopsworksService.HIVE.getNameWithTag((ServiceTags)HiveTags.metastore));
            TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
            params.setTrustStore(trustStorePath, trustStorePassword);
            params.setKeyStore(keyStorePath, keyStorePassword);
            TSocket transport = TSSLTransportFactory.getClientSocket((String)metastoreService.getAddress(), (int)metastoreService.getPort(), (int)600000, (TSSLTransportFactory.TSSLTransportParameters)params);
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
            client = new ThriftHiveMetastore.Client((TProtocol)protocol);
            if (!transport.isOpen()) {
                transport.open();
            }
            client.set_ugi(user, new ArrayList());
            client.set_crypto(keyStore, keyStorePassword, trustStore, trustStorePassword, false);
        }
        catch (ServiceDiscoveryException | TException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.METASTORE_CONNECTION_ERROR, Level.SEVERE, "Hive metastore connection error", e.getMessage(), e);
        }
        return client;
    }

    public void finalizeMetastoreOperation(Project project, Users user, ThriftHiveMetastore.Client client) {
        if (project != null && user != null) {
            this.certificateMaterializer.removeCertificatesLocal(user.getUsername(), project.getName());
        }
        if (client != null) {
            try {
                client.shutdown();
            }
            catch (TException e) {
                logger.log(Level.SEVERE, "Error closing Metastore connection", e);
            }
        }
    }

    public Path getDbPath(String dbName) {
        return new Path(this.settings.getHiveWarehouse(), dbName.toLowerCase() + ".db");
    }

    public String getDbDirName(String dbName) {
        return dbName.toLowerCase() + ".db";
    }

    public String getHiveServerInternalEndpoint() throws ServiceDiscoveryException {
        return this.getHiveServerEndpoint(HiveTags.hiveserver2_tls);
    }

    private String getHiveServerEndpoint(HiveTags tag) throws ServiceDiscoveryException {
        Service hive = this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(HopsworksService.HIVE.getNameWithTag((ServiceTags)tag));
        return hive.getAddress() + ":" + hive.getPort();
    }
}

