/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.opensearch;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.service.Service;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.security.BaseHadoopClientsService;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.OpenSearchException;
import io.hops.hopsworks.restutils.RESTCodes;
import io.hops.hopsworks.servicediscovery.HopsworksService;
import io.hops.hopsworks.servicediscovery.tags.OpenSearchTags;
import io.hops.hopsworks.servicediscovery.tags.ServiceTags;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.ssl.SSLContexts;
import org.opensearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestHighLevelClient;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@DependsOn(value={"Settings"})
public class OpenSearchClient {
    @EJB
    private Settings settings;
    @EJB
    private BaseHadoopClientsService clientsService;
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;
    private static final Logger LOG = Logger.getLogger(OpenSearchClient.class.getName());
    private RestHighLevelClient elasticClient = null;

    @PostConstruct
    private void init() {
        try {
            this.getClient();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    @PreDestroy
    private void close() {
        try {
            this.shutdownClient();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public synchronized void resetClient() {
        this.elasticClient = null;
    }

    public synchronized RestHighLevelClient getClient() throws OpenSearchException, ServiceDiscoveryException {
        if (this.elasticClient == null) {
            Service elasticService = this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(HopsworksService.OPENSEARCH.getNameWithTag((ServiceTags)OpenSearchTags.rest));
            HttpHost elasticAddr = new HttpHost(elasticService.getName(), elasticService.getPort().intValue(), this.settings.isOpenSearchHTTPSEnabled() ? "https" : "http");
            boolean isSecurityEnabled = this.settings.isOpenSearchSecurityEnabled();
            SSLContext sslCtx = null;
            BasicCredentialsProvider credentialsProvider = null;
            if (isSecurityEnabled) {
                Path trustStore = Paths.get(this.clientsService.getSuperTrustStorePath(), new String[0]);
                char[] trustStorePassword = this.clientsService.getSuperTrustStorePassword().toCharArray();
                try {
                    sslCtx = SSLContexts.custom().loadTrustMaterial(trustStore.toFile(), trustStorePassword).build();
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_CONNECTION_ERROR, Level.INFO, "Error while setting up connections to opensearch", e.getMessage(), (Throwable)e);
                }
                credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.settings.getOpenSearchAdminUser(), this.settings.getOpenSearchAdminPassword()));
            }
            SSLContext finalSslCtx = sslCtx;
            BasicCredentialsProvider finalCredentialsProvider = credentialsProvider;
            this.elasticClient = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{elasticAddr}).setHttpClientConfigCallback(httpAsyncClientBuilder -> {
                httpAsyncClientBuilder.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(30).setSoKeepAlive(true).build());
                if (isSecurityEnabled) {
                    return httpAsyncClientBuilder.setSSLContext(finalSslCtx).setDefaultCredentialsProvider(finalCredentialsProvider).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                }
                return httpAsyncClientBuilder;
            }));
        }
        return this.elasticClient;
    }

    private void shutdownClient() throws OpenSearchException {
        if (this.elasticClient != null) {
            try {
                this.elasticClient.indices().clearCache(new ClearIndicesCacheRequest(new String[]{"projects"}), RequestOptions.DEFAULT);
                this.elasticClient.close();
                this.elasticClient = null;
            }
            catch (IOException e) {
                throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_INTERNAL_REQ_ERROR, Level.INFO, "Error while shuting down client", e.getMessage(), (Throwable)e);
            }
        }
    }
}

