/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.core;

import io.hops.hopsworks.common.provenance.core.dto.ProvTypeDTO;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;

public class Provenance {
    public static Type getProvType(ProvTypeDTO aux) throws ProvenanceException {
        switch (aux.getMetaStatus()) {
            case DISABLED: {
                return Type.DISABLED;
            }
            case META_ENABLED: {
                return Type.META;
            }
            case MIN_PROV_ENABLED: {
                return Type.MIN;
            }
            case FULL_PROV_ENABLED: {
                return Type.FULL;
            }
        }
        throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.UNSUPPORTED, Level.INFO, "malformed type dto");
    }

    public static String getProjectIndex(Inode projectInode) {
        return projectInode.getId() + "__file_prov";
    }

    public static ProvTypeDTO getDatasetProvCore(ProvTypeDTO projectProvCore, MLType type) {
        switch (type) {
            case FEATURE: 
            case TRAINING_DATASET: 
            case MODEL: 
            case EXPERIMENT: {
                return projectProvCore;
            }
            case DATASET: 
            case HIVE: {
                if (projectProvCore.getMetaStatus().equals((Object)Type.DISABLED.dto.getMetaStatus())) {
                    return Type.DISABLED.dto;
                }
                return Type.META.dto;
            }
        }
        return Type.DISABLED.dto;
    }

    public static enum FootprintType {
        ALL,
        INPUT,
        OUTPUT_MODIFIED,
        OUTPUT_ADDED,
        OUTPUT_TMP,
        OUTPUT_REMOVED;

    }

    public static enum AppState {
        SUBMITTED,
        RUNNING,
        FINISHED,
        KILLED,
        FAILED,
        UNKNOWN;


        public boolean isFinalState() {
            switch (this) {
                case FINISHED: 
                case KILLED: 
                case FAILED: {
                    return true;
                }
            }
            return false;
        }
    }

    public static enum MLType {
        FEATURE,
        TRAINING_DATASET,
        EXPERIMENT,
        MODEL,
        HIVE,
        DATASET,
        NONE;

    }

    public static enum FileOps {
        CREATE,
        DELETE,
        ACCESS_DATA,
        MODIFY_DATA,
        XATTR_ADD,
        XATTR_UPDATE,
        XATTR_DELETE;

    }

    public static enum OpStore {
        NONE,
        STATE,
        ALL;

    }

    public static enum Type {
        DISABLED(new ProvTypeDTO(Inode.MetaStatus.DISABLED, OpStore.NONE)),
        META(new ProvTypeDTO(Inode.MetaStatus.META_ENABLED, OpStore.NONE)),
        MIN(new ProvTypeDTO(Inode.MetaStatus.MIN_PROV_ENABLED, OpStore.STATE)),
        FULL(new ProvTypeDTO(Inode.MetaStatus.FULL_PROV_ENABLED, OpStore.ALL));

        public ProvTypeDTO dto;

        private Type(ProvTypeDTO dto) {
            this.dto = dto;
        }
    }
}

