/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.explicit;

import com.google.common.collect.Lists;
import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.persistence.entity.provenance.ProvExplicitNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.validation.ConstraintViolationException;

public abstract class LinkFacade<T, C, P, L extends ProvExplicitNode>
extends AbstractFacade<T> {
    static final Logger LOGGER = Logger.getLogger(LinkFacade.class.getName());
    protected Class<L> linkType;
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;
    @EJB
    protected Settings settings;

    public LinkFacade(Class<T> entityClass, Class<L> linkType) {
        super(entityClass);
        this.linkType = linkType;
    }

    public void persist(L link) {
        try {
            this.em.persist(link);
            this.em.flush();
        }
        catch (ConstraintViolationException cve) {
            LOGGER.log(Level.WARNING, "Could not persist the explicit link:" + link.getClass().getSimpleName(), cve);
            throw cve;
        }
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public L updateMetadata(L link) {
        this.em.merge(link);
        return link;
    }

    public Collection<L> findByChild(C child) {
        return this.findByChildren(Collections.singletonList(child));
    }

    public Collection<L> findByChildren(List<C> children) {
        if (children.size() > this.settings.getSQLMaxSelectIn()) {
            ArrayList result = new ArrayList();
            for (List childrenPart : Lists.partition(children, (int)this.settings.getSQLMaxSelectIn())) {
                TypedQuery query = this.em.createNamedQuery(this.linkType.getSimpleName() + ".findByChildren", this.linkType);
                query.setParameter("children", (Object)childrenPart);
                result.addAll(query.getResultList());
            }
            return result;
        }
        TypedQuery query = this.em.createNamedQuery(this.linkType.getSimpleName() + ".findByChildren", this.linkType);
        query.setParameter("children", children);
        return query.getResultList();
    }

    public Collection<L> findByParent(P parent) {
        return this.findByParents(Collections.singletonList(parent));
    }

    public Collection<L> findByParents(List<P> parents) {
        if (parents.size() > this.settings.getSQLMaxSelectIn()) {
            ArrayList result = new ArrayList();
            for (List parentsPart : Lists.partition(parents, (int)this.settings.getSQLMaxSelectIn())) {
                TypedQuery query = this.em.createNamedQuery(this.linkType.getSimpleName() + ".findByParents", this.linkType);
                query.setParameter("parents", (Object)parentsPart);
                result.addAll(query.getResultList());
            }
            return result;
        }
        TypedQuery query = this.em.createNamedQuery(this.linkType.getSimpleName() + ".findByParents", this.linkType);
        query.setParameter("parents", parents);
        return query.getResultList();
    }
}

