/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.commands.custom;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dataset.DatasetController;
import io.hops.hopsworks.common.dataset.FilePreviewDTO;
import io.hops.hopsworks.common.dataset.FilePreviewMode;
import io.hops.hopsworks.common.dataset.util.DatasetHelper;
import io.hops.hopsworks.common.dataset.util.DatasetPath;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.python.commands.CommandsController;
import io.hops.hopsworks.common.python.commands.custom.CustomCommandsSettings;
import io.hops.hopsworks.exceptions.DatasetException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.dataset.DatasetType;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.python.CondaCommands;
import io.hops.hopsworks.persistence.entity.python.CondaInstallType;
import io.hops.hopsworks.persistence.entity.python.CondaOp;
import io.hops.hopsworks.persistence.entity.python.CondaStatus;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.io.FilenameUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class CustomCommandsController {
    private static final Logger LOGGER = Logger.getLogger(CustomCommandsController.class.getName());
    @EJB
    private DistributedFsService dfs;
    @EJB
    private DatasetHelper datasetHelper;
    @EJB
    private DatasetController datasetController;
    @EJB
    private CommandsController commandsController;

    public CondaCommands buildEnvWithCustomCommands(Project project, Users users, CustomCommandsSettings cmdSettings, String version) throws IOException, DatasetException, ServiceException {
        this.validateCommandsFile(project, users, cmdSettings.getCommandsFile());
        if (!Strings.isNullOrEmpty((String)cmdSettings.getArtifacts())) {
            this.validateArtifacts(cmdSettings);
        }
        CondaCommands cc = new CondaCommands(users, CondaOp.CUSTOM_COMMANDS, CondaStatus.NEW, CondaInstallType.CUSTOM_COMMANDS, project, null, version, null, cmdSettings.getArtifacts(), null, Boolean.valueOf(false), null, null);
        cc.setCustomCommandsFile(cmdSettings.getCommandsFile());
        this.commandsController.create(cc);
        return cc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateArtifacts(CustomCommandsSettings cmdSettings) throws IOException, ServiceException {
        DistributedFileSystemOps dfso = null;
        try {
            String[] artifacts;
            dfso = this.dfs.getDfsOps();
            for (String artifact : artifacts = cmdSettings.getArtifacts().split(",")) {
                if (!dfso.exists(artifact)) {
                    throw new ServiceException(RESTCodes.ServiceErrorCode.INVALID_DOCKER_COMMAND_FILE, Level.INFO, "Artifact path: " + artifact + " does not exist");
                }
                if (!dfso.isDir(artifact)) continue;
                throw new ServiceException(RESTCodes.ServiceErrorCode.INVALID_DOCKER_COMMAND_FILE, Level.INFO, "Artifact, " + artifact + ", is a directory");
            }
        }
        finally {
            this.dfs.closeDfsClient(dfso);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateCommandsFile(Project project, Users user, String commandsFile) throws DatasetException, ServiceException {
        if (Strings.isNullOrEmpty((String)commandsFile)) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.INVALID_DOCKER_COMMAND_FILE, Level.INFO, "Please provide the file path that contains the commands you would like to execute");
        }
        if (!FilenameUtils.getExtension((String)commandsFile).equals("sh")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.INVALID_DOCKER_COMMAND_FILE, Level.INFO, "The commands file should have .sh extension");
        }
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfs.getDfsOps();
            DatasetPath datasetPath = this.datasetHelper.getDatasetPathIfFileExist(project, commandsFile, DatasetType.DATASET);
            FilePreviewDTO previewDTO = this.datasetController.filePreview(datasetPath.getAccessProject(), user, datasetPath.getFullPath(), FilePreviewMode.TAIL, new ArrayList<String>());
            String commands = previewDTO.getContent();
            if (Strings.isNullOrEmpty((String)commands)) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.INVALID_DOCKER_COMMAND_FILE, Level.INFO, "The commands file provided is empty");
            }
            if (!commands.startsWith("#!/bin/bash")) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.INVALID_DOCKER_COMMAND_FILE, Level.INFO, "The commands file provided is not a valid bash script: the first line in the script should be #!/bin/bash");
            }
        }
        finally {
            this.dfs.closeDfsClient(dfso);
        }
    }
}

