/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security;

import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.CryptoPasswordNotFoundException;
import io.hops.security.HopsUtil;
import io.hops.security.SuperuserKeystoresLoader;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.net.HopsSSLSocketFactory;
import org.apache.hadoop.security.ssl.X509SecurityMaterial;

@Stateless
public class BaseHadoopClientsService {
    @EJB
    private CertificateMaterializer certificateMaterializer;
    @EJB
    protected Settings settings;
    private X509SecurityMaterial securityMaterial;
    private String materialPassword;
    private final Logger LOG = Logger.getLogger(BaseHadoopClientsService.class.getName());

    @PostConstruct
    public void init() {
        String confDir = this.settings.getHadoopConfDir();
        File coreSite = new File(confDir, "core-site.xml");
        if (!coreSite.exists()) {
            this.handleMissingConf("core-site.xml", confDir);
        }
        Configuration conf = new Configuration();
        conf.addResource(new Path(coreSite.getAbsolutePath()));
        try {
            SuperuserKeystoresLoader loader = new SuperuserKeystoresLoader(conf);
            this.securityMaterial = loader.loadSuperUserMaterial();
            this.materialPassword = HopsUtil.readCryptoMaterialPassword((File)this.securityMaterial.getPasswdLocation().toFile());
        }
        catch (IOException ex) {
            this.LOG.log(Level.SEVERE, "Could not load super user x.509 material", ex);
            throw new RuntimeException(ex);
        }
    }

    public String getSuperKeystorePath() {
        return this.securityMaterial.getKeyStoreLocation().toString();
    }

    public ByteBuffer getSuperKeystore() throws IOException {
        byte[] keystore = FileUtils.readFileToByteArray((File)this.securityMaterial.getKeyStoreLocation().toFile());
        return ByteBuffer.wrap(keystore);
    }

    public String getSuperKeystorePassword() {
        return this.materialPassword;
    }

    public String getSuperTrustStorePath() {
        return this.securityMaterial.getTrustStoreLocation().toString();
    }

    public ByteBuffer getSuperTrustStore() throws IOException {
        byte[] trustStore = FileUtils.readFileToByteArray((File)this.securityMaterial.getTrustStoreLocation().toFile());
        return ByteBuffer.wrap(trustStore);
    }

    public String getSuperTrustStorePassword() {
        return this.materialPassword;
    }

    public String getProjectSpecificUserCertPassword(String username) throws CryptoPasswordNotFoundException {
        if (username != null) {
            String[] project_username = username.split("__", 2);
            CertificateMaterializer.CryptoMaterial cryptoMaterial = this.certificateMaterializer.getUserMaterial(project_username[1], project_username[0]);
            return new String(cryptoMaterial.getPassword());
        }
        throw new RuntimeException("Username cannot be null!");
    }

    public void configureTlsForProjectSpecificUser(String username, String transientDir, Configuration conf) throws CryptoPasswordNotFoundException {
        String password = this.getProjectSpecificUserCertPassword(username);
        String prefix = Paths.get(transientDir, username).toString();
        String kstorePath = prefix + "__kstore.jks";
        String tstorePath = prefix + "__tstore.jks";
        HopsSSLSocketFactory.setTlsConfiguration((String)kstorePath, (String)password, (String)tstorePath, (String)password, (Configuration)conf);
    }

    public void materializeCertsForNonSuperUser(String username) {
        String[] tokens;
        if (username != null && (tokens = username.split("__", 2)).length == 2) {
            try {
                this.certificateMaterializer.materializeCertificatesLocal(tokens[1], tokens[0]);
            }
            catch (IOException ex) {
                throw new RuntimeException("Error while materializing user certificates " + ex.getMessage(), ex);
            }
        }
    }

    public void removeNonSuperUserCertificate(String username) {
        String[] tokens;
        if (username != null && (tokens = username.split("__", 2)).length == 2) {
            this.certificateMaterializer.removeCertificatesLocal(tokens[1], tokens[0]);
        }
    }

    private void handleMissingConf(String confName, String confDir) throws IllegalStateException {
        this.LOG.log(Level.SEVERE, "Unable to locate {0} in {1}", new Object[]{confName, confDir});
        throw new IllegalStateException("Unable to locate " + confName + " in " + confDir);
    }
}

