/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.ejb.AsyncResult;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

@Stateless
public class WebCommunication {
    private static final Logger logger = Logger.getLogger(WebCommunication.class.getName());
    private static boolean DISABLE_CERTIFICATE_VALIDATION = true;
    private static String PROTOCOL = "https";
    private static int PORT = 8090;
    private static String NOT_AVAILABLE = "Not available.";
    private final ConcurrentLinkedQueue<Client> inUseClientPool = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Client> availableClientPool = new ConcurrentLinkedQueue();

    @PreDestroy
    private void cleanUp() {
        for (Client client : this.availableClientPool) {
            client.close();
            client = null;
        }
        for (Client client : this.inUseClientPool) {
            client.close();
            Object var2_2 = null;
        }
    }

    public String serviceOp(String operation, String hostAddress, String agentPassword, String group, String service) throws GenericException {
        String url = this.createUrl(operation, hostAddress, group, service);
        return this.fetchContent(url, agentPassword);
    }

    @Asynchronous
    public Future<String> asyncServiceOp(String operation, String hostAddress, String agentPassword, String group, String service) throws GenericException {
        String url = this.createUrl(operation, hostAddress, group, service);
        return new AsyncResult((Object)this.fetchContent(url, agentPassword));
    }

    private String createUrl(String context, String hostAddress, String ... args) {
        String template = "%s://%s:%s/%s";
        StringBuilder url = new StringBuilder(String.format(template, PROTOCOL, hostAddress, PORT, context));
        for (String arg : args) {
            url.append("/").append(arg);
        }
        return url.toString();
    }

    private String fetchContent(String url, String agentPassword) throws GenericException {
        String content = NOT_AVAILABLE;
        try {
            Response response = this.getWebResource(url, agentPassword);
            int code = response.getStatus();
            Response.Status.Family res = Response.Status.Family.familyOf((int)code);
            content = (String)response.readEntity(String.class);
            if (res == Response.Status.Family.SUCCESSFUL) {
                return content;
            }
            throw new GenericException(RESTCodes.GenericErrorCode.UNKNOWN_ERROR, Level.SEVERE, content, "Error code:" + code + " Reason: " + content);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            logger.log(Level.SEVERE, null, e);
            throw new GenericException(RESTCodes.GenericErrorCode.UNKNOWN_ERROR, Level.SEVERE, null, e.getMessage(), (Throwable)e);
        }
    }

    private Response getWebResource(String url, String agentPassword) throws NoSuchAlgorithmException, KeyManagementException {
        return this.getWebResource(url, agentPassword, null);
    }

    private Response getWebResource(String url, String agentPassword, Map<String, String> args) throws NoSuchAlgorithmException, KeyManagementException {
        Client client = this.getClient();
        WebTarget webResource = client.target(url);
        webResource = webResource.queryParam("username", new Object[]{"kagent@hops.io"});
        webResource = webResource.queryParam("password", new Object[]{agentPassword});
        if (args != null) {
            for (Map.Entry<String, String> entrySet : args.entrySet()) {
                webResource = webResource.queryParam(entrySet.getKey(), new Object[]{entrySet.getValue()});
            }
        }
        logger.log(Level.FINEST, "WebCommunication: Requesting url: {0} with password {1}", new Object[]{url, agentPassword});
        Response response = (Response)webResource.request().header("Accept-Encoding", (Object)"gzip,deflate").get(Response.class);
        this.discardClient(client);
        logger.log(Level.INFO, "WebCommunication: Requesting url: {0}", url);
        return response;
    }

    private Client getClient() throws NoSuchAlgorithmException, KeyManagementException {
        Client client = this.availableClientPool.poll();
        if (null == client) {
            client = this.createClient();
        }
        this.inUseClientPool.offer(client);
        return client;
    }

    private void discardClient(Client client) {
        this.inUseClientPool.remove(client);
        this.availableClientPool.offer(client);
    }

    private Client createClient() throws NoSuchAlgorithmException, KeyManagementException {
        if (DISABLE_CERTIFICATE_VALIDATION) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String hostAddress, SSLSession session) {
                    return true;
                }
            };
            SSLContext sc = SSLContext.getInstance("TLSv1.2");
            sc.init(null, trustAllCerts, new SecureRandom());
            ClientBuilder clientBuilder = ClientBuilder.newBuilder().hostnameVerifier(hv).sslContext(sc);
            return clientBuilder.build();
        }
        return ClientBuilder.newClient();
    }
}

