/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.jwt;

import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.ECDSAKeyProvider;
import com.auth0.jwt.interfaces.RSAKeyProvider;
import io.hops.hopsworks.jwt.JsonWebToken;
import io.hops.hopsworks.jwt.SignatureAlgorithm;
import io.hops.hopsworks.jwt.dao.JwtSigningKey;
import io.hops.hopsworks.jwt.dao.JwtSigningKeyFacade;
import io.hops.hopsworks.jwt.exception.SigningKeyNotFoundException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ws.rs.NotSupportedException;

@Stateless
public class AlgorithmFactory {
    @EJB
    private JwtSigningKeyFacade jwtSigningKeyFacade;

    public Algorithm getAlgorithm(DecodedJWT jwt) throws SigningKeyNotFoundException {
        return this.getAlgorithm(jwt.getAlgorithm(), jwt.getKeyId());
    }

    public Algorithm getAlgorithm(JsonWebToken jwt) throws SigningKeyNotFoundException {
        return this.getAlgorithm(jwt.getAlgorithm(), jwt.getKeyId());
    }

    public Algorithm getAlgorithm(String algorithm, String keyId) throws SigningKeyNotFoundException {
        SignatureAlgorithm alg = SignatureAlgorithm.valueOf(algorithm);
        return this.getAlgorithm(alg, keyId);
    }

    public Algorithm getAlgorithm(SignatureAlgorithm algorithm, String keyId) throws SigningKeyNotFoundException {
        switch (algorithm) {
            case ES256: {
                return this.getES256Algorithm(keyId);
            }
            case ES384: {
                return this.getES384Algorithm(keyId);
            }
            case ES512: {
                return this.getES512Algorithm(keyId);
            }
            case HS256: {
                return this.getHS256Algorithm(keyId);
            }
            case HS384: {
                return this.getHS384Algorithm(keyId);
            }
            case HS512: {
                return this.getHS512Algorithm(keyId);
            }
            case RS256: {
                return this.getRS256Algorithm(keyId);
            }
            case RS384: {
                return this.getRS384Algorithm(keyId);
            }
            case RS512: {
                return this.getRS512Algorithm(keyId);
            }
        }
        throw new NotSupportedException("Algorithm not supported.");
    }

    private Algorithm getES256Algorithm(String keyId) {
        ECDSAKeyProviderImpl keyProvider = new ECDSAKeyProviderImpl(keyId);
        return Algorithm.ECDSA256((ECDSAKeyProvider)keyProvider);
    }

    private Algorithm getES384Algorithm(String keyId) {
        ECDSAKeyProviderImpl keyProvider = new ECDSAKeyProviderImpl(keyId);
        return Algorithm.ECDSA384((ECDSAKeyProvider)keyProvider);
    }

    private Algorithm getES512Algorithm(String keyId) {
        ECDSAKeyProviderImpl keyProvider = new ECDSAKeyProviderImpl(keyId);
        return Algorithm.ECDSA512((ECDSAKeyProvider)keyProvider);
    }

    private String getSigningKey(String keyId) throws SigningKeyNotFoundException {
        Integer id;
        try {
            id = Integer.parseInt(keyId);
        }
        catch (NumberFormatException e) {
            throw new SigningKeyNotFoundException("Signing key not found. The key id should be integer.");
        }
        JwtSigningKey signingKey = this.jwtSigningKeyFacade.find(id);
        if (signingKey == null) {
            throw new SigningKeyNotFoundException("Signing key not found.");
        }
        return signingKey.getSecret();
    }

    private Algorithm getHS256Algorithm(String keyId) throws SigningKeyNotFoundException {
        return Algorithm.HMAC256((String)this.getSigningKey(keyId));
    }

    private Algorithm getHS384Algorithm(String keyId) throws SigningKeyNotFoundException {
        return Algorithm.HMAC384((String)this.getSigningKey(keyId));
    }

    private Algorithm getHS512Algorithm(String keyId) throws SigningKeyNotFoundException {
        return Algorithm.HMAC512((String)this.getSigningKey(keyId));
    }

    private Algorithm getRS256Algorithm(String keyId) {
        RSAKeyProviderImpl keyProvider = new RSAKeyProviderImpl(keyId);
        return Algorithm.RSA256((RSAKeyProvider)keyProvider);
    }

    private Algorithm getRS384Algorithm(String keyId) {
        RSAKeyProviderImpl keyProvider = new RSAKeyProviderImpl(keyId);
        return Algorithm.RSA384((RSAKeyProvider)keyProvider);
    }

    private Algorithm getRS512Algorithm(String keyId) {
        RSAKeyProviderImpl keyProvider = new RSAKeyProviderImpl(keyId);
        return Algorithm.RSA512((RSAKeyProvider)keyProvider);
    }

    private class ECDSAKeyProviderImpl
    implements ECDSAKeyProvider {
        final String privateKeyId;

        public ECDSAKeyProviderImpl(String keyId) {
            this.privateKeyId = keyId;
        }

        public ECPublicKey getPublicKeyById(String keyId) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ECPrivateKey getPrivateKey() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getPrivateKeyId() {
            return this.privateKeyId;
        }
    }

    private class RSAKeyProviderImpl
    implements RSAKeyProvider {
        final String privateKeyId;

        public RSAKeyProviderImpl(String keyId) {
            this.privateKeyId = keyId;
        }

        public RSAPublicKey getPublicKeyById(String keyId) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public RSAPrivateKey getPrivateKey() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getPrivateKeyId() {
            return this.privateKeyId;
        }
    }
}

