/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.jwt.dao;

import io.hops.hopsworks.jwt.SignatureAlgorithm;
import io.hops.hopsworks.jwt.SigningKeyGenerator;
import io.hops.hopsworks.jwt.dao.JwtSigningKey;
import io.hops.hopsworks.jwt.exception.DuplicateSigningKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class JwtSigningKeyFacade {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;
    @EJB
    private SigningKeyGenerator signingKeyGenerator;

    public JwtSigningKey find(Integer id) {
        return (JwtSigningKey)this.em.find(JwtSigningKey.class, (Object)id);
    }

    public List<JwtSigningKey> findAll() {
        TypedQuery query = this.em.createNamedQuery("JwtSigningKey.findAll", JwtSigningKey.class);
        return query.getResultList();
    }

    public JwtSigningKey findByName(String keyName) {
        TypedQuery query = this.em.createNamedQuery("JwtSigningKey.findByName", JwtSigningKey.class).setParameter("name", (Object)keyName);
        try {
            return (JwtSigningKey)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public void renameSigningKey(String keyName, String newName) {
        JwtSigningKey signingKey = this.findByName(keyName);
        this.renameSigningKey(signingKey, newName);
    }

    public void renameSigningKey(JwtSigningKey signingKey, String newName) {
        signingKey.setName(newName);
        this.em.merge((Object)signingKey);
    }

    public JwtSigningKey getOrCreateSigningKey(String keyName, SignatureAlgorithm alg) throws NoSuchAlgorithmException {
        JwtSigningKey signingKey = this.findByName(keyName);
        if (signingKey == null) {
            signingKey = this.createSigningKey(keyName, alg);
        }
        return signingKey;
    }

    public JwtSigningKey createNewSigningKey(String keyName, SignatureAlgorithm alg) throws NoSuchAlgorithmException, DuplicateSigningKeyException {
        JwtSigningKey signingKey = this.findByName(keyName);
        if (signingKey != null) {
            throw new DuplicateSigningKeyException("A signing key with the same name already exists.");
        }
        return this.createSigningKey(keyName, alg);
    }

    private JwtSigningKey createSigningKey(String keyName, SignatureAlgorithm alg) throws NoSuchAlgorithmException {
        String base64Encoded = this.signingKeyGenerator.getSigningKey(alg.getJcaName());
        JwtSigningKey signingKey = new JwtSigningKey(base64Encoded, keyName);
        this.persist(signingKey);
        JwtSigningKey newSigningKey = this.findByName(keyName);
        return newSigningKey;
    }

    public void persist(JwtSigningKey invalidJwt) {
        this.em.persist((Object)invalidJwt);
    }

    public JwtSigningKey merge(JwtSigningKey invalidJwt) {
        return (JwtSigningKey)this.em.merge((Object)invalidJwt);
    }

    public void remove(JwtSigningKey jwtSigningKey) {
        JwtSigningKey jsk = this.find(jwtSigningKey.getId());
        if (jsk == null) {
            return;
        }
        this.em.remove((Object)jsk);
    }

    public void remove(String name) {
        JwtSigningKey jsk = this.findByName(name);
        if (jsk == null) {
            return;
        }
        this.em.remove((Object)jsk);
    }
}

