/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.jwt.filter;

import io.hops.hopsworks.jwt.exception.JWTException;
import io.hops.hopsworks.jwt.exception.NotRenewableException;
import io.hops.hopsworks.jwt.utils.ProxyAuthHelper;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;

public abstract class JWTRenewFilter
implements ContainerResponseFilter {
    private static final Logger LOGGER = Logger.getLogger(JWTRenewFilter.class.getName());

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (!responseContext.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
            return;
        }
        this.renewJWT(requestContext, responseContext);
        this.renewProxyJWT(requestContext, responseContext);
    }

    private String renew(String jwt) {
        String token = null;
        try {
            token = this.renewToken(jwt);
        }
        catch (NotRenewableException notRenewableException) {
        }
        catch (JWTException ex) {
            LOGGER.log(Level.WARNING, "Failed to renew token. {0}", ex.getMessage());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to renew token.", e);
        }
        return token;
    }

    private void renewJWT(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        String authorizationHeader = requestContext.getHeaderString("Authorization");
        if (authorizationHeader == null || !authorizationHeader.startsWith("Bearer ")) {
            return;
        }
        String jwt = authorizationHeader.substring("Bearer ".length()).trim();
        String token = this.renew(jwt);
        if (token != null) {
            responseContext.getHeaders().putSingle((Object)"Authorization", (Object)("Bearer " + token));
        }
    }

    private void renewProxyJWT(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        Cookie cookie;
        String token;
        if (requestContext.getCookies().containsKey("proxy_session") && (token = this.renew((cookie = (Cookie)requestContext.getCookies().get("proxy_session")).getValue())) != null) {
            NewCookie newCookie = ProxyAuthHelper.getNewCookie(token, this.getTokenLifeMs());
            responseContext.getHeaders().add((Object)"Set-Cookie", (Object)newCookie);
        }
    }

    public abstract String renewToken(String var1) throws JWTException;

    public abstract long getTokenLifeMs();
}

