/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.jwt;

import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.hops.hopsworks.jwt.SignatureAlgorithm;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class JsonWebToken {
    private SignatureAlgorithm algorithm;
    private String issuer;
    private List<String> audience;
    private Date expiresAt;
    private Date notBefore;
    private String keyId;
    private String subject;
    private boolean renewable;
    private int expLeeway;
    private List<String> role;

    public JsonWebToken() {
    }

    public JsonWebToken(String algorithm, String issuer, List<String> audience, Date expiresAt, Date notBefore, String keyId, String subject, boolean renewable, int expLeeway, List<String> role) {
        this.algorithm = SignatureAlgorithm.valueOf(algorithm);
        this.issuer = issuer;
        this.audience = audience;
        this.expiresAt = expiresAt;
        this.notBefore = notBefore;
        this.keyId = keyId;
        this.subject = subject;
        this.renewable = renewable;
        this.expLeeway = expLeeway < 1 ? 60 : expLeeway;
        this.role = role;
    }

    public JsonWebToken(DecodedJWT jwt) {
        this.algorithm = SignatureAlgorithm.valueOf(jwt.getAlgorithm());
        this.issuer = jwt.getIssuer();
        this.audience = jwt.getAudience();
        this.expiresAt = jwt.getExpiresAt();
        this.notBefore = jwt.getNotBefore();
        this.keyId = jwt.getKeyId();
        this.subject = jwt.getSubject();
        Claim renewableClaim = jwt.getClaim("renewable");
        this.renewable = renewableClaim != null && !renewableClaim.isNull() ? renewableClaim.asBoolean() : false;
        Claim expLeewayClaim = jwt.getClaim("expLeeway");
        this.expLeeway = expLeewayClaim == null || expLeewayClaim.isNull() || expLeewayClaim.asInt() < 1 ? 60 : expLeewayClaim.asInt();
        Claim roleClaim = jwt.getClaim("roles");
        this.role = roleClaim != null && !roleClaim.isNull() ? roleClaim.asList(String.class) : new ArrayList<String>();
    }

    public SignatureAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(SignatureAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public List<String> getAudience() {
        return this.audience;
    }

    public void setAudience(List<String> audience) {
        this.audience = audience;
    }

    public boolean isRenewable() {
        return this.renewable;
    }

    public void setRenewable(boolean renewable) {
        this.renewable = renewable;
    }

    public Date getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(Date expiresAt) {
        this.expiresAt = expiresAt;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(Date notBefore) {
        this.notBefore = notBefore;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public int getExpLeeway() {
        return this.expLeeway;
    }

    public void setExpLeeway(int expLeeway) {
        this.expLeeway = expLeeway;
    }

    public List<String> getRole() {
        return this.role;
    }

    public void setRole(List<String> role) {
        this.role = role;
    }

    public String toString() {
        return "JsonWebToken{algorithm=" + (Object)((Object)this.algorithm) + ", issuer=" + this.issuer + ", audience=" + this.audience + ", expiresAt=" + this.expiresAt + ", notBefore=" + this.notBefore + ", keyId=" + this.keyId + ", subject=" + this.subject + ", renewable=" + this.renewable + ", expLeeway=" + this.expLeeway + ", role=" + this.role + '}';
    }
}

