/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.jwt.filter;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.hops.hopsworks.jwt.exception.SigningKeyNotFoundException;
import io.hops.hopsworks.jwt.utils.ProxyAuthHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;

public abstract class JWTFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = Logger.getLogger(JWTFilter.class.getName());

    public final void filter(ContainerRequestContext requestContext) throws IOException {
        if (this.preJWTFilter(requestContext)) {
            this.jwtFilter(requestContext);
        }
    }

    public void jwtFilter(ContainerRequestContext requestContext) throws IOException {
        String authorizationHeader = requestContext.getHeaderString("Authorization");
        if (authorizationHeader == null) {
            LOGGER.log(Level.FINEST, "Authorization header not set.");
            Object responseEntity = this.responseEntity(Response.Status.UNAUTHORIZED, "Authorization header not set.");
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Bearer realm=\"Cauth Realm\"").entity(responseEntity).build());
            return;
        }
        if (!authorizationHeader.startsWith("Bearer ")) {
            LOGGER.log(Level.FINEST, "Invalid token. AuthorizationHeader : {0}", authorizationHeader);
            Object responseEntity = this.responseEntity(Response.Status.UNAUTHORIZED, "Invalidated token.");
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Bearer realm=\"Cauth Realm\"").entity(responseEntity).build());
            return;
        }
        String token = authorizationHeader.substring("Bearer ".length()).trim();
        DecodedJWT jwt = JWT.decode((String)token);
        Claim expLeewayClaim = jwt.getClaim("expLeeway");
        String issuer = this.getIssuer();
        int expLeeway = expLeewayClaim.asInt();
        try {
            Algorithm algorithm = this.getAlgorithm(jwt);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer(new String[]{issuer == null || issuer.isEmpty() ? jwt.getIssuer() : issuer}).acceptExpiresAt(expLeeway == 0 ? 60L : (long)expLeeway).build();
            jwt = verifier.verify(token);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "JWT Verification Exception: {0}", exception.getMessage());
            Object responseEntity = this.responseEntity(Response.Status.UNAUTHORIZED, exception.getMessage());
            NewCookie newCookie = ProxyAuthHelper.getNewCookieForLogout();
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).cookie(new NewCookie[]{newCookie}).header("WWW-Authenticate", (Object)"Bearer realm=\"Cauth Realm\"").entity(responseEntity).build());
            return;
        }
        if (!this.isTokenValid(jwt)) {
            LOGGER.log(Level.FINEST, "JWT Verification Exception: Invalidated token.");
            Object responseEntity = this.responseEntity(Response.Status.UNAUTHORIZED, "Invalidated token.");
            NewCookie newCookie = ProxyAuthHelper.getNewCookieForLogout();
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).cookie(new NewCookie[]{newCookie}).header("WWW-Authenticate", (Object)"Bearer realm=\"Cauth Realm\"").entity(responseEntity).build());
            return;
        }
        Claim rolesClaim = jwt.getClaim("roles");
        String[] userRoles = rolesClaim == null || rolesClaim.isNull() ? new String[]{} : (String[])rolesClaim.asArray(String.class);
        Set<String> allowedRolesSet = this.allowedRoles();
        if (allowedRolesSet != null && !allowedRolesSet.isEmpty() && !this.intersect(allowedRolesSet, Arrays.asList(userRoles))) {
            LOGGER.log(Level.FINE, "JWT Access Exception: Client not authorized for this invocation.");
            Object responseEntity = this.responseEntity(Response.Status.FORBIDDEN, "Client not authorized for this invocation.");
            requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).entity(responseEntity).build());
            return;
        }
        List audience = jwt.getAudience();
        Set<String> accepts = this.acceptedTokens();
        if (accepts != null && !accepts.isEmpty() && !this.intersect(accepts, audience)) {
            LOGGER.log(Level.FINE, "JWT Access Exception: Token not issued for this recipient.");
            Object responseEntity = this.responseEntity(Response.Status.FORBIDDEN, "Token not issued for this recipient.");
            requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).entity(responseEntity).build());
            return;
        }
        this.postJWTFilter(requestContext, jwt);
    }

    private boolean intersect(Collection list1, Collection list2) {
        if (list1 == null || list1.isEmpty() || list2 == null || list2.isEmpty()) {
            return false;
        }
        HashSet set1 = new HashSet(list1);
        HashSet set2 = new HashSet(list2);
        set1.retainAll(set2);
        return !set1.isEmpty();
    }

    public abstract Algorithm getAlgorithm(DecodedJWT var1) throws SigningKeyNotFoundException;

    public abstract Set<String> allowedRoles();

    public abstract Set<String> acceptedTokens();

    public abstract boolean isTokenValid(DecodedJWT var1);

    public abstract boolean preJWTFilter(ContainerRequestContext var1) throws IOException;

    public abstract void postJWTFilter(ContainerRequestContext var1, DecodedJWT var2) throws IOException;

    public abstract String getIssuer();

    public abstract Object responseEntity(Response.Status var1, String var2);
}

