/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.jwt;

import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.KeyGenerator;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class SigningKeyGenerator {
    private KeyGenerator keyGenerator;

    public String getSigningKey(String algorithm) throws NoSuchAlgorithmException {
        if (this.keyGenerator == null || !this.keyGenerator.getAlgorithm().equals(algorithm)) {
            this.keyGenerator = KeyGenerator.getInstance(algorithm);
        }
        byte[] keyBytes = this.keyGenerator.generateKey().getEncoded();
        String base64Encoded = Base64.getEncoder().encodeToString(keyBytes);
        return base64Encoded;
    }
}

