/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.jwt.utils;

import javax.servlet.http.Cookie;
import javax.ws.rs.core.NewCookie;

public class ProxyAuthHelper {
    public static NewCookie getNewCookie(String token, long tokenLifeMs) {
        int maxAge = ProxyAuthHelper.getMaxAgeFromTokenLifeMs(tokenLifeMs);
        return new NewCookie("proxy_session", token, "/", null, "", maxAge, true, true);
    }

    public static NewCookie getNewCookieForLogout() {
        return new NewCookie("proxy_session", null, "/", null, "", 0, true, true);
    }

    public static Cookie getCookie(String token, long tokenLifeMs) {
        int maxAge = ProxyAuthHelper.getMaxAgeFromTokenLifeMs(tokenLifeMs);
        Cookie newCookie = new Cookie("proxy_session", token);
        newCookie.setHttpOnly(true);
        newCookie.setSecure(true);
        newCookie.setMaxAge(maxAge);
        newCookie.setPath("/");
        newCookie.setComment("");
        return newCookie;
    }

    private static int getMaxAgeFromTokenLifeMs(long tokenLifeMs) {
        long maxAge = Math.abs(tokenLifeMs) / 1000L;
        if (maxAge > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)maxAge;
    }
}

