/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.remote.oauth;

import io.hops.hopsworks.persistence.entity.remote.oauth.OauthLoginState;
import java.io.Serializable;
import java.util.Collection;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.codehaus.jackson.annotate.JsonIgnore;

@Entity
@Table(name="oauth_client", catalog="hopsworks", schema="")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="OauthClient.findAll", query="SELECT o FROM OauthClient o"), @NamedQuery(name="OauthClient.findById", query="SELECT o FROM OauthClient o WHERE o.id = :id"), @NamedQuery(name="OauthClient.findByClientId", query="SELECT o FROM OauthClient o WHERE o.clientId = :clientId"), @NamedQuery(name="OauthClient.findByClientSecret", query="SELECT o FROM OauthClient o WHERE o.clientSecret = :clientSecret"), @NamedQuery(name="OauthClient.findByProviderLogoURI", query="SELECT o FROM OauthClient o WHERE o.providerLogoURI = :providerLogoURI"), @NamedQuery(name="OauthClient.findByProviderURI", query="SELECT o FROM OauthClient o WHERE o.providerURI = :providerURI"), @NamedQuery(name="OauthClient.findByProviderName", query="SELECT o FROM OauthClient o WHERE o.providerName = :providerName"), @NamedQuery(name="OauthClient.findByProviderDisplayName", query="SELECT o FROM OauthClient o WHERE o.providerDisplayName = :providerDisplayName")})
public class OauthClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=256)
    @Column(name="client_id")
    private @NotNull @Size(min=1, max=256) String clientId;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=2048)
    @Column(name="client_secret")
    private @NotNull @Size(min=1, max=2048) String clientSecret;
    @Size(max=2048)
    @Column(name="provider_logo_uri")
    private @Size(max=2048) String providerLogoURI;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=2048)
    @Column(name="provider_uri")
    private @NotNull @Size(min=1, max=2048) String providerURI;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=256)
    @Column(name="provider_name")
    private @NotNull @Size(min=1, max=256) String providerName;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=45)
    @Column(name="provider_display_name")
    private @NotNull @Size(min=1, max=45) String providerDisplayName;
    @Size(max=1024)
    @Column(name="authorisation_endpoint")
    private @Size(max=1024) String authorisationEndpoint;
    @Size(max=1024)
    @Column(name="token_endpoint")
    private @Size(max=1024) String tokenEndpoint;
    @Size(max=1024)
    @Column(name="userinfo_endpoint")
    private @Size(max=1024) String userInfoEndpoint;
    @Size(max=1024)
    @Column(name="jwks_uri")
    private @Size(max=1024) String jwksURI;
    @Basic(optional=false)
    @NotNull
    @Column(name="provider_metadata_endpoint_supported")
    private boolean providerMetadataEndpointSupported;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="clientId")
    private Collection<OauthLoginState> oauthLoginStateCollection;

    public OauthClient() {
    }

    public OauthClient(Integer id) {
        this.id = id;
    }

    public OauthClient(String clientId, String clientSecret, String providerURI, String providerName, String providerLogoURI, String providerDisplayName, boolean providerMetadataEndpointSupported, String authorisationEndpoint, String tokenEndpoint, String userInfoEndpoint, String jwksURI) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.providerURI = providerURI;
        this.providerName = providerName;
        this.providerLogoURI = providerLogoURI;
        this.providerDisplayName = providerDisplayName;
        this.providerMetadataEndpointSupported = providerMetadataEndpointSupported;
        this.authorisationEndpoint = authorisationEndpoint;
        this.tokenEndpoint = tokenEndpoint;
        this.userInfoEndpoint = userInfoEndpoint;
        this.jwksURI = jwksURI;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getProviderLogoURI() {
        return this.providerLogoURI;
    }

    public void setProviderLogoURI(String providerLogoUri) {
        this.providerLogoURI = providerLogoUri;
    }

    public String getProviderURI() {
        return this.providerURI;
    }

    public void setProviderURI(String providerURI) {
        this.providerURI = providerURI;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String authServerName) {
        this.providerName = authServerName;
    }

    public String getProviderDisplayName() {
        return this.providerDisplayName;
    }

    public void setProviderDisplayName(String authServerDisplayname) {
        this.providerDisplayName = authServerDisplayname;
    }

    public String getAuthorisationEndpoint() {
        return this.authorisationEndpoint;
    }

    public void setAuthorisationEndpoint(String authorisationEndpoint) {
        this.authorisationEndpoint = authorisationEndpoint;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public String getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public String getJwksURI() {
        return this.jwksURI;
    }

    public void setJwksURI(String jwksURI) {
        this.jwksURI = jwksURI;
    }

    public void setUserInfoEndpoint(String userinfoEndpoint) {
        this.userInfoEndpoint = userinfoEndpoint;
    }

    public boolean getProviderMetadataEndpointSupported() {
        return this.providerMetadataEndpointSupported;
    }

    public void setProviderMetadataEndpointSupported(boolean providerMetadataEndpointSupported) {
        this.providerMetadataEndpointSupported = providerMetadataEndpointSupported;
    }

    @XmlTransient
    @JsonIgnore
    public Collection<OauthLoginState> getOauthLoginStateCollection() {
        return this.oauthLoginStateCollection;
    }

    public void setOauthLoginStateCollection(Collection<OauthLoginState> oauthLoginStateCollection) {
        this.oauthLoginStateCollection = oauthLoginStateCollection;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof OauthClient)) {
            return false;
        }
        OauthClient other = (OauthClient)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "OauthClient{oauthLoginStateCollection=" + this.oauthLoginStateCollection + ", id=" + this.id + ", clientId='" + this.clientId + '\'' + ", clientSecret='" + this.clientSecret + '\'' + ", providerLogoURI='" + this.providerLogoURI + '\'' + ", providerURI='" + this.providerURI + '\'' + ", providerName='" + this.providerName + '\'' + ", providerDisplayName='" + this.providerDisplayName + '\'' + ", authorisationEndpoint='" + this.authorisationEndpoint + '\'' + ", tokenEndpoint='" + this.tokenEndpoint + '\'' + ", userInfoEndpoint='" + this.userInfoEndpoint + '\'' + ", jwksURI='" + this.jwksURI + '\'' + ", providerMetadataEndpointSupported=" + this.providerMetadataEndpointSupported + '}';
    }
}

