/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.project.alert;

import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.FeatureGroupValidation;
import io.hops.hopsworks.persistence.entity.jobs.configuration.history.JobFinalStatus;
import io.hops.hopsworks.persistence.entity.jobs.configuration.history.JobState;

public enum ProjectServiceAlertStatus {
    VALIDATION_SUCCESS("Success"),
    VALIDATION_WARNING("Warning"),
    VALIDATION_FAILURE("Failure"),
    JOB_FINISHED("Finished"),
    JOB_FAILED("Failed"),
    JOB_KILLED("Killed");

    private final String name;

    private ProjectServiceAlertStatus(String name) {
        this.name = name;
    }

    public static ProjectServiceAlertStatus fromString(String name) {
        return ProjectServiceAlertStatus.valueOf(name.toUpperCase());
    }

    public String getName() {
        return this.name;
    }

    public static ProjectServiceAlertStatus getStatus(FeatureGroupValidation.Status status) {
        switch (status) {
            case FAILURE: {
                return VALIDATION_FAILURE;
            }
            case SUCCESS: {
                return VALIDATION_SUCCESS;
            }
            case WARNING: {
                return VALIDATION_WARNING;
            }
        }
        throw new IllegalArgumentException("Invalid enum constant");
    }

    public static ProjectServiceAlertStatus getJobAlertStatus(JobState jobState) {
        switch (jobState) {
            case FINISHED: {
                return JOB_FINISHED;
            }
            case FAILED: 
            case FRAMEWORK_FAILURE: 
            case APP_MASTER_START_FAILED: 
            case INITIALIZATION_FAILED: {
                return JOB_FAILED;
            }
            case KILLED: {
                return JOB_KILLED;
            }
        }
        throw new IllegalArgumentException("Invalid enum constant");
    }

    public static ProjectServiceAlertStatus getJobAlertStatus(JobFinalStatus jobFinalStatus) {
        switch (jobFinalStatus) {
            case SUCCEEDED: {
                return JOB_FINISHED;
            }
            case FAILED: {
                return JOB_FAILED;
            }
            case KILLED: {
                return JOB_KILLED;
            }
        }
        throw new IllegalArgumentException("Invalid enum constant");
    }

    public boolean isJobStatus() {
        switch (this) {
            case JOB_FAILED: 
            case JOB_KILLED: 
            case JOB_FINISHED: {
                return true;
            }
        }
        return false;
    }

    public boolean isFeatureGroupStatus() {
        switch (this) {
            case VALIDATION_FAILURE: 
            case VALIDATION_SUCCESS: 
            case VALIDATION_WARNING: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

