/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.featurestore.statistics;

import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.StatisticColumn;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import java.io.Serializable;
import java.util.Collection;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="statistics_config", catalog="hopsworks")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="StatisticConfig.findAll", query="SELECT statsconfig FROM StatisticsConfig statsconfig"), @NamedQuery(name="StatisticConfig.findById", query="SELECT statsconfig FROM StatisticsConfig statsconfig WHERE statsconfig.id = :id"), @NamedQuery(name="StatisticColumn.findByFeatureGroup", query="SELECT statsconfig FROM StatisticsConfig statsconfig WHERE statsconfig.featuregroup =:feature_group"), @NamedQuery(name="StatisticColumn.findByTrainingDataset", query="SELECT statsconfig FROM StatisticsConfig statsconfig WHERE statsconfig.trainingDataset =:training_dataset")})
public class StatisticsConfig
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @JoinColumn(name="feature_group_id", referencedColumnName="id")
    private Featuregroup featuregroup;
    @JoinColumn(name="training_dataset_id", referencedColumnName="id")
    private TrainingDataset trainingDataset;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="statisticsConfig")
    private Collection<StatisticColumn> statisticColumns;
    @Basic(optional=false)
    @Column(name="descriptive")
    private boolean descriptive;
    @Basic(optional=false)
    @Column(name="correlations")
    private boolean correlations;
    @Basic(optional=false)
    @Column(name="histograms")
    private boolean histograms;
    @Basic(optional=false)
    @Column(name="exact_uniqueness")
    private boolean exactUniqueness;

    public StatisticsConfig() {
    }

    public StatisticsConfig(boolean descriptive, boolean correlations, boolean histograms, boolean exactUniqueness) {
        this.descriptive = descriptive;
        this.histograms = histograms;
        this.correlations = correlations;
        this.exactUniqueness = exactUniqueness;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Featuregroup getFeaturegroup() {
        return this.featuregroup;
    }

    public void setFeaturegroup(Featuregroup featuregroup) {
        this.featuregroup = featuregroup;
    }

    public TrainingDataset getTrainingDataset() {
        return this.trainingDataset;
    }

    public void setTrainingDataset(TrainingDataset trainingDataset) {
        this.trainingDataset = trainingDataset;
    }

    public Collection<StatisticColumn> getStatisticColumns() {
        return this.statisticColumns;
    }

    public void setStatisticColumns(Collection<StatisticColumn> statisticColumns) {
        this.statisticColumns = statisticColumns;
    }

    public boolean isDescriptive() {
        return this.descriptive;
    }

    public void setDescriptive(boolean descriptive) {
        this.descriptive = descriptive;
    }

    public boolean isCorrelations() {
        return this.correlations;
    }

    public void setCorrelations(boolean correlations) {
        this.correlations = correlations;
    }

    public boolean isHistograms() {
        return this.histograms;
    }

    public void setHistograms(boolean featHistEnabled) {
        this.histograms = featHistEnabled;
    }

    public boolean isExactUniqueness() {
        return this.exactUniqueness;
    }

    public void setExactUniqueness(boolean exactUniqueness) {
        this.exactUniqueness = exactUniqueness;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatisticsConfig that = (StatisticsConfig)o;
        if (this.descriptive != that.descriptive) {
            return false;
        }
        if (this.correlations != that.correlations) {
            return false;
        }
        if (this.histograms != that.histograms) {
            return false;
        }
        if (this.exactUniqueness != that.exactUniqueness) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (this.featuregroup != null ? !this.featuregroup.equals(that.featuregroup) : that.featuregroup != null) {
            return false;
        }
        if (this.trainingDataset != null ? !this.trainingDataset.equals(that.trainingDataset) : that.trainingDataset != null) {
            return false;
        }
        return this.statisticColumns != null ? this.statisticColumns.equals(that.statisticColumns) : that.statisticColumns == null;
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.featuregroup != null ? this.featuregroup.hashCode() : 0);
        result = 31 * result + (this.trainingDataset != null ? this.trainingDataset.hashCode() : 0);
        result = 31 * result + (this.statisticColumns != null ? this.statisticColumns.hashCode() : 0);
        result = 31 * result + (this.descriptive ? 1 : 0);
        result = 31 * result + (this.correlations ? 1 : 0);
        result = 31 * result + (this.histograms ? 1 : 0);
        result = 31 * result + (this.exactUniqueness ? 1 : 0);
        return result;
    }
}

