/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.kafka;

import io.hops.hopsworks.persistence.entity.kafka.SharedTopicsPK;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="shared_topics", catalog="hopsworks", schema="")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="SharedTopics.findAll", query="SELECT s FROM SharedTopics s"), @NamedQuery(name="SharedTopics.findByTopicName", query="SELECT s FROM SharedTopics s WHERE s.sharedTopicsPK.topicName = :topicName"), @NamedQuery(name="SharedTopics.findByProjectId", query="SELECT s FROM SharedTopics s WHERE s.sharedTopicsPK.projectId = :projectId"), @NamedQuery(name="SharedTopics.findByTopicNameAndProjectId", query="SELECT s FROM SharedTopics s WHERE s.sharedTopicsPK.projectId = :projectId and s.sharedTopicsPK.topicName = :topicName"), @NamedQuery(name="SharedTopics.findByTopicAndOwnerProjectId", query="SELECT s FROM SharedTopics s WHERE s.sharedTopicsPK.topicName = :topicName AND s.projectId = :ownerProjectId"), @NamedQuery(name="SharedTopics.findByTopicAndProjectsIds", query="SELECT s FROM SharedTopics s WHERE s.sharedTopicsPK.topicName = :topicName AND s.projectId = :ownerProjectId AND s.sharedTopicsPK.projectId = :destProjectId")})
public class SharedTopics
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected SharedTopicsPK sharedTopicsPK;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=1000)
    @Column(name="owner_id")
    private @NotNull @Size(min=1, max=1000) Integer projectId;
    @NotNull
    @Column(name="accepted")
    private Boolean accepted;

    public SharedTopics() {
    }

    public SharedTopics(String topicName, int owningId, Integer projectId) {
        this.sharedTopicsPK = new SharedTopicsPK(topicName, projectId);
        this.projectId = owningId;
        this.accepted = false;
    }

    public SharedTopicsPK getSharedTopicsPK() {
        return this.sharedTopicsPK;
    }

    public void setSharedTopicsPK(SharedTopicsPK sharedTopicsPK) {
        this.sharedTopicsPK = sharedTopicsPK;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public Boolean getAccepted() {
        return this.accepted;
    }

    public void setAccepted(Boolean accepted) {
        this.accepted = accepted;
    }

    public int hashCode() {
        int hash = 0;
        hash += this.projectId.intValue();
        return hash += this.sharedTopicsPK != null ? this.sharedTopicsPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SharedTopics)) {
            return false;
        }
        SharedTopics other = (SharedTopics)object;
        if (this.projectId != other.projectId) {
            return false;
        }
        return (this.sharedTopicsPK != null || other.sharedTopicsPK == null) && (this.sharedTopicsPK == null || this.sharedTopicsPK.equals(other.sharedTopicsPK));
    }

    public String toString() {
        return "io.hops.kafka.SharedTopics[ sharedTopicsPK=" + this.sharedTopicsPK + " ] shared to: " + this.projectId;
    }
}

