/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.featurestore.trainingdataset;

import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.activity.FeaturestoreActivity;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.StatisticsConfig;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetFeature;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetFilter;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetJoin;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetType;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.external.ExternalTrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.hopsfs.HopsfsTrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.split.TrainingDatasetSplit;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="training_dataset", catalog="hopsworks")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="TrainingDataset.findAll", query="SELECT td FROM TrainingDataset td"), @NamedQuery(name="TrainingDataset.findById", query="SELECT td FROM TrainingDataset td WHERE td.id = :id"), @NamedQuery(name="TrainingDataset.findByFeaturestore", query="SELECT td FROM TrainingDataset td WHERE td.featurestore = :featurestore"), @NamedQuery(name="TrainingDataset.countByFeaturestore", query="SELECT count(td.id) FROM TrainingDataset td WHERE td.featurestore = :featurestore"), @NamedQuery(name="TrainingDataset.findByFeaturestoreAndId", query="SELECT td FROM TrainingDataset td WHERE td.featurestore = :featurestore AND td.id = :id"), @NamedQuery(name="TrainingDataset.findByFeaturestoreAndNameVersion", query="SELECT td FROM TrainingDataset td WHERE td.featurestore = :featurestore AND td.name= :name AND td.version = :version"), @NamedQuery(name="TrainingDataset.findByFeaturestoreAndName", query="SELECT td FROM TrainingDataset td WHERE td.featurestore = :featurestore AND td.name = :name"), @NamedQuery(name="TrainingDataset.findByFeaturestoreAndNameOrderedByDescVersion", query="SELECT td FROM TrainingDataset td WHERE td.featurestore = :featurestore AND td.name = :name ORDER BY td.version DESC")})
public class TrainingDataset
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @Basic(optional=false)
    @Column(name="name")
    private String name;
    @JoinColumn(name="feature_store_id", referencedColumnName="id")
    @ManyToOne(optional=false)
    private Featurestore featurestore;
    @Basic(optional=false)
    @Column(name="created")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date created;
    @JoinColumn(name="creator", referencedColumnName="uid")
    @ManyToOne(optional=false)
    private Users creator;
    @Basic(optional=false)
    @NotNull
    @Column(name="version")
    private Integer version;
    @Basic(optional=false)
    @NotNull
    @Column(name="data_format")
    private String dataFormat;
    @Basic
    @Column(name="coalesce")
    private Boolean coalesce;
    @Basic(optional=false)
    @Column(name="description")
    private String description;
    @Basic
    @Column(name="seed")
    private Long seed;
    @Basic
    @Column(name="query")
    private boolean query;
    @OneToOne(cascade={CascadeType.ALL}, mappedBy="trainingDataset")
    private StatisticsConfig statisticsConfig;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="trainingDataset")
    private Collection<TrainingDatasetFeature> features;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="trainingDataset")
    private Collection<TrainingDatasetJoin> joins;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="trainingDataset")
    private Collection<TrainingDatasetFilter> filters;
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="training_dataset_type")
    private TrainingDatasetType trainingDatasetType = TrainingDatasetType.HOPSFS_TRAINING_DATASET;
    @JoinColumn(name="hopsfs_training_dataset_id", referencedColumnName="id")
    @OneToOne
    private HopsfsTrainingDataset hopsfsTrainingDataset;
    @JoinColumn(name="external_training_dataset_id", referencedColumnName="id")
    @OneToOne
    private ExternalTrainingDataset externalTrainingDataset;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="trainingDataset")
    private Collection<TrainingDatasetSplit> splits;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="trainingDataset")
    private Collection<FeaturestoreActivity> activities;
    @Basic
    @Column(name="train_split")
    private String trainSplit;

    public static long getSerialVersionUID() {
        return 1L;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Featurestore getFeaturestore() {
        return this.featurestore;
    }

    public void setFeaturestore(Featurestore featurestore) {
        this.featurestore = featurestore;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Users getCreator() {
        return this.creator;
    }

    public void setCreator(Users creator) {
        this.creator = creator;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public Boolean getCoalesce() {
        return this.coalesce;
    }

    public void setCoalesce(Boolean coalesce) {
        this.coalesce = coalesce;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Collection<TrainingDatasetFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(Collection<TrainingDatasetFeature> features) {
        this.features = features;
    }

    public HopsfsTrainingDataset getHopsfsTrainingDataset() {
        return this.hopsfsTrainingDataset;
    }

    public void setHopsfsTrainingDataset(HopsfsTrainingDataset hopsfsTrainingDataset) {
        this.hopsfsTrainingDataset = hopsfsTrainingDataset;
    }

    public ExternalTrainingDataset getExternalTrainingDataset() {
        return this.externalTrainingDataset;
    }

    public void setExternalTrainingDataset(ExternalTrainingDataset externalTrainingDataset) {
        this.externalTrainingDataset = externalTrainingDataset;
    }

    public TrainingDatasetType getTrainingDatasetType() {
        return this.trainingDatasetType;
    }

    public void setTrainingDatasetType(TrainingDatasetType trainingDatasetType) {
        this.trainingDatasetType = trainingDatasetType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<TrainingDatasetSplit> getSplits() {
        return this.splits;
    }

    public void setSplits(Collection<TrainingDatasetSplit> splits) {
        this.splits = splits;
    }

    public Long getSeed() {
        return this.seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public boolean isQuery() {
        return this.query;
    }

    public void setQuery(boolean query) {
        this.query = query;
    }

    public Collection<TrainingDatasetJoin> getJoins() {
        return this.joins;
    }

    public void setJoins(Collection<TrainingDatasetJoin> joins) {
        this.joins = joins;
    }

    public Collection<TrainingDatasetFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<TrainingDatasetFilter> filters) {
        this.filters = filters;
    }

    public Collection<FeaturestoreActivity> getActivities() {
        return this.activities;
    }

    public void setActivities(Collection<FeaturestoreActivity> activities) {
        this.activities = activities;
    }

    public StatisticsConfig getStatisticsConfig() {
        return this.statisticsConfig;
    }

    public void setStatisticsConfig(StatisticsConfig statisticsConfig) {
        this.statisticsConfig = statisticsConfig;
    }

    public String getTrainSplit() {
        return this.trainSplit;
    }

    public void setTrainSplit(String trainSplit) {
        this.trainSplit = trainSplit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainingDataset that = (TrainingDataset)o;
        if (this.query != that.query) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.featurestore, that.featurestore)) {
            return false;
        }
        if (!Objects.equals(this.created, that.created)) {
            return false;
        }
        if (!Objects.equals(this.creator, that.creator)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        if (!Objects.equals(this.dataFormat, that.dataFormat)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.seed, that.seed)) {
            return false;
        }
        if (!Objects.equals(this.features, that.features)) {
            return false;
        }
        if (!Objects.equals(this.joins, that.joins)) {
            return false;
        }
        if (!Objects.equals(this.filters, that.filters)) {
            return false;
        }
        if (this.trainingDatasetType != that.trainingDatasetType) {
            return false;
        }
        if (!Objects.equals(this.hopsfsTrainingDataset, that.hopsfsTrainingDataset)) {
            return false;
        }
        if (!Objects.equals(this.externalTrainingDataset, that.externalTrainingDataset)) {
            return false;
        }
        if (!Objects.equals(this.trainSplit, that.trainSplit)) {
            return false;
        }
        return Objects.equals(this.splits, that.splits);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.featurestore != null ? this.featurestore.hashCode() : 0);
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 31 * result + (this.creator != null ? this.creator.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.dataFormat != null ? this.dataFormat.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.seed != null ? this.seed.hashCode() : 0);
        result = 31 * result + (this.query ? 1 : 0);
        result = 31 * result + (this.features != null ? this.features.hashCode() : 0);
        result = 31 * result + (this.joins != null ? this.joins.hashCode() : 0);
        result = 31 * result + (this.filters != null ? this.filters.hashCode() : 0);
        result = 31 * result + (this.trainingDatasetType != null ? this.trainingDatasetType.hashCode() : 0);
        result = 31 * result + (this.hopsfsTrainingDataset != null ? this.hopsfsTrainingDataset.hashCode() : 0);
        result = 31 * result + (this.externalTrainingDataset != null ? this.externalTrainingDataset.hashCode() : 0);
        result = 31 * result + (this.splits != null ? this.splits.hashCode() : 0);
        result = 31 * result + (this.trainSplit != null ? this.trainSplit.hashCode() : 0);
        return result;
    }
}

