/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.user.security.apiKey;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public enum ApiScope {
    JOB(false),
    DATASET_VIEW(false),
    DATASET_CREATE(false),
    DATASET_DELETE(false),
    FEATURESTORE(false),
    SERVING(false),
    PROJECT(false),
    ADMIN(true),
    KAFKA(false),
    ADMINISTER_USERS(true),
    ADMINISTER_USERS_REGISTER(true),
    MODELREGISTRY(false),
    USER(false);

    private final boolean privileged;

    private ApiScope(boolean privileged) {
        this.privileged = privileged;
    }

    public static ApiScope fromString(String param) {
        return ApiScope.valueOf(param.toUpperCase());
    }

    public static Set<ApiScope> getAll() {
        return new HashSet<ApiScope>(Arrays.asList(ApiScope.values()));
    }

    public static Set<ApiScope> getPrivileged() {
        return Arrays.stream(ApiScope.values()).filter(as -> as.privileged).collect(Collectors.toSet());
    }

    public static Set<ApiScope> getUnprivileged() {
        return Arrays.stream(ApiScope.values()).filter(as -> !as.privileged).collect(Collectors.toSet());
    }
}

