/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.jupyter;

import io.hops.hopsworks.persistence.entity.project.Project;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="jupyter_project", catalog="hopsworks", schema="")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="JupyterProject.findAll", query="SELECT j FROM JupyterProject j"), @NamedQuery(name="JupyterProject.findByPort", query="SELECT j FROM JupyterProject j WHERE j.port = :port"), @NamedQuery(name="JupyterProject.findByHdfsUserIdAndPort", query="SELECT j FROM JupyterProject j WHERE j.hdfsUserId = :hdfsUserId AND j.port = :port"), @NamedQuery(name="JupyterProject.findByHdfsUserId", query="SELECT j FROM JupyterProject j WHERE j.hdfsUserId = :hdfsUserId"), @NamedQuery(name="JupyterProject.findByCreated", query="SELECT j FROM JupyterProject j WHERE j.created = :created"), @NamedQuery(name="JupyterProject.findByToken", query="SELECT j FROM JupyterProject j WHERE j.token = :token"), @NamedQuery(name="JupyterProject.findByCid", query="SELECT j FROM JupyterProject j WHERE j.cid = :cid")})
public class JupyterProject
implements Serializable {
    @Basic(optional=false)
    @NotNull
    @Column(name="cid")
    private String cid;
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="port")
    private Integer port;
    @Basic(optional=false)
    @NotNull
    @Column(name="created")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date created;
    @Basic(optional=false)
    @NotNull
    @Column(name="expires")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date expires;
    @Basic(optional=false)
    @NotNull
    @Size(min=20, max=64)
    @Column(name="secret")
    private @NotNull @Size(min=20, max=64) String secret;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="token")
    private @NotNull @Size(min=1, max=255) String token;
    @JoinColumn(name="project_id", referencedColumnName="id")
    @ManyToOne(optional=false)
    private Project projectId;
    @Basic(optional=false)
    @NotNull
    @Column(name="hdfs_user_id")
    private int hdfsUserId;
    @Basic(optional=false)
    @NotNull
    @Column(name="no_limit")
    private boolean noLimit;
    @Transient
    private long minutesUntilExpiration;

    public JupyterProject() {
    }

    public JupyterProject(Project project, String secret, Integer port, int hdfsUserId, String hostIp, String token, String cid, Date expires, boolean noLimit) {
        this.projectId = project;
        this.secret = secret;
        this.port = port;
        this.hdfsUserId = hdfsUserId;
        this.created = new Date();
        this.expires = expires;
        this.token = token;
        this.cid = cid;
        this.noLimit = noLimit;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public int getHdfsUserId() {
        return this.hdfsUserId;
    }

    public void setHdfsUserId(int hdfsUserId) {
        this.hdfsUserId = hdfsUserId;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getExpires() {
        return this.expires;
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Project getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Project projectId) {
        this.projectId = projectId;
    }

    public String getCid() {
        return this.cid;
    }

    public void setCid(String cid) {
        this.cid = cid;
    }

    public long getMinutesUntilExpiration() {
        return this.minutesUntilExpiration;
    }

    public void setMinutesUntilExpiration(long minutesUntilExpiration) {
        this.minutesUntilExpiration = minutesUntilExpiration;
    }

    public boolean isNoLimit() {
        return this.noLimit;
    }

    public void setNoLimit(boolean noLimit) {
        this.noLimit = noLimit;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.port != null ? this.port.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JupyterProject)) {
            return false;
        }
        JupyterProject other = (JupyterProject)object;
        return (this.port != null || other.port == null) && (this.port == null || this.port.equals(other.port));
    }

    public String toString() {
        return "io.hops.hopsworks.persistence.entity.jupyter.JupyterProject[ port=" + this.port + " ]";
    }
}

