/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.kagent;

import io.hops.hopsworks.persistence.entity.host.Health;
import io.hops.hopsworks.persistence.entity.host.Hosts;
import io.hops.hopsworks.persistence.entity.host.ServiceStatus;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="host_services", catalog="hopsworks")
@NamedQueries(value={@NamedQuery(name="HostServices.findGroups", query="SELECT DISTINCT r.group FROM HostServices r"), @NamedQuery(name="HostServices.findByHostnameServiceNameGroup", query="SELECT r FROM HostServices r WHERE r.group = :group AND r.name = :name AND r.host.hostname = :hostname"), @NamedQuery(name="HostServices.findByHostname", query="SELECT r FROM HostServices r WHERE r.host.hostname = :hostname ORDER BY r.group, r.name"), @NamedQuery(name="HostServices.findByGroup", query="SELECT r FROM HostServices r WHERE r.group = :group "), @NamedQuery(name="HostServices.findByServiceName", query="SELECT r FROM HostServices r WHERE r.name = :name"), @NamedQuery(name="HostServices.CountServices", query="SELECT COUNT(r) FROM HostServices r WHERE r.group = :group"), @NamedQuery(name="HostServices.findByServiceNameAndHostname", query="SELECT r FROM HostServices r WHERE r.host.hostname = :hostname AND r.name = :name")})
public class HostServices
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Long id;
    @Column(name="pid")
    private Integer pid;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=48)
    @Column(name="group_name")
    private @NotNull @Size(min=1, max=48) String group;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=48)
    @Column(name="name")
    private @NotNull @Size(min=1, max=48) String name;
    @Basic(optional=false)
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="status")
    private ServiceStatus status;
    @Column(name="uptime")
    private Long uptime;
    @Column(name="startTime")
    private Long startTime;
    @Column(name="stopTime")
    private Long stopTime;
    @JoinColumn(name="host_id", referencedColumnName="id")
    @ManyToOne
    private Hosts host;

    public HostServices() {
    }

    public HostServices(Long id) {
        this.id = id;
    }

    public HostServices(Long id, String name, String group, ServiceStatus status, Hosts host) {
        this.id = id;
        this.name = name;
        this.group = group;
        this.status = status;
        this.host = host;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getPid() {
        return this.pid;
    }

    public void setPid(Integer pid) {
        this.pid = pid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public ServiceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ServiceStatus status) {
        this.status = status;
    }

    public Long getUptime() {
        return this.uptime;
    }

    public void setUptime(Long uptime) {
        this.uptime = uptime;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(Long stopTime) {
        this.stopTime = stopTime;
    }

    public Hosts getHost() {
        return this.host;
    }

    public void setHost(Hosts host) {
        this.host = host;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HostServices)) {
            return false;
        }
        HostServices other = (HostServices)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "Services[ id=" + this.id + " ]";
    }

    public Health getHealth() {
        if (this.status == ServiceStatus.Failed || this.status == ServiceStatus.Stopped) {
            return Health.Bad;
        }
        return Health.Good;
    }
}

