/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation;

import com.google.common.base.Strings;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.Expectation;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.jaxb.JAXBContextFactory;

@Converter
public class RuleAssertionsConverter
implements AttributeConverter<Expectation, String> {
    private static final Logger LOGGER = Logger.getLogger(RuleAssertionsConverter.class.getName());
    private static JAXBContext ruleAssertionsJAXBContext;

    public String convertToDatabaseColumn(Expectation config) {
        try {
            Marshaller marshaller = ruleAssertionsJAXBContext.createMarshaller();
            marshaller.setProperty("eclipselink.json.include-root", (Object)false);
            marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            StringWriter sw = new StringWriter();
            marshaller.marshal((Object)config, (Writer)sw);
            return sw.toString();
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    public Expectation convertToEntityAttribute(String jsonConfig) {
        if (Strings.isNullOrEmpty((String)jsonConfig)) {
            return null;
        }
        try {
            return this.unmarshal(jsonConfig);
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    private Expectation unmarshal(String jsonConfig) throws JAXBException {
        Unmarshaller unmarshaller = ruleAssertionsJAXBContext.createUnmarshaller();
        StreamSource json = new StreamSource(new StringReader(jsonConfig));
        unmarshaller.setProperty("eclipselink.json.include-root", (Object)false);
        unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        return (Expectation)unmarshaller.unmarshal((Source)json, Expectation.class).getValue();
    }

    static {
        try {
            ruleAssertionsJAXBContext = JAXBContextFactory.createContext((Class[])new Class[]{Expectation.class}, null);
        }
        catch (JAXBException e) {
            LOGGER.log(Level.SEVERE, "An error occurred while initializing JAXBContext", e);
        }
    }
}

