/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.git;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.hops.hopsworks.persistence.entity.git.GitOpExecution;
import io.hops.hopsworks.persistence.entity.git.config.GitProvider;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@Entity
@Table(name="git_repositories", catalog="hopsworks")
@NamedQueries(value={@NamedQuery(name="GitRepository.findAllInProject", query="SELECT r FROM GitRepository r WHERE r.project = :project"), @NamedQuery(name="GitRepository.findById", query="SELECT r FROM GitRepository r WHERE r.id = :id"), @NamedQuery(name="GitRepository.findByInode", query="SELECT r FROM GitRepository r WHERE r.inode = :inode"), @NamedQuery(name="GitRepository.findAllWithRunningOperation", query="SELECT r FROM GitRepository r WHERE r.cid IS NOT NULL"), @NamedQuery(name="GitRepository.findByIdAndProject", query="SELECT r FROM GitRepository r WHERE r.id = :id AND r.project = :project")})
public class GitRepository
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @JoinColumns(value={@JoinColumn(name="inode_pid", referencedColumnName="parent_id"), @JoinColumn(name="inode_name", referencedColumnName="name"), @JoinColumn(name="partition_id", referencedColumnName="partition_id")})
    @ManyToOne(optional=false)
    private Inode inode;
    @JoinColumn(name="project", referencedColumnName="id")
    @ManyToOne(optional=false)
    @NotNull
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Project project;
    @Basic(optional=false)
    @NotNull
    @Column(name="provider")
    @Enumerated(value=EnumType.STRING)
    private GitProvider gitProvider;
    @Size(max=255)
    @Column(name="current_branch")
    private @Size(max=255) String currentBranch;
    @Size(max=255)
    @Column(name="current_commit")
    private @Size(max=255) String currentCommit;
    @Column(name="cid")
    private String cid;
    @JoinColumn(name="creator", referencedColumnName="uid")
    @ManyToOne(optional=false)
    @NotNull
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private Users creator;

    public GitRepository() {
    }

    public GitRepository(Inode inode, Project project, GitProvider gitProvider, Users creator) {
        this.inode = inode;
        this.project = project;
        this.gitProvider = gitProvider;
        this.creator = creator;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Inode getInode() {
        return this.inode;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setInode(Inode inode) {
        this.inode = inode;
    }

    public GitProvider getGitProvider() {
        return this.gitProvider;
    }

    public void setGitProvider(GitProvider gitProvider) {
        this.gitProvider = gitProvider;
    }

    public String getCid() {
        return this.cid;
    }

    public void setCid(String pid) {
        this.cid = pid;
    }

    public String getCurrentBranch() {
        return this.currentBranch;
    }

    public void setCurrentBranch(String currentBranch) {
        this.currentBranch = currentBranch;
    }

    public String getCurrentCommit() {
        return this.currentCommit;
    }

    public void setCurrentCommit(String currentHead) {
        this.currentCommit = currentHead;
    }

    public Users getCreator() {
        return this.creator;
    }

    public void setCreator(Users creator) {
        this.creator = creator;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GitOpExecution)) {
            return false;
        }
        GitRepository other = (GitRepository)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }
}

