/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.git;

import com.google.common.base.Strings;
import io.hops.hopsworks.persistence.entity.git.config.GitCommandConfiguration;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.jaxb.JAXBContextFactory;

@Converter
public class GitCommandConfigurationConverter
implements AttributeConverter<GitCommandConfiguration, String> {
    private static final Logger LOGGER = Logger.getLogger(GitCommandConfiguration.class.getName());
    private static JAXBContext commandConfigurationContext;

    public String convertToDatabaseColumn(GitCommandConfiguration commandConfiguration) {
        try {
            Marshaller marshaller = commandConfigurationContext.createMarshaller();
            marshaller.setProperty("eclipselink.json.include-root", (Object)false);
            marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            StringWriter sw = new StringWriter();
            marshaller.marshal((Object)commandConfiguration, (Writer)sw);
            return sw.toString();
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    public GitCommandConfiguration convertToEntityAttribute(String jsonConfig) {
        if (Strings.isNullOrEmpty((String)jsonConfig)) {
            return null;
        }
        try {
            Unmarshaller unmarshaller = commandConfigurationContext.createUnmarshaller();
            StreamSource json = new StreamSource(new StringReader(jsonConfig));
            unmarshaller.setProperty("eclipselink.json.include-root", (Object)false);
            unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            return (GitCommandConfiguration)unmarshaller.unmarshal((Source)json, GitCommandConfiguration.class).getValue();
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        try {
            commandConfigurationContext = JAXBContextFactory.createContext((Class[])new Class[]{GitCommandConfiguration.class}, null);
        }
        catch (JAXBException e) {
            LOGGER.log(Level.SEVERE, "An error occurred while initializing JAXBContext", e);
        }
    }
}

