/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.alertmanager;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlEnum;

@XmlEnum
public enum AlertType {
    DEFAULT("DEFAULT", "default", "default"),
    SYSTEM_ALERT("SYSTEM_ALERT", "system-alert", ""),
    GLOBAL_ALERT_EMAIL("GLOBAL_ALERT_EMAIL", "global-alert-email", "global-receiver__email"),
    GLOBAL_ALERT_SLACK("GLOBAL_ALERT_SLACK", "global-alert-slack", "global-receiver__slack"),
    GLOBAL_ALERT_PAGERDUTY("GLOBAL_ALERT_PAGERDUTY", "global-alert-pagerduty", "global-receiver__pagerduty"),
    GLOBAL_ALERT_PUSHOVER("GLOBAL_ALERT_PUSHOVER", "global-alert-pushover", "global-receiver__pushover"),
    GLOBAL_ALERT_OPSGENIE("GLOBAL_ALERT_OPSGENIE", "global-alert-opsgenie", "global-receiver__opsgenie"),
    GLOBAL_ALERT_WEBHOOK("GLOBAL_ALERT_WEBHOOK", "global-alert-webhook", "global-receiver__webhook"),
    GLOBAL_ALERT_VICTOROPS("GLOBAL_ALERT_VICTOROPS", "global-alert-victorops", "global-receiver__victorops"),
    GLOBAL_ALERT_WEBCHAT("GLOBAL_ALERT_WEBCHAT", "global-alert-wechat", "global-receiver__wechat"),
    PROJECT_ALERT("PROJECT_ALERT", "project-alert", "");

    private final String name;
    private final String value;
    private final String receiverName;
    private static final Map<String, AlertType> lookup;
    private static final Map<String, AlertType> lookupReceiver;

    private AlertType(String name, String value, String receiverName) {
        this.name = name;
        this.value = value;
        this.receiverName = receiverName;
    }

    public static AlertType fromString(String name) {
        return AlertType.valueOf(name.toUpperCase());
    }

    public static AlertType fromValue(String value) {
        return lookup.get(value);
    }

    public static AlertType fromReceiverName(String receiverName) {
        return lookupReceiver.get(receiverName);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getReceiverName() {
        return this.receiverName;
    }

    public boolean isGlobal() {
        return !this.equals((Object)DEFAULT) && !this.equals((Object)SYSTEM_ALERT) && !this.equals((Object)PROJECT_ALERT);
    }

    static {
        lookup = new HashMap<String, AlertType>();
        lookupReceiver = new HashMap<String, AlertType>();
        for (AlertType a : AlertType.values()) {
            lookup.put(a.value, a);
            if (a.receiverName.equals("")) continue;
            lookupReceiver.put(a.receiverName, a);
        }
    }
}

