/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.persistence.entity.git;

import io.hops.hopsworks.persistence.entity.git.GitRepository;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@Entity
@Table(name="git_commits", catalog="hopsworks")
@NamedQueries(value={@NamedQuery(name="GitCommit.findAllForBranchAndRepository", query="SELECT gc FROM GitCommit gc WHERE gc.branch = :branch AND gc.repository = :repository ORDER BY gc.id"), @NamedQuery(name="GitCommit.findById", query="SELECT gc FROM GitCommit gc WHERE gc.id = :id"), @NamedQuery(name="GitCommit.findByCommitHashAndRepository", query="SELECT gc FROM GitCommit gc WHERE gc.repository = :repository AND gc.hash = :hash"), @NamedQuery(name="GitCommit.deleteAllForBranchAndRepository", query="DELETE FROM GitCommit gc WHERE gc.branch = :branch AND gc.repository = :repository"), @NamedQuery(name="GitCommit.findBranchesForRepository", query="SELECT DISTINCT gc.branch FROM GitCommit gc WHERE gc.repository = :repository ORDER BY gc.date DESC")})
public class GitCommit
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @JoinColumn(name="repository", referencedColumnName="id")
    @ManyToOne(optional=false)
    @NotNull
    private GitRepository repository;
    @Basic(optional=false)
    @NotNull
    @Size(max=255)
    @Column(name="branch")
    private @NotNull @Size(max=255) String branch;
    @Basic(optional=false)
    @NotNull
    @Size(max=1000)
    @Column(name="committer_name")
    private @NotNull @Size(max=1000) String name;
    @Basic(optional=false)
    @NotNull
    @Size(max=1000)
    @Column(name="committer_email")
    private @NotNull @Size(max=1000) String email;
    @Basic(optional=false)
    @NotNull
    @Size(max=255)
    @Column(name="hash")
    private @NotNull @Size(max=255) String hash;
    @Basic(optional=false)
    @NotNull
    @Size(max=1000)
    @Column(name="message")
    private @NotNull @Size(max=1000) String message;
    @Column(name="date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date date;

    public GitCommit() {
    }

    public GitCommit(GitRepository repository, String branch, String name, String email, String hash, String message, Date date) {
        this.repository = repository;
        this.branch = branch;
        this.name = name;
        this.email = email;
        this.hash = hash;
        this.message = message;
        this.date = date;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public GitRepository getRepository() {
        return this.repository;
    }

    public void setRepository(GitRepository repository) {
        this.repository = repository;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
}

